/*++
/* NAME
/*	path
/* SUMMARY
/*	system-dependent file name definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	general
/* SYNOPSIS
/*	#include "path.h"
/* DESCRIPTION
/*	File-system dependent definitions should be changed here.
/* .nf

 /* the minmal number of open files we think we need */

#define	MINFILES	10

 /* system-dependent defaults */

#ifdef	unix
#define	THISDIR		"."		/* current directory */
#define	PATHSEP		"/"		/* path-element separator */
#define	DEFSPOOL	"./spool"	/* default spool directory */
#define	DEFEDIT		"vi"		/* default editor */
#ifdef SIII
#define	DEFPRINT	"lp"		/* printer spooler */
#else
#define	DEFPRINT	"lpr"		/* printer spooler */
#endif
#define	MAILFILE	"mail.msg"	/* temporary message file */
#define	TMPALIAS	"tmp.alias"	/* temp alias file */
#define	NULLDEV		"/dev/null"	/* bit dump */
#endif

#ifdef	MSDOS
#define	THISDIR		"."		/* current directory */
#define	PATHSEP		"\\"		/* path-element separator */
#define	DEFSPOOL	"\\spool"	/* spool directory */
#define	DEFEDIT		"edlin"		/* default editor */
#define DEFPRINT	"PRN"		/* default printer */
#define	MAILFILE	"mail.msg"	/* temp message file */
#define	TMPALIAS	"alias.tmp"	/* temp alias file */
#define	NULLDEV		"NUL"		/* bit dump */
#endif

 /* system-dependent function calls for file & printer access */

#ifdef unix
#define	propen()	popen(mailprn,"w")	/* open print stream */
#define	prclose(p)	pclose(p)	/* close print stream */
#define	fspool(file)	strcons("%s/%s",maildir,file)
#endif

#ifdef MSDOS
#define	propen()	fopen(mailprn,"a")	/* open print stream */
#define	prclose(p)	(putc('\014',p),fclose(p))	/* close print stream */
#define	fspool(file)	strcons("%s\\%s",maildir,file)
#endif

#if (!defined(unix)&& !defined(MSDOS))
"Specify here how things should be handled with your compiler"
#endif

 /* system-independent file names */

#define	SMAIL	"smail"			/* queues a mail message */
#define	CICO	"cico"			/* file transfer program */
#define	NMAIL	"nmail"			/* extract originator address */

 /*
  * The spool directory is used for storage of all files manipulated by the
  * mail programs. Message files should always have a meta file with
  * information about the destination or origin of a message file.
  * 
  * Message/meta file names are of the form <letter><sequence number>.
  * Corresponding message/meta files have the same sequene number. The
  * following definitions are for the <letter> part of spool files.
  */

#define	LOGFILE		"LOGFILE"	/* transaction logs */
#define	HEADER		"header"	/* template message header */
#define	TRAILER 	"trailer"	/* template message trailer */

#define	NEW_MESG	'n'		/* received message */
#define	NEW_META	'h'		/* originator of new mail */

#define	OLD_MESG	'n'		/* received message */
#define	OLD_META	'o'		/* originator of old mail */

#define	OUT_MESG	'd'		/* message ready to be sent */
#define	OUT_META	'x'		/* its destination */

#define	SENT_MESG	'q'		/* delivered message */
#define	SENT_META	'r'		/* its destination */

#define	WORK_MESG	'e'		/* message being worked on */
#define	WORK_META	'c'		/* its description */

#define	SETUP		's'		/* system parameter file */

#define	ALIAS		'a'		/* alias data base */

#define	SPOOLFMT	"%c%05u"	/* spool-file name format */
#define	NAMELEN		6		/* length of spool file name */

unsigned newseqno();			/* generate sequence number */
unsigned seqno();			/* extract seq. nr. from name */

 /*
  * The following macros provide convenient access of spool files, so we
  * don't have to remember the spool file name format and prefix stuff.
  */

#define	sendmail(file,to)	spoolfil(file,to,OUT_MESG,OUT_META)
#define	workon(fname,meta)	spoolfil(fname,meta,WORK_MESG,WORK_META)

#define	parm_file()		fspool(strcons(SPOOLFMT,SETUP,0))
#define	aliases()		fspool(strcons(SPOOLFMT,ALIAS,0))
#define logfile()		fspool(LOGFILE)
#define	header_file()		fspool(HEADER)
#define	trailer_file()		fspool(TRAILER)

#define meta_file(type,id)	fspool(strcons(SPOOLFMT,type,id))
#define mesg_file(type,id)	fspool(strcons(SPOOLFMT,type,id))

#define	work_meta(id)		fspool(strcons(SPOOLFMT,WORK_META,id))
#define	work_mesg(id)		fspool(strcons(SPOOLFMT,WORK_MESG,id))

#define	old_mesg(id)		fspool(strcons(SPOOLFMT,OLD_MESG,id))
#define	old_meta(id)		fspool(strcons(SPOOLFMT,OLD_META,id))

#define	new_mesg(id)		fspool(strcons(SPOOLFMT,NEW_MESG,id))
#define	new_meta(id)		fspool(strcons(SPOOLFMT,NEW_META,id))

#define	out_mesg(id)		fspool(strcons(SPOOLFMT,OUT_MESG,id))
#define out_meta(id)		fspool(strcons(SPOOLFMT,OUT_META,id))

#define	sent_mesg(id)		fspool(strcons(SPOOLFMT,SENT_MESG,id))
#define sent_meta(id)		fspool(strcons(SPOOLFMT,SENT_META,id))

 /* stuff taken from the environment */

extern char *editor;			/* path to editor */
extern char *maildir;			/* spool directory */
extern char *mailprn;			/* how to print */
extern char *mailcmd;			/* do this on exit */

extern int pathinit();			/* get path info from environment */

/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Apr  5 13:23:45 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:27
/* VERSION/RELEASE
/*	2.1
/*--*/
