/*++
/* NAME
/*      path 3
/* SUMMARY
/*      system-dependent file name stuff
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      general
/* SYNOPSIS
/*	#include "str.h"
/*      #include "path.h"
/*
/*      int pathinit()
/*
/*      FILE *propen()
/*
/*      char *fspool(file)
/*      char *file;
/* DESCRIPTION
/*      The routines in this module know the system-dependent rules
/*      for file names and printers.
/*
/*      pathinit() extracts the values of the environment variables
/*      MAILDIR, MAILPRN, MAILCMD and EDITOR, and assumes system-dependent 
/*	defaults for undefined environment variables. It checks for the 
/*      existence of the spool directory.
/*
/*	Under Unix, the MAILPRN environment variable should be the name
/*	of a command. Under MS-DOS, it should be the name of a device or file.
/*
/*      propen() returns a stream to print to.
/*
/*      fspool() constructs a path name from the spool directory and 
/*	the file name in its argument.
/*	Real unix uses uucp spool file names of the form 
/*
/*		<letter> . <system> <grade> <sequence_nr>
/*
/*	This is problematic for MS-DOS and similar systems that
/*	only allow three characters after the dot. Instead of building
/*	a tiny file system on top of MS-DOS, the pc-mail programs
/*	use a different way of spool file naming:
/*
/*		<letter> <sequence_nr>
/*
/*	This scheme assumes that the pc has access to exactly one unix
/*	host, since the host name is not part of spool file names.
/* COMMANDS
/*      lp(1)  (under unix) printer spooler program
/* FILES
/*      PRN     under MS-DOS
/* DIAGNOSTICS
/*      pathinit() returns a nonzero value (see status(5)) if one of the 
/*	environment variables (or defaults) are incorrect.
/*
/*      File open functions return a null pointer when a file could not
/*      be opened.
/* BUGS
/*	pathinit() only verifies the MAILDIR name.
/*
/*      fspool() returns a pointer to static memory.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sun Apr  5 15:27:37 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:26
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <sys/types.h>
#include <sys/stat.h>
#include "defs.h"
#include "path.h"
#include "status.h"

 /*
  * Environment variables are loaded here. Most of them have a default; We
  * only check the validity of the MAILDIR variable.
  */

public char *maildir = DEFSPOOL;	/* spool directory */
public char *editor  = DEFEDIT;		/* editor program */
public char *mailprn = DEFPRINT;	/* where to print to */
public char *mailcmd = 0;		/* do this on exit */

typedef struct {
    char   *vname;
    char  **ptr;
} Environ;

static Environ env[] = {
    "SPOOL",	&maildir,		/* backwards compatibility... */
    "MAILDIR",	&maildir,
    "EDITOR",	&editor,
    "MAILPRN",	&mailprn,
    "MAILCMD",	&mailcmd,
    0,		0,			/* terminator */
};

/* pathinit - consult the environment; checks existence of spool directory */

public int pathinit()
{
    register char *cp;
    struct stat s;
    register Environ *ep;

    /* load environment variables */

    for (ep = env; ep->vname; ep++)
	if (cp = getenv(ep->vname))
	    *(ep->ptr) = cp;

    /* check existence of the spool directory */

    return (stat(maildir, &s) || (s.st_mode & S_IFMT) != S_IFDIR ? E_NOSPOOL : 0);
}
