/*++
/* NAME
/*      makework 3
/* SUMMARY
/*      save the file currently being displayed as a work file
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      mail
/* SYNOPSIS
/*	#include "mail.h"
/*
/*      int makework()
/* DESCRIPTION
/*      makework() is invoked when the user wants to capture something
/*	in a work file (i.e. something that will probably be sent
/*	as mail lateron). It asks for a one-line summary (to 
/*	identify the work file in the main menu) and creates the
/*	the necessary files in the spool directory.
/*
/*	The name of the source file is taken from the global string
/*	message[].
/* FUNCTIONS AND MACROS
/*	kbdinp(), junk_desk()
/* FILES
/*      A work file and meta file in the spool directory.
/* SEE ALSO
/*      pager(3), pager(5), kbdinp(3)
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Mon Apr  4 12:29:18 MET 1988
/* LAST MODIFICATION
/*	90/01/22 13:02:10
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "defs.h"
#include "path.h"
#include "screen.h"
#include "mail.h"

hidden int install_work();

/* makework - ask for an summary for message to work on */

public int makework()
{
    static Screen screen[] = {
	STRING,	0,	install_work,	int_error,
	0,	0,	0,
	getsummary,
    };
    kbdinp(screen);				/* ask for destination */
    return(S_REDRAW);				/* say screen has changed */
}

/* install_work - install meta file and work copy */

hidden int install_work(summary)
char   *summary;
{
    register int stat;

    if (stat = workon(message, summary)) {
	errdisp(stat);				/* cannot create work file */
	return (S_BREAK | S_REDRAW);		/* redisplay, stop caller */
    } else {
	junk_desk();				/* junk message display */
	return (S_BREAK);			/* terminate caller */
    }
}
