.TL
uucp k protocol description
.AU
W.Z. Venema
Eindhoven University of Technology
.AE
.NH
Introduction
.LP
The k protocol has been developed for the Sytek Localnet local area
network at the Eindhoven University of Technology (TUE).
Main features of this network are:
.IP     1
Network partners may talk at different baudrates. This implies that the network
does some buffering. This may cause timing
problems (e.g. a system sending at 9600 baud to a system reading at 1200 baud).
.IP     2
The network needs a flow control mechanism. Usually this is
based on the XON/XOFF protocol. Other control character sequences are used
for commands to the network.
.IP     3
Some network stations are connected to telephone modems.
.LP
For these reasons, the k protocol must (i) cope with on XON/XOFF flow
control, (ii) be suitable for 7-bit data paths, (iii) avoid
control characters and (iv) provide reliable operation
over telephone lines as well as over the local area network.
.NH
Packets
.LP
Data are sent as checksummed 256-byte packets, terminated by an
ASCII CR. Except for the packet header (^P), the k protocol only uses
ASCII codes 040 through 0137. Three data bytes are expanded to four
bytes upon transmission. Theoretically, this reduces throughput by 25 percent.
At 1200 baud, actual performances are:
.DS
uucp, g protocol	110 cps
uucp, k protocol	74 cps
c-kermit		67 cps
.DE
Note that the values for c-kermit are for text files, with repeat-count
compression enabled.
.PP
The packet types are a subset of those used in the kermit programs:
.DS
D packets contain data.
Y packets are sent when a correct data packet was received.
N packets are sent when incorrect data was received.
A packets are sent to shut down the k protocol.
.DE
A packet always begins with a header:
.DS
SOH     packet header, ASCII control-P
len     (size of data, low 6 bits) + 32
len     (size of data, high 6 bits) + 32
num     (packet number mod 64) + 32
type    packet type
check   one-byte type-1 kermit checksum
.DE
.LP
The header is followed by checksummed data if len > 0:
.DS
data    len data bytes
check1  (upper 2 bits of type-3 kermit 16-bit checksum) + 32
check2  (middle 6 bits of type-3 kermit 16-bit checksum) + 32
check3  (lower 6 bits of type-3 kermit 16-bit checksum) + 32
.DE
.LP
Every packet is followed by an ASCII carriage return, which is
ignored upon reception of a packet. It prevents timeout errors
when one byte gets lost (the most common case).
.NH
Handshake
.LP
Handshake is on a per-packet basis; a transmitter will not send
another data packet before it knows that the receiver got the data
in good condition. There are various ways to obtain that knowledge:
the receiver may send an ACK message (usual case), or a NAK for
the next data packet, or a data packet with the next sequence number.
.PP
The protocol is aborted when an unexpected
packet type or when a packet out of sequence is received.
Since 'A' packets are never expected, they always cause a protocol
fault.
