/*++
/* NAME
/*	gp 5
/* SUMMARY
/*	g-protocol internal definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	cico
/* SYNOPSIS
/*	#include "gp.h"
/* DESCRIPTION
/* .nf

 /* include-once file */

#ifndef	GP
#define	GP

#include <stdio.h>			/* needed for stderr */

#define	MAXTRY		10		/* max nr of retries */
#define	CTRL(x)		((x)^0100)	/* for ascii control characters */
#define	MIN(x,y)	((x) < (y) ? (x) : (y))
#define	MAX(x,y)	((x) > (y) ? (x) : (y))

#define	ALARM		10		/* time-out interval */
#define	MAGIC		0xAAAA		/* checksum magic number */
#define	KCTRL		9		/* control packet */

#define	FAIL		(-1)		/* corrupted packet */
#define	TIME		(-2)		/* timed out */

 /* 
  * The protocol is defined in terms of message transmissions of 8-bit
  * bytes. Each message includes one control byte plus a data segment
  * of zero or more information bytes. (...)
  * The control byte is partitioned into three fields as depicted below.
  *	bit	7	6	5	4	3	2	1	0
  *		t	t	x	x	x	y	y	y
  * The t bits indicate a packet type and determine the interpretation
  * to be placed on the xxx and yyy the fields. The various interpretations
  * are as follows:
  *	tt	interpretation
  *	00	control packet
  *	10	data packet
  *	11	short data packet
  *	01	alternate channel
  * A data segment accompanies all non-control packets. (...) Type 01 packets
  * are never used by UUCP (...)
  */

#define	TYPE(x)		((x)&0300)	/* extract message field */

#define	CONTROL		0000		/* control message */
#define	DATA		0200		/* data, fixed size */
#define	SHORT		0300		/* short (variable) length data */
#define	ALTCH		0100		/* alternate channel (unused) */

 /*
  * The sequence number of a non-control packet is given by the xxx field.
  * Control packets are not sequenced. The newest sequence number,
  * excluding duplicate transmissions, accepted by a receiver is placed in 
  * the yyy field of non-control packets sent to the `other' receiver.
  */

#define	TVAL(x)		(((x)&0377)>>6)	/* extract message type */
#define	MVAL(x)		(((x)&070)>>3)	/* extract control message */
#define	SVAL(x)		(((x)&070)>>3)	/* extract S(equence) value */
#define	RVAL(x)		((x)&07)	/* extract R(received) value */
#define	IVAL(x)		((x)&07)	/* extract init value */
#define	SFLD(x)		(((x)&07)<<3)	/* create S(equence) field */
#define	RFLD(x)		((x)&07)	/* create R(received) field */
#define	IFLD(x)		((x)&07)	/* create init field */

 /*
  * There are no data bytes associated with a control packet, the xxx field
  * is interpreted as a control message, and the yyy field is a value 
  * accompanying the control message. The control messages are listed
  * below in decreasing priority. That is, if several control messags
  * are to be sent, the lower-numbered ones are sent first.
  *	xxx	name	yyy
  *	1	CLOSE	n/a
  *	2	RJ	last correctly received sequence number
  *	3	SRJ	sequence number to retransmit
  *	4	RR	last correctly received sequence number
  *	5	INITC	window size
  *	6	INITB	data segment size
  *	7	INITA	window size
  */

#define	MESG(x)		((x)&070)	/* extract control message field */

#define	CLOSE		0010		/* close message */
#define	RJ		0020		/* reject message */
#define	SRJ		0030		/* selective-reject message (unused) */
#define	RR		0040		/* received ok message */
#define	INITC		0050		/* initialization message */
#define	INITB		0060		/* initialization message */
#define	INITA		0070		/* initialization message */

 /* declarations for tiny systems without tty driver, timer support etc. */

#ifndef	unix

#define	read		xread
#define	write		xwrite
#define	alarm(x)	/* nothing */
#define	signal(x,y)	/* nothing */
#define	DEBUG(x,y,z)	if (dflag >= x) printf(y,z)

extern int dflag;

#else

#define	DEBUG(l,f,s)	if (Debug >= l) fprintf(stderr,f,s)

extern int Debug;

#endif

 /* 
  * We use one data structre for communication between various levels
  * of the g-protocol implementation. Fields in parentheses are relevant
  * only when a packet holds data.
  *	field	meaning				set by
  *	c	message type			gwrite(), grpack()
  *	(k	data segment length		galloc(), grpack())
  *	(chk	16-bit checksum			packet i/o functions)
  *	(len	max. data segment length	galloc(), gwrite(), grpack())
  *	(data	start of "len" bytes		this field is fixed)
  *	(segl	nbr of data bytes left		gread())
  *	(segp	start of "segl" bytes		gread())
  */

 /* structure for communication between various program layers */

typedef struct {
    char k;				/* message segment size */
    char c;				/* message type */
    int chk;				/* data checksum */
    short segl;				/* nr of data bytes left */
    char *segp;				/* start of the "segl" bytes */
    short len;				/* maximum data segment size */
    char data[1];			/* actually a lot of characters */
} Packet;

 /* functions that manipulate packets */

extern Packet *grproto();		/* take packet from input queue */
extern void gfree();			/* release input packet */
extern Packet *galloc();		/* allocate output packet */
extern void gwproto();			/* place packet in output queue */
extern void gfail();			/* panic button */
extern void gsctrl();			/* send one control packet */
extern void gsdata();			/* send one data packet */
extern int grpack();			/* receive one packet */

extern int seglen[];			/* data segment size table */

 /* standard unix library */

extern char *malloc();

#endif	/* GP */
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Apr 19 12:41:37 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:01:41
/* VERSION/RELEASE
/*	2.1
/*--*/
