/*++
/* NAME
/*	getwork 3
/* SUMMARY
/*	receive work from remote system
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	cico
/* SYNOPSIS
/*	#include "work.h"
/*
/*      work *rmtwork(rqst)
/*      char *rqst;
/*
/*	void getwork(wrk)
/*	work *wrk;
/* DESCRIPTION
/*      rmtwork() parses a remote Send request. A suitable destination
/*	file is opened. The resulting work structure is for use by
/*	getwork().
/*
/*	getwork() receives a file from the remote system, after the
/*	necessary preparations have been done by rmtwork().
/*	The file is deleted in case of transmission failure.
/* FUNCTIONS AND MACROS
/*	trap(), locname()
/* SEE ALSO
/*	sendwork(), scanwork()
/* DIAGNOSTICS
/*	Exceptions are handled with longjmp(systrap,errorcode).
/*
/*	rmtwork() traps in case of invalid requests or if the destination
/*	file could not be opened.
/*
/*	getwork() traps in case of read/write errors.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sat Mar 28 16:57:57 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:01:39
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>

#include "defs.h"
#include "logs.h"
#include "status.h"
#include "work.h"
#include "params.h"
#include "comm.h"

/* rmtwork - parse remote S request and open destination file */

public work *rmtwork(rqst)
char   *rqst;
{
    static work wrk;
    char    path[BUFSIZ];

    if (sscanf(rqst, "S %*s %s", path) != 1)	/* pick destination file name */
	trap(E_LOST, "BAD REQUEST FORMAT");
    debug(5) ("rmtwork: path %s\n", path);
    strcpy(wrk.path, locname(path));		/* convert to local name */
    debug(5) ("rmtwork: file %s\n", wrk.path);
    if ((wrk.fp = fopen(wrk.path, "w")) == 0)	/* try to open that file */
	trap(E_WRITERR, "CAN'T CREATE FILE (%s)", sys_errlist[errno]);
    return (&wrk);
}

/* getwork - receive file from remote host */

public void getwork(wrk)
register work *wrk;
{
    char    buf[BUFSIZ];
    register int nread;
    register int werror;

    while ((nread = CALL(Read) (ttfd, buf, BUFSIZ)) > 0 &&
	   fwrite(buf, sizeof(*buf), nread, wrk->fp) == nread)
	 /* void */ ;
    werror = ferror(wrk->fp);			/* record error status */
    fclose(wrk->fp);

    /*
     * In case of any errors we force a protocol shutdown. The oher side will
     * send the same file again next time we make a connection.
     */

    if (nread < 0) {				/* did the protocol fail? */
	chmod(wrk->path, 0666);			/* make file deletable */
	unlink(wrk->path);			/* remove file */
	trap(E_LOST, "FAILED (lost link)");	/* handle exception */
	/* NOTREACHED */
    } else if (werror) {			/* file write error? */
	chmod(wrk->path, 0666);			/* make file deletable */
	unlink(wrk->path);			/* remove file */
	trap(E_WRITERR, "FILE WRITE ERROR (%s)", sys_errlist[errno]);
	/* NOTREACHED */
    } else {
	chmod(wrk->path, 0444);			/* protect the file */
    }
}
