/*++
/* NAME
/*	create 3
/* SUMMARY
/*	create a mail message
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mail
/* SYNOPSIS
/*	#include "mail.h"
/*
/*	int create()
/* DESCRIPTION
/*      Create() creates a template message and invokes an editor.
/*	It then passes control to the work_disp() function (the function that
/*	lets the user decide on the disposition of the message).
/* COMMANDS
/*	The program specified in the EDITOR environment variable,
/*	or a system-dependent default.
/* FILES
/*	mail.msg, file being edited in the current directory
/*      $MAILDIR/ennnnn, message file (body)
/*	$MAILDIR/cnnnnn, meta file (summary)
/*	$MAILDIR/header, template mail header file
/*	$MAILDIR/trailer, template signature file
/* SEE ALSO
/*      pager(3), pager(5), kbdinp(3), edit(3)
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Tue May 12 15:35:20 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:01:27
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>

#include "defs.h"
#include "path.h"
#include "mail.h"
#include "status.h"
#include "screen.h"

hidden int create_work();		/* forward declaration */

/* create - create, edit, and dispose of a mail message */

public int create()
{
    register int stat;

    if ((stat = create_work())			/* try to create the message */
    || (stat = edit(message, MAILFILE)))	/* try to edit the message */
	errdisp(stat);				/* we had a problem */
    work_disp("");				/* ask for disposition */
    return (S_REDRAW);				/* say screen has changed */
}

/* create_work - create template mail message */

hidden int create_work()
{
    register FILE *fp;
    register int err;

    if (fp = fopen(message, "w")) {
	(void) fprintf(fp, "Subject: \n");	/* Subject: line */
	(void) textcopy(header_file(), fp);	/* personalized mail header */
	putc('\n', fp);
	(void) textcopy(trailer_file(), fp);	/* personalized signature */
	err = (fflush(fp) || ferror(fp));
	(void) fclose(fp);
	return (err ? E_WRITERR : 0);
    } else {
	return (E_WRITERR);
    }
}
