/*++
/* NAME
/*      comm 5
/* SUMMARY
/*      cico systems parameters
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      cico
/* SYNOPSIS
/*      #include "params.h"
/*      #include "comm.h"
/* DESCRIPTION
/* .nf

 /* roles and other behavioural codes */

#define MASTER	1			/* who sends files */
#define SLAVE	2			/* who receives files */
#define DONE	3			/* no more files */

#define YES	'Y'
#define NO	'N'

 /* communications parameters (see params.h) */

#define COMM_LINE	(comm[P_PORT].strval)
#define COMM_RATE	(comm[P_BAUD].strval)
#define DIAL_SEQUENCE	(comm[P_DIAL].strval)
#define LOGIN_NAME	(comm[P_LOGIN].strval)
#define DISC_SEQUENCE	(comm[P_DISC].strval)

 /* related info */

extern int ttfd;			/* comm. port */
extern Info *comm;			/* comm. info */
extern char *password;			/* password */
extern char rmthost[];			/* remote system name */

 /* functions that use the above */

extern char *rmtname();			/* make remote spool-file name */
extern char *locname();			/* make local spool-file name */

 /* protocol function pointers */

extern int (*Read) ();			/* protocol read */
extern int (*Write) ();			/* protocol write */
extern int (*Close) ();			/* protocol close */

 /* use these at your own risk */

#define MSGBUF       4096		/* message buffer size */

extern char msgin[MSGBUF];		/* message receive buffer */
extern char msgout[MSGBUF];		/* message send buffer */

 /* message i/o functions */

extern int isok();			/* do request; get yes or no */
extern char *talk();			/* send message */
extern char *hear();			/* receive message */

/* SEE ALSO
/*      comm(3) implementation module
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sun Apr 12 13:52:39 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:01:21
/* VERSION/RELEASE
/*	2.1
/*--*/
