/*++
/* NAME
/*	ascf 5
/* SUMMARY
/*	stdio-like ascii filter
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	ascii filtering
/* SYNOPSIS
/*	#include <stdio.h>
/*	#include "ascf.h"
/* DESCRIPTION
/* .nf

 /* An _iobuf-like structure for buffer management */

typedef struct {
    char   *buf;			/* intermediate buffer */
    char   *ptr;			/* read pointer */
    int     cnt;			/* buffer size */
    char    nlf;			/* last newline kludge */
} Asc;

#define	ascget(p) (--asc[fileno(p)].cnt>=0?*asc[fileno(p)].ptr++&0377:ascbuf(p))
#define	ascpbk(c,p) (asc[fileno(p)].cnt++, (*--asc[fileno(p)].ptr = c))

extern FILE *ascopen();			/* open filtered stream */
extern Asc asc[];			/* buffers, status etc. */
extern char *ascgets();			/* read string, strip crlf */

/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Mon Jul  6 16:03:41 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:01:15
/* VERSION/RELEASE
/*	2.1
/*--*/
