/*++
/* NAME
/*	dosunix 3
/* SUMMARY
/*	UNIX <-> MS-DOS text format conversion
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	nfs
/* SYNOPSIS
/*	#include <stdio.h>
/*	#include "dosunix.h"
/*
/*	int dos2unix(ifp, ofp)
/*	FILE *ifp;
/*	FILE *ofp;
/*
/*	int unix2dos(ifp, ofp)
/*	FILE *ifp;
/*	FILE *ofp;
/*
/*	char *dosgets(buf, len, fp)
/*	char *buf;
/*	unsigned len;
/*	FILE *fp;
/* DESCRIPTION
/*	dos2unix() converts an MS-DOS text stream (with cr/lf-delimited
/*	lines) to a UNIX style stream (with lf-delimited lines).
/*
/*	unix2dos() performs the opposite function as dos2unix().
/*
/*	dosgets() reads one line from the designated stream and strips
/*	off any cr of lf characters.
/* DIAGNOSTICS
/*	dos2unix(), unix2dos() return a nonzero value if an error was detected.
/*
/*	dosgets() returns (char *) 0 if it could not read any data.
/* BUGS
/*	Very long lines will be broken; Ctrl-Z in MS-DOS files is not
/*	given special treatment, nor will it be added to the end of
/*	MS-DOS files.
/* AUTHOR(S)
/*	Wietse Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Oct 29 16:41:50 MET 1989
/* LAST MODIFICATION
/*	10/29/89 22:30:00
/* VERSION/RELEASE
/*	1.1
/*--*/

#ifndef lint
static char sccsid[] = "@(#) dosunix.c 1.1 10/29/89 22:30:00";

#endif

#include <stdio.h>
#include "dosunix.h"			/* consistency check */

extern char *strchr();
extern char *fgets();

/* unix2dos - copy UNIX-format stream to MS-DOS-format stream */

int     unix2dos(ifp, ofp)
FILE   *ifp;
FILE   *ofp;
{
    static char buf[BUFSIZ];
    register int end;

    while (fgets(buf, sizeof(buf), ifp)) {
	if (buf[end = strlen(buf) - 1] == '\n') {
	    buf[end] = '\r';
	    (void) fputs(buf, ofp);
	    (void) putc('\n', ofp);
	} else {
	    (void) fputs(buf, ofp);
	}
    }
    return (fflush(ofp) || ferror(ofp) || feof(ofp));
}

/* dos2unix - copy MS-DOS-format text stream to UNIX-format text stream */

int     dos2unix(dfp, pfp)
register FILE *dfp;
register FILE *pfp;
{
    static char msgbuf[BUFSIZ];		/* copy buffer */

    while (dosgets(msgbuf, sizeof(msgbuf), dfp)) {
	(void) fputs(msgbuf, pfp);
	(void) putc('\n', pfp);
    }
    return (fflush(pfp) || ferror(pfp) || feof(pfp));
}

/* dosgets - read one line from DOS-format text stream; strip cr and lf */

char   *dosgets(buf, len, fp)
register char *buf;
unsigned len;
register FILE *fp;
{
    register char *cp;
    register char *ret;

    /* Lines with >= len characters will be broken */

    if ((ret = fgets(buf, len, fp))
	&& ((cp = strchr(buf, '\r')) || (cp = strchr(buf, '\n'))))
	*cp = '\0';				/* strip cr or lf */
    return (ret);
}

