/*++
/* NAME
/*	detab 1
/* SUMMARY
/*	expand tabs to blanks
/* PROJECT
/*	sdetools
/* SYNOPSIS
/*	detab
/* DESCRIPTION
/*	Detab is a filter that expands tab stops in its standard input
/*	to blanks. A tab stop distance of eight blanks is assumed.
/* BUGS
/*	This program does not handle backspaces.
/*
/*	Should be a standard utility, but different versions of UNIX
/*	disagree on names or options.
/* AUTHOR(S)
/*	Wietse Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sep 14 1985
/* LAST MODIFICATION
/*	10/18/89 21:52:21
/* VERSION/RELEASE
/*	1.4
/*--*/

#include <stdio.h>

static char sccsid[] = "@(#) detab.c 1.4 10/18/89 21:52:21";

main()
{
    register int c;		/* character buffer */
    register int ccount = 0;	/* nr of characters printed on current line */

    while ((c = getchar()) != EOF) {
	switch (c) {
	    case '\r':
	    case '\n':  putchar(c);
			ccount = 0;
			break;
	    case '\t':  do { putchar(' '); } while (++ccount & 7);
			break;
	    default:    putchar(c);
			ccount++;
			break;
	}
    }
    exit(0);
}
