/*++
/* NAME
/*	window 5
/* SUMMARY
/*	window definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mail
/* SYNOPSIS
/*	#include "window.h"
/* DESCRIPTION
/*	The macros and variables defined here are used for window
/*	manipulation.
/* .nf

 /*
  * A "window" is a rectangular region that extends from the left-hand side
  * of the screen all the way to the right-hand side.
  */

typedef struct win {
    short   base;			/* offset (lines) from top of screen */
    short   size;			/* number of lines */
    short   x;				/* current column (from the left) */
    short   y;				/* current row (from the top) */
} WIN;

extern WIN wins[];

 /* window selection macros */

#define	topwin	(wins+0)		/* top window */
#define	midwin	(wins+1)		/* middle window */
#define	botwin	(wins+2)		/* bottom window */

extern int CO,				/* columns on screen */
        LI;				/* lines on screen */

 /* function-key codes */

extern char *KU,			/* up-arrow */
       *KD,				/* down-arrow */
       *KL,				/* left-arrow */
       *KR,				/* right-arrow */
       *PU,				/* page up */
       *PD;				/* page down */

 /* codes to turn on/off keypad, if you have one */

extern char *KS,			/* keypad on */
       *KE;				/* keypad off */

 /* functions that write to windows */

extern void wininit();			/* init the window manipulator */
extern int printcl();			/* erase line, then print */
extern int printat();			/* print line */
extern void setwin();			/* set focus and cursor */
extern int wputc();			/* print character to window */
extern int wputs();			/* print string to window */
extern void clrtoeol();			/* erase to end of line */
extern void clrtobot();			/* clear to screen bottom */
extern void beep();			/* ring the bell */

#ifdef unix
extern int fputchar();			/* put a character on stdout */
#endif

/* SEE ALSO
/*	window(3)	window manipulator
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  1 21:14:53 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:57
/* VERSION/RELEASE
/*	2.1
/*--*/
