/*++
/* NAME
/*	sysdep 5
/* SUMMARY
/*	other system-dependent routines for MS-DOS or ST
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	cico
/* SYNOPSIS
/*	#include "sysdep.h"
/* DESCRIPTION
/*	void.
/* AUTHOR(S)
/*	Some parts taken from uuslave sources written by John Gilmore
/*	(gnu@hoptoad.com).
/*
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Apr 12 17:48:08 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:46
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "sysdep.h"

sigint()
{
    /* Restore terminal settings on dialout line */
#ifdef MSDOS
    uninit_comm();
    reset_tty();
#endif
#ifdef ST
    /* No need to do anything here? */
#endif

    exit(0);
}

 /*
  * MSDOS and ST need some of these routines.  Probably should use the new
  * names, but for now...
  */

bzero(s, cnt)
register char *s;
register int cnt;
{
    register int i;

    for (i = 0; i < cnt; i++) {
	*s++ = '\0';
    }
}

bcopy(from, to, cnt)
register char *from;
register char *to;
register int cnt;
{
    register int i;

    for (i = 0; i < cnt; i++) {
	*to++ = *from++;
    }
}

#ifdef MSDOS
 /*
  * MSDOS routines for handling the comm port.
  * 
  * get_time() fills timetype structure n with current time using DOS interrupt
  * 21
  * 
  */

get_time(n)
TIME_PTR n;
{
    union REGS inregs;
    union REGS outregs;

    inregs.h.ah = 0x2c;				/* Please make a #define for
						 * this, Tim */

    int86(0x21, &inregs, &outregs);		/* Please #define the 0x21
						 * too */

    n->hour = outregs.h.ch;
    n->minute = outregs.h.cl;
    n->sec = outregs.h.dh;
    n->hsec = outregs.h.dl;

    return (0);
}

sleep(x)
int     x;
{
    int     i;
    unsigned s;
    TIME    n;				/* current time record */

    i = 0;
    get_time(&n);
    s = n.sec;

    while (i < x) {
	while (s == n.sec)
	    get_time(&n);
	s = n.sec;
	++i;
    }
}
#endif
