/*++
/* NAME
/*	submit 3
/* SUMMARY
/*	queue a message for transfer over the network
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mail
/* SYNOPSIS
/*	int submit(file,to)
/*	char *file;
/*	char *to;
/* DESCRIPTION
/*	submit() invokes the smail command to prepare a message for
/*	transmission across the network. file is the name of a file
/*	with a message; to is a string with one or more destinations,
/*	separated by blanks. The to string is modified.
/* FUNCTIONS AND MACROS
/*	invokevp()
/* COMMANDS
/*	smail, alias processing and queueing
/* FILES
/*	d<seqno>	message file
/*	x<seqno>	destination
/* SEE ALSO
/*	path(5)		spool file names
/*	status(5)	error status codes
/* DIAGNOSTICS
/*	A nonzero error status is returned in case of problems.
/* BUGS
/*	On some non-Unix systems the limit on the command-line length
/*	may cause problems.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sat Apr  9 17:48:03 MET 1988
/* LAST MODIFICATION
/*	90/01/22 13:02:44
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>

#include "defs.h"
#include "path.h"

public int submit(file, to)
char   *file;
char   *to;
{
#ifdef	lint
    static
#endif
    char   *arglist[BUFSIZ];
    register char **cpp = arglist;
    static char sep[] = ", \t";

    /* Build the argment vector for the smail command */

    *cpp++ = SMAIL;
    *cpp++ = file;

    for (*cpp = strtok(to, sep); *cpp; *++cpp = strtok((char *) 0, sep))
	 /* void */ ;

    return (invokevp(arglist));
}
