/*++
/* NAME
/*      scanwork 3
/* SUMMARY
/*      search spool directory for outbound messages
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      cico
/* SYNOPSIS
/*	#include "work.h"
/*
/*      work *scanwork()
/* DESCRIPTION
/*      scanwork() searches the spool directory for files to be sent to
/*	the remote system. If a file is found, scanwork() attempts to
/*	open that file. A null pointer is returned if no work was found.
/*
/*	The result is normally used by sendwork().
/* FUNCTIONS AND MACROS
/*      scandir(), newseqno(), fspool()
/* SEE ALSO
/*      sendwork()      send spool file to remote host
/*      getwork()       receive remote spool file
/*      rmtname()       local spool-file to remote-file name mapping
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sat Mar 28 17:28:09 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:31
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>
#include <ctype.h>

#include "defs.h"
#include "params.h"
#include "comm.h"
#include "work.h"
#include "path.h"
#include "ndir.h"
#include "logs.h"

 /*
  * The present implementation assumes that work for the remote system is in
  * the form of pairs of spool files with names d<seqno> and x<seqno>.
  * 
  * The d files contain an electronic mail message, and the x files contain the
  * destination. Both have the same <seqno> suffix which is just a five-digit
  * sequence number.
  * 
  * The task of scanwork() thus is trivial: just locate a file of which the name
  * begins with a d or x and do some file name parsing. The major work is
  * done by rmtname() and sendwork(): depending on the type of file, generate
  * an appropriate remote file name and send the appropriate messages to the
  * remote system.
  *
  * After a file has been transmitted it is renamed to reflect the "Sent"
  * status.
  */

/* scanwork - search spool directory for work */

public work *scanwork()
{
    register DIR *dp;
    register struct direct *de;
    static work wrk;			/* overwritten each time */
    static char unsent[] = "DdXx";	/* prefixes for unsent messages */
    char   *p_unsent;			/* pointer into unsent array */
    static char sent[] = "qqrr";	/* prefixes for sent messages */

    if ((dp = opendir(maildir)) == 0) {
	return (0);
    } else {
	while (de = readdir(dp)) {
	    debug(5) ("scanwork: file %s\n", de->d_name);
	    if (((p_unsent = index(unsent, wrk.type = de->d_name[0])) != 0)
	    && (wrk.seqno = seqno(de->d_name))) {
		strcpy(wrk.path, fspool(de->d_name));
		strcpy(wrk.sent, fspool(strcons(SPOOLFMT,
				      sent[p_unsent - unsent], wrk.seqno)));
		sprintf(wrk.rqst, "S %s %s %s - %s 0660", de->d_name,
			rmtname(wrk.type, wrk.seqno), "uucp", de->d_name);
		wrk.fp = fopen(wrk.path, "r");
		break;
	    }
	}
	closedir(dp);
	return (de ? &wrk : NULL);
    }
}
