/*++
/* NAME
/*	params 5
/* SUMMARY
/*	communication parameter definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	library
/* SYNOPSIS
/*	#include "params.h"
/* DESCRIPTION
/* .nf

 /*
  * Identification strings for the external representation of the setup. The
  * parameter setup is stored as a file, with one identification string and
  * parameter value per line. The identification strings are the same ones as
  * used by the mail shell (the Setup option in the initial screen). The UUCP
  * gunk is not compiled in for systems that use daemons for message delivery.
  */

#define	S_IGNORE	"ignore_header_lines:"
#ifndef	DAEMON
#define	S_PORT		"communications_port:"
#define	S_BAUD		"baud_rate:"
#define	S_HOST		"remote_host_name:"
#define	S_LOGIN		"login_name:"
#define	S_DIAL		"dialup_sequence:"
#define	S_DISC		"disconnect_sequence:"
#endif

 /* default values */

#define	D_IGNORE	"received message-id"
#ifndef	DAEMON
#define	D_DISC		"\\0"
#endif

 /* Table offsets for the internal representation */

#define	P_IGNORE	0
#ifndef	DAEMON
#define	P_PORT		1
#define	P_BAUD		2
#define	P_HOST  	3
#define	P_LOGIN		4
#define	P_DIAL		5
#define	P_DISC		6
#endif

 /* Structure of the in-core setup table. */

typedef struct {
    char   *ident;			/* identification string */
    int     length;			/* length of id string */
    char   *strval;			/* string value of parameter */
    char   *defval;			/* default string value */
} Info;

extern Info *getparams();		/* read setup file */

/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  8 15:39:23 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:25
/* VERSION/RELEASE
/*	2.1
/*--*/
