/*++
/* NAME
/*      newseqno 3
/* SUMMARY
/*      generate/extract sequence number for/from spool file
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      general
/* SYNOPSIS
/*	unsigned seqno(s)
/*	char *s;
/*
/*      unsigned newseqno()
/* DESCRIPTION
/*	seqno() verifies the format of a spool file name and extracts
/*	its sequence number. A zero value is returned  if the validation
/*	failed.
/*
/*      newseqno() deduces a new spool file sequence number by looking
/*	at the names of all files in the spool directory.
/* BUGS
/*	A sequence file would be better both for performance, but not
/*	for collision detection.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sat Mar 28 18:10:53 GMT+1:00 1987
/* LAST MODIFICATION
/*	90/01/22 13:02:19
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "defs.h"
#include "path.h"
#include "ndir.h"
#include "status.h"

/* newseqno - extract sequence number from existing spool file names */

public unsigned newseqno()
{
    register unsigned msgno = 0;
    register struct direct *de;
    register DIR *dp;
    unsigned tmp = 0;

    /*
     * We cannot terminate when directory access fails: live interrupts in
     * the communications-port routines!
     */

    while ((dp = opendir(maildir)) == 0)
	 /* void */ ;

    /* needs locking mechanism on multi-tasking operating systems */

    while (de = readdir(dp)) {
	if ((tmp = seqno(de->d_name)) && (tmp > msgno))
	    msgno = tmp;
    }
    closedir(dp);
    return (msgno + 1);
}

/* seqno - validate format of spool file name and extract sequence number */

public unsigned seqno(s)
char   *s;
{
    int     seq;
    char    junk;

    if (strlen(s) == NAMELEN && sscanf(s + 1, "%u%c", &seq, &junk) == 1)
	return (seq);
    else
	return (0);
}
