/*++
/* NAME
/*      mailfile 3
/* SUMMARY
/*      mail the file currently being displayed
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      mail
/* SYNOPSIS
/*	#include "mail.h"
/*
/*      int mailfile()
/* DESCRIPTION
/*      mailfile() is invoked when the user wants to mail a copy of a
/*	file or message to some person. The name of the file is taken
/*	from the global string variable message[].
/*
/*	The user is asked for a destination, the necessary spool files
/*	are created and the main menu display is junked.
/* FUNCTIONS AND MACROS
/*	kbdinp(), junk_desk()
/* FILES
/*      message and meta file in the spool directory.
/* SEE ALSO
/*      pager(3), pager(5), kbdinp(3)
/* DIAGNOSTICS
/*      An error message is displayed in case of problems.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Mon Apr  4 13:03:44 MET 1988
/* LAST MODIFICATION
/*	90/01/22 13:02:06
/* VERSION/RELEASE
/*	2.1
/*--*/

#include "defs.h"
#include "path.h"
#include "screen.h"
#include "mail.h"

hidden int queue_mailfile();

/* mailfile - ask mail address to send file to */

public int mailfile()
{
    static Screen screen[] = {
	STRING,	0,              queue_mailfile, int_error,
	0,	0,              when,		getaddr,
    };

    kbdinp(screen);				/* ask message destination */
    return(S_REDRAW);				/* say screen has changed */
}

/* queue_mailfile - queue a copy to another person */

hidden int queue_mailfile(to)
char *to;
{
    register int stat;

    if (stat = submit(message,to)) {
	errdisp(stat);				/* notify user */
	return(S_BREAK|S_REDRAW);		/* say screen has changed */
    } else {
	junk_desk();				/* say mail box has changed */
	return(S_BREAK);			/* terminate caller */
    }
}
