/*++
/* NAME
/*	kp 5
/* SUMMARY
/*	definitions file for k protocol
/* PACKAGE
/*	uucp across the thenet
/* SYNOPSIS
/*	#include "kp.h"
/* DESCRIPTION
/*	The following definitions are made in the file kp.h:
/* .nf

 /* Need stderr definition from stdio.h */

#include "stdio.h"

 /* Symbol Definitions */

#define	PACKSIZ     256			/* Packet size sent by this uucico */
#define MAXPACKSIZ  1024		/* Maximum packet size I can receive */
#define SOH         16			/* Start of header */
#define CR          13			/* ASCII Carriage Return */
#define	SP          32			/* ASCII Blank */

#define MAXTRY      10			/* Times to retry a packet */

 /* 5 secs timeout interval turns out to be too short, when THEnet is busy */

#define TIMEOUT     10			/* Seconds after which I should be
					 * timed out */

#define TRUE         1			/* Boolean constants */
#define FALSE        0

#define	NULLP (char*)0			/* NULL pointer */
#define	FAIL        -1			/* Read/write return value in case of
					 * error */
#define	TIME        -2			/* Receive packet return status if
					 * timed out */

#define	OUT          6			/* Nr. of data bits per char in
					 * packet */
#define	IN           8			/* Nr. of data bits per byte */
#define	STEP         2			/* Difference between previous two */
#define	MASK       077			/* Mask for number of data bits in
					 * packet */

 /* Macro Definitions */

#define tosix(ch)  (((ch) & MASK) + SP)
#define unsix(ch)  (((ch) - SP) & MASK)

#define tochar(ch)  ((ch) + SP)
#define unchar(ch)  ((ch) - SP)

 /* intercept system calls in case of non-unix operating systems */

#ifndef	unix

#define	read		xread
#define	write		xwrite
#define	alarm(x)	/* nothing */
#define	signal(x,y)	/* nothing */
#define	DEBUG(x,y,z)	if (dflag >= x) printf(y,z)

extern int dflag;

#else

#define DEBUG(l,f,s) if (Debug >= l) fprintf(stderr,f,s)

 /* Declarations */

extern int Debug;			/* Debugging level */

#endif
/* AUTHOR(S)
/*	Wietse Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Mon Feb  3 22:14:23 MET 1986
/* LAST MODIFICATION
/*	90/01/22 13:01:55
/* VERSION/RELEASE
/*	2.1
/*--*/
