/*++
/* NAME
/*	util 3
/* SUMMARY
/*	wrappers around standard library functions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	nfs
/* SYNOPSIS
/*	#include <stdio.h>
/*	#include <pwd.h>
/*	#include <directory_access_stuff.h>
/*
/*	FILE *u_fopen(uinfo,path,mode)
/*	struct passwd *uinfo;
/*	char *path;
/*	char *mode;
/*
/*	int u_link(uinfo, old, new)
/*	struct passwd *uinfo;
/*	char *old;
/*	char *new;
/*
/*	int u_unlink(uinfo, path)
/*	struct passwd *uinfo;
/*	char *path;
/*
/*	DIR *e_opendir(path)
/*	char *path;
/*
/*	int e_chdir(path)
/*	char *path;
/*
/*	int e_fork()
/* DESCRIPTION
/*	These functions are wrappers around some standard library functions.
/*	In case of problems, they append an entry to the system log (with
/*	priority LOG_WARNING). The \fIuinfo\fR argument specifies the owner
/*	of the mail subdirectory in which the problem occurred.
/* SEE ALSO
/*	syslog(3)
/* DIAGNOSTICS
/*	Diagnostics are logged via the syslog package; error return values
/*	are identical to those of the underlying library functions.
/* AUTHOR(S)
/*	Wietse Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Oct 29 16:21:02 MET 1989
/* LAST MODIFICATION
/*	12/4/89 23:22:13
/* VERSION/RELEASE
/*	1.2
/*--*/

#ifndef lint
static char sccsid[] = "@(#) util.c 1.2 12/4/89 23:22:13";

#endif

#include <stdio.h>
#include <pwd.h>

#ifdef SYSV
#include <ndir.h>
#else
#include <sys/types.h>
#include <sys/dir.h>
#endif

#ifdef SYSLOG
#include <syslog.h>
#else
#include "syslog.h"
#endif

#include "util.h"			/* consistency check */

/* u_fopen - open file in user directory, log any errors */

FILE   *u_fopen(uinfo, file, mode)
struct passwd *uinfo;
char   *file;
char   *mode;
{
    register FILE *fp;

    if ((fp = fopen(file, mode)) == 0)
	syslog(LOG_WARNING, "cannot open %s/%s: %m", uinfo->pw_name, file);
    return (fp);
}

/* u_unlink - unlink file in user directory, log any errors */

int     u_unlink(uinfo, file)
struct passwd *uinfo;
char   *file;
{
    register int stat;

    if (stat = unlink(file))
	syslog(LOG_WARNING, "cannot unlink %s/%s: %m", uinfo->pw_name, file);
    return (stat);
}

/* u_link - link file in user directory, log any errors */

int     u_link(uinfo, old, new)
struct passwd *uinfo;
char   *old;
char   *new;
{
    register int stat;

    if (stat = link(old, new))
	syslog(LOG_WARNING, "cannot link %s/%s: %m", uinfo->pw_name, new);
    return (stat);
}

/* e_opendir - open directory, log any errors */

DIR    *e_opendir(path)
char   *path;
{
    register DIR *dd;

    if ((dd = opendir(path)) == 0)
	syslog(LOG_WARNING, "cannot open directory %s: %m", path);
    return (dd);
}

/* e_chdir - change directory, log any errors */

int     e_chdir(path)
char   *path;
{
    register int ret;

    if (ret = chdir(path))
	syslog(LOG_WARNING, "cannot chdir to directory %s: %m", path);
    return (ret);
}

/* e_fork - do a fork(), log any errors */

int     e_fork()
{
    register int stat;

    if ((stat = fork()) == -1)
	syslog(LOG_WARNING, "fork() failed: %m");
    return (stat);
}

