/*++
/* NAME
/*	mtime 5
/* SUMMARY
/*	maintain modification times of files
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	nfs
/* SYNOPSIS
/*	#include "mtime.h"
/* DESCRIPTION
/* .nf

 /* structure of one symbol-table entry */

typedef struct MTIME {
    char   *path;			/* key */
    long    time;			/* value */
    struct MTIME *left;			/* left subtree */
    struct MTIME *rite;			/* right subtree */
}       MTIME;

 /* client interface */

#define mtime(path)	(mtime_tree = findtime(path,mtime_tree))

 /* actual interface */

extern MTIME *mtime_tree;		/* head of symbol table */
MTIME  *findtime();			/* actual access function */

/* AUTHOR(S)
/*	Wietse Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Oct 29 15:48:01 MET 1989
/* LAST MODIFICATION DATE
/*	10/29/89 22:29:58
/* VERSION/RELEASE
/*	1.1
/*--*/

