/*++
/* NAME
/*	textcopy 3
/* SUMMARY
/*	copy text to stream
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mail
/* SYNOPSIS
/*	int textcopy(path, fp)
/*	char *path;
/*	FILE *fp;
/* DESCRIPTION
/*      This function filters the contents of a file and writes the result
/*	to a stdio stream. It can be used, for example, to provide optional
/*	headers and trailers for new mail messages and for replies.
/* SEE ALSO
/*	ascf(3) text filter
/* DIAGNOSTICS
/*	A nonzero value is returned in case of problems.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Fri Dec 15 21:39:26 MET 1989
/* LAST MODIFICATION
/*	90/01/22 13:02:48
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>

#include "defs.h"
#include "ascf.h"

/* textcopy - copy text to stream */

public int textcopy(path, fp)
char   *path;
FILE   *fp;
{
    char    buf[BUFSIZ];
    int     ret;
    FILE   *ip;

    if ((ip = ascopen(path, "r")) == 0) {
	return (1);
    } else {
	while (ascgets(buf, sizeof(buf), ip))
	    fputs(buf, fp), putc('\n', fp);
	ret = ferror(ip);
	ascclose(ip);
	return (ret);
    }
}
