#include <stdio.h>
#include <varargs.h>

extern char *progname;

#include "defs.h"

/* fatal - another way to terminate */

/* VARARGS */

public  fatal(va_alist) 
va_dcl
{
    va_list ap;
    char   *fmt;

    if (progname && *progname)
	(void) fprintf(stderr, "%s: ", progname);
    va_start(ap);
    fmt = va_arg(ap, char *);
    (void) vfprintf(stderr, fmt, ap);
    va_end(ap);
    (void) abort();
    exit(1);
}

/* myalloc - allocate memory or terminate */

public char *myalloc(size)
unsigned size;
{
    register char *p;
    char   *malloc();

    if ((p = malloc(size)) == 0)
	fatal("memory allocation error");
    return (p);
}

/* myrealloc - extend memory or terminate (allows NULL pointer) */

public char *myrealloc(ptr, size)
char   *ptr;
unsigned size;
{
    register char *p;
    char   *realloc();

    if (ptr == 0) {
	return (myalloc(size));
    } else if ((p = realloc(ptr, size)) == 0) {
	fatal("memory allocation error");
	/* NOTREACHED */
    } else {
	return (p);
    }
}
