/*++
/* NAME
/*	edit 3
/* SUMMARY
/*	edit a file
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mail
/* SYNOPSIS
/*	#include "mail.h"
/*
/*	int edit(fname,tname)
/*	char *fname,*tname;
/* DESCRIPTION
/*	edit() copies the file in fname to the file tname,
/*	invokes the editor, and copies the result back.
/* COMMANDS
/*	the program specified in the EDITOR environment variable,
/*	or a system-dependent default.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  6 20:21:35 MET 1988
/* LAST MODIFICATION
/*	90/01/22 13:01:34
/* VERSION/RELEASE
/*	2.1
/*--*/

#include <stdio.h>
#include <errno.h>

#include "defs.h"
#include "path.h"
#include "mail.h"
#include "status.h"

#ifdef MSDOS
#   include <fcntl.h>
#endif

 /*
  * Some editors (wordstar) do not accept path names. grrrr. So we copy the
  * edit file to a temp file in the current directory. After editing, the
  * temp file is copied back. We do not move files, since current dir and the
  * spool dir may be in different file systems, and people might turn off the
  * machine and lose their work.
  */

/* edit - edit or create a file */

public int edit(fname, tname)
char   *fname,
       *tname;
{
    register int stat = 0;
    register FILE *fp;

    /*
     * First make sure that we can get write permission on the permanent file
     * and temporary file (if they exist). Create an empty temp file if we
     * are not editing an existing file.
     */

    if (chmod(fname, 0666) && errno != ENOENT) {
	stat = E_WRITERR;			/* original file is protected */
    } else if (chmod(tname, 0666) && errno != ENOENT) {
	stat = E_WRITERR;			/* scratch file is protected */
    } else if ((fp = fopen(fname, "a")) == 0) {
	stat = E_WRITERR;			/* file system is protected? */
    } else if (fclose(fp), stat = cpfile(fname, tname)) {
	 /* void */ ;				/* could not make edit copy */
    } else {
	patience();				/* this may take some time */
	kbdrest();				/* reset tty modes */
	if (stat = invokelp(editor, tname, (char *) 0))	/* call editor */
	    stat = (stat == E_NOPROG ? stat : E_UNKNOWN);
	else
	    stat = cpfile(tname, fname);	/* copy back */
	kbdinit();				/* set tty modes */
	unlink(tname);				/* don't check status */
    }
    chmod(fname, 0444);				/* protect destination file */
    return (stat);
}

/* cpfile - yet another file copy function */

hidden int cpfile(from, to)
char   *from;
char   *to;
{
    register FILE *in,
           *out;			/* file pointers */
    int     stat = 0;			/* error status */
    register int c;			/* character buffer */

    if ((in = fopen(from, "r")) == 0) {		/* cannot read source */
	return (E_READERR);
    } else if ((out = fopen(to, "w")) == 0) {	/* cannot write destination */
	fclose(in);
	return (E_WRITERR);
    } else {

#ifdef O_BINARY
	setmode(fileno(in), O_BINARY);		/* get rid of the */
	setmode(fileno(out), O_BINARY);		/* crlf translation */
#endif
	while ((c = getc(in)) != EOF)
	    putc(c, out);
	if (ferror(in))				/* check read error status */
	    stat = E_READERR;
	else if (ferror(out))			/* check write error status */
	    stat = E_WRITERR;
	fclose(in);
	fclose(out);
	return (stat);				/* at most one type of error */
    }
}
