/*
 * nmail.c -- a network mail interface.
 * This program accepts as arguments the standard network
 * addresses, and expands the section of an argument up to a
 * "!" into the actual path the letter must take to get to that
 * site.  For example, to get to swd at duke, the argument
 * "duke!swd" is expanded to "mcnc!duke!swd".  "decvax!ittvax!swatt"
 * would expand to "mcnc!duke!decvax!ittvax!swatt".
 *
 * This program uses the output of the mkpath program developed by
 * Mike Mitchell at ikonas (duke!mcnc!ikonas!mcm).
 *
 * The input data should look like:
 *	sitename (any number of blanks or tabs) printf-string to get there
 *
 * The input data must be sorted.
 *
 * Version 2.0.1 24/7/85
 *
 * Written by Mike Mitchell (decvax!duke!mcnc!ikonas!mcm)
 *
 *
 * M o d i f i c a t i o n    H i s t o r y
 *
 * BFE	3/8/83	wi001	Changed MAILER to /usr/ucb/mail
 *			Added -p option to return the path to stdio only,
 *			this is usefull for emacs mail.
 * BFE	3/9/83	wi002	We are going to substitute this program for standard
 *			mail since it goes on unnoticed to the user.  We only
 *			need to remove a line which prints 'mail ...' just
 *			before the actual mail call.  This way it is truely
 *			invisible to the user.
 * dbw	11/8/83	wi003	Change the MAILER to use MAILER environment variable
 *			with the default being a compile-time option, MAILER.
 *			Change the path	library to live in a compile-time
 *			option DATA.
 * rootcl!njh		I've commented all my changes.
 */

#include <stdio.h>

/* wi001 - changed mailer location */
/* wi003 - change mailer location via makefile */
#define MAILER	"/usr/ucb/mail"		/* the mail program to use */
/*#define MAILER	"/bin/mail"		/* the mail program to use */
/* wi003 - change data location via makefile */
#define DATA	"/usr/local/lib/paths"	/* where the data is kept */
#define OK	1	/* all expansions done correctly */
#define BAD	0	/* an expansion done incorrectly */
/*#define	DEBUG		/* debugging from rootcl!njh */

char	*malloc();
char	*calloc();	/* correct definition rootcl!njh */
char	*index();
char	*strcpy();

main(argc,argv,envp)
int argc;
char **argv;
char **envp;
{
	register FILE *fd;
	char route[BUFSIZ],tmp[BUFSIZ];
	char site[BUFSIZ];
	register char *cp;
	register char **args, *pos;
	/* wi001 - added pflg */
	register num,rc,flag,pflg = 0;


	/* wi001 - accept a '-p' option */
	if(argc > 1 && argv[1][0] == '-' && argv[1][1] == 'p') {
		pflg++;
		argc--;
		argv++;
	}

	args = (char **)calloc((unsigned)argc+1, sizeof(char *));
	if (args == NULL) {
		fprintf(stderr, "Cannot get memory for argument list.\n");
		exit(1);
	}
	/* wi001 - if -p is present then delete 'mail' from argument */
	if (!pflg) {
		args[0] = "mail";
		num = 1;
	} else
		num = 0;	/* rootcl!njh */
	fd = fopen(DATA,"r");
	if (fd == (FILE *)NULL){	/* rootcl!njh */
		fprintf(stderr, "Can't read %s\n", DATA);
		exit(2);
	}
	flag = OK;
	while(--argc) {
#ifdef	DEBUG	/* rootcl!njh */
		printf("while: argc = %d\n", argc);
#endif
		argv++;
		/*
		 * rootcl!njh: use user@site, not site!user.
		 */
		if ((cp=index(*argv, '@')) == NULL) {
			pos = malloc((unsigned)strlen(*argv) + 1);
			if (pos == NULL) {
				fprintf(stderr, "Cannot get memory for name %s\n", *argv);
				exit(1);
			}
			strcpy(pos,*argv);
			args[num++] = pos;
		} else {
			*cp++ = '\0';
			while(fscanf(fd,"%s%s",site,route) != EOF) {
#ifdef	DEBUG
				printf("got site %s route %s\n", site, route);
#endif
				rc = strcmp(site, cp);
				/*if (rc > 0) break;	/* removed rootcl!njh */
				if (rc == 0) {
#ifdef	DEBUG	/* rootcl!njh */
					printf("%s found, route %s\n", site, route);
#endif	DEBUG
					sprintf(tmp, route, *argv);
#ifdef	DEBUG	/* rootcl!njh */
					printf("route will be %s\n", tmp);
#endif	DEBUG
					pos = malloc((unsigned)strlen(tmp)+1);
					if (pos == NULL) {
						fprintf(stderr, "Can't get mem for path %s\n", tmp);
						exit(1);
					}
					strcpy(pos,tmp);
					args[num++] = pos;
					break;
				}
			}
			if (rc != 0) {
				printf("Can't get to %s from here\n",*argv);
				flag = BAD;
				break;	/* rootcl!njh */
			}
			rewind(fd);
		}
	}
	if (flag == OK) {
		/* wi001 - do the mailing only if -p was not specified */
		/* wi002 - print here only if pflg is on (for emacs use) */
		if (pflg) {
#ifdef	DEBUG	/* rootcl!njh */
			puts("pflg set");
#endif	DEBUG
			args[num] = NULL;
			for (rc = 0; rc < num; rc++)
				printf("%s ",args[rc]);
			putchar('\n');
		} else {
			execve(MAILER,args,envp);
			/*
			 * If all else fails! rootcl!njh
			 */
			execve("/bin/mail", args, envp);	
			fprintf(stderr, "execve of %s failed!\n", MAILER);
			flag = BAD;	/* rootcl!njh */
		}
	}
	exit(flag == OK ? 0 : 1);
}
