/* @(#)panel.c	(c) copyright	10/18/86 (Dan Heller) */
/* @(#)panels.c	(c) copyright	9/29/89 (Dan Heller) */

#include "mush.h"
/* mouse symbols */
short dat_mouse_left[] = {
    0x1FF8, 0x3FFC, 0x336C, 0x336C, 0x336C, 0x336C, 0x336C, 0x336C, 
    0x3FFC, 0x3FFC, 0x3FFC, 0x3FFC, 0x3FFC, 0x3FC4, 0x3FFC, 0x1FF8
};

short dat_mouse_middle[] = {
    0x1FF8, 0x3FFC, 0x366C, 0x366C, 0x366C, 0x366C, 0x366C, 0x366C, 
    0x3FFC, 0x3FFC, 0x3FFC, 0x3FFC, 0x3FFC, 0x3FC4, 0x3FFC, 0x1FF8
};

short dat_mouse_right[] = {
    0x1FF8, 0x3FFC, 0x36CC, 0x36CC, 0x36CC, 0x36CC, 0x36CC, 0x36CC, 
    0x3FFC, 0x3FFC, 0x3FFC, 0x3FFC, 0x3FFC, 0x3FC4, 0x3FFC, 0x1FF8
};

mpr_static(mouse_left,      16, 16, 1, dat_mouse_left);
mpr_static(mouse_middle,    16, 16, 1, dat_mouse_middle);
mpr_static(mouse_right,     16, 16, 1, dat_mouse_right);

Panel_item
    folder_item,	/* change folders */
    folder_text_item,	/* text item for the folder item */
    file_item, 		/* text item for the save item */
    msg_num_item,	/* text item explicitly states which message to read */
    read_item,		/* read the current message */
    save_item,		/* saves messages */
    sub_hdr_item[6];	/* display items that just sit there and give help */

/* These global panel items for letter composition should eventually go away */
Panel_item
    edit_item,		/* edit a message */
    reply_item;		/* reply button -- also called from hdr_sw menu */

extern void
    close_frame(), do_options(), do_compose(), do_send(), do_sort(),
    do_edit(), delete_mail(), respond_mail(), do_help(), do_lpr(),
    do_update(), abort_mail(), do_include(), load_from_file(),
    save_to_file(), tilde_from_menu(), fkey_interposer();

extern Panel_setting
    msg_num_done(), file_dir();

Panel
make_hdr_panel(parent, choice_args, button_args)
Frame parent;
char **choice_args, **button_args;
{
    Panel panel = window_create(parent, PANEL,
	WIN_CONSUME_KBD_EVENTS,
	    WIN_LEFT_KEYS, WIN_TOP_KEYS, WIN_RIGHT_KEYS, NULL,
	NULL);
    (void) notify_interpose_event_func(panel, fkey_interposer, NOTIFY_SAFE);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Done", 4, mush_font),
	PANEL_CHOICE_STRINGS,
	    "Close to Icon", "Quit Tool", "Help", NULL,
	PANEL_NOTIFY_PROC, 		toolquit,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Help", 4, mush_font),
	PANEL_CHOICE_STRINGS,
	    "General", "Help with \"help\"", "The Mouse", "Windows",
	    "Message headers", "Message lists", "Folders", NULL,
	PANEL_NOTIFY_PROC, 		do_help,
	NULL);

    folder_item = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Folder", 6, mush_font),
	PANEL_CHOICE_STRINGS,
	    "System Mailbox", "Main Mailbox", "Last Accessed Folder", NULL,
	PANEL_NOTIFY_PROC, 		do_file_dir,
	NULL);

    add_folder_to_menu(folder_item, 3);

    folder_text_item = panel_create_item(panel, PANEL_TEXT,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_FONT, 		mush_font,
	PANEL_LABEL_STRING,		"Filename:",
	PANEL_VALUE_DISPLAY_LENGTH, 	28,
	PANEL_NOTIFY_STRING, 		"\n\r\033",
	PANEL_NOTIFY_PROC, 		file_dir,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Update", 6, mush_font),
	PANEL_CHOICE_STRINGS, 		"New Mail", "Help", NULL,
	PANEL_NOTIFY_PROC, 		do_update,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Options", 7, mush_font),
	PANEL_CHOICE_STRINGS,		"Variables", "Headers", "Aliases", NULL,
	PANEL_NOTIFY_PROC, 		do_options,
	NULL);

    msg_num_item = panel_create_item(panel, PANEL_TEXT,
	PANEL_ATTRIBUTE_LIST,		choice_args,
	PANEL_LABEL_STRING,		"Range:",
	PANEL_MENU_CHOICE_STRINGS, 	"Help", NULL,
	PANEL_VALUE_DISPLAY_LENGTH, 	17,
	PANEL_VALUE_STORED_LENGTH, 	80,
	PANEL_LABEL_FONT, 		mush_font,
	PANEL_NOTIFY_STRING, 		"\n\r",
	PANEL_NOTIFY_PROC, 		msg_num_done,
	NULL);

    sub_hdr_item[0] = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,    		&mouse_left,
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC,    		read_mail,
	NULL);
    sub_hdr_item[1] = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_STRING,   		"Read ",
	PANEL_MENU_TITLE_IMAGE, 	&mouse_left,
	PANEL_CHOICE_STRINGS,		"Help", NULL,
	PANEL_NOTIFY_PROC,    		read_mail,
	NULL);
    sub_hdr_item[2] = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,    		&mouse_middle,
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC,    		delete_mail,
	NULL);
    sub_hdr_item[3] = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_STRING,   		"Delete ",
	PANEL_MENU_TITLE_IMAGE, 	&mouse_middle,
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC,    		delete_mail,
	NULL);
    sub_hdr_item[4] = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,    		&mouse_right,
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC,    		read_mail,
	NULL);
    sub_hdr_item[5] = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_STRING,   		"Menu         ",
	PANEL_MENU_TITLE_IMAGE,	    	&mouse_right,
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC,    		read_mail,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Printer", 7, mush_font),
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC, 		do_lpr,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Sort", 4, mush_font),
	PANEL_CHOICE_STRINGS,
	    "By Date", "By Author", "By Size", "By Subject",
	    "By Subject (ignore Re:)", "By Status", "Help", NULL,
	PANEL_NOTIFY_PROC, 		do_sort,
	NULL);

    window_fit_height(panel);
    return panel;
}

Panel
make_main_panel(parent, choice_args, button_args)
Frame parent;
char **choice_args, **button_args;
{
    /* main panel stuff: */
    Panel panel = window_create(parent, PANEL,
	WIN_CONSUME_KBD_EVENTS,
	    WIN_LEFT_KEYS, WIN_TOP_KEYS, WIN_RIGHT_KEYS, NULL,
	NULL);
    (void) notify_interpose_event_func(panel, fkey_interposer, NOTIFY_SAFE);

    read_item = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Next", 4, mush_font),
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC, 		read_mail,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Delete", 6, mush_font),
	PANEL_CHOICE_STRINGS, 		"Delete",
					"Undelete",
					"Help", NULL,
	PANEL_NOTIFY_PROC, 		delete_mail,
	NULL);

    {
	char *mbox = do_set(set_options, "mbox");
	if (!mbox || !*mbox)
	    mbox = DEF_MBOX;
	save_item = panel_create_item(panel, PANEL_CHOICE,
	    PANEL_ATTRIBUTE_LIST, 	choice_args,
	    PANEL_LABEL_IMAGE, panel_button_image(panel, "Save", 4, mush_font),
	    PANEL_CHOICE_STRINGS, 	trim_filename(mbox), NULL,
	    PANEL_NOTIFY_PROC, 		do_file_dir,
	    NULL);
    }

    add_folder_to_menu(save_item, 1);

    file_item = panel_create_item(panel, PANEL_TEXT,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_FONT, 		mush_font,
	PANEL_SHOW_MENU,		TRUE,
	PANEL_LABEL_STRING, 		"Filename:",
	PANEL_MENU_CHOICE_STRINGS,	"Save message without message header",
					NULL,
	PANEL_VALUE_DISPLAY_LENGTH, 	28,
	PANEL_NOTIFY_STRING, 		"\n\r\033",
	PANEL_NOTIFY_PROC, 		file_dir,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Compose", 7, mush_font),
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC,		do_compose,
	NULL);

    reply_item = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Reply", 5, mush_font),
	PANEL_CHOICE_STRINGS,
	    "Sender Only", "Sender Only (include msg)",
	    "All Recipients", "All Recipients (include msg)", "Help", NULL,
	PANEL_NOTIFY_PROC, 		respond_mail,
	NULL);

    window_fit_height(panel);
    return panel;
}

Panel
make_compose_panel(parent, choice_args, button_args)
Frame parent;
char **choice_args, **button_args;
{
    Panel panel = window_create(parent, PANEL, NULL);
    Panel_item filename_item, fortune_item, sign_item, send_item;

    (void) notify_interpose_event_func(panel, fkey_interposer, NOTIFY_SAFE);

    (void) panel_create_item(panel, PANEL_BUTTON,
	PANEL_ATTRIBUTE_LIST, 		button_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Close", 5, mush_font),
	PANEL_NOTIFY_PROC, 		close_frame,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Compose", 7, mush_font),
	PANEL_CHOICE_STRINGS, 		"Help", NULL,
	PANEL_NOTIFY_PROC, 		do_compose,
	NULL);

    send_item = panel_create_item(panel, PANEL_BUTTON,
	PANEL_ATTRIBUTE_LIST, 		button_args,
	PANEL_SHOW_ITEM, 		FALSE,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Send", 4, mush_font),
	PANEL_NOTIFY_PROC, 		do_send,
	NULL);

    (void) panel_create_item(panel, PANEL_BUTTON,
	PANEL_ATTRIBUTE_LIST, 		button_args,
	PANEL_SHOW_ITEM,		FALSE,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Abort", 5, mush_font),
	PANEL_NOTIFY_PROC, 		abort_mail,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_SHOW_ITEM, 		FALSE,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Include", 7, mush_font),
	PANEL_CHOICE_STRINGS, 		"Include Message",
					"Forward Message",
					"Help", NULL,
	PANEL_NOTIFY_PROC, 		do_include,
	NULL);

    edit_item = panel_create_item(panel, PANEL_BUTTON,
	PANEL_ATTRIBUTE_LIST, 		button_args,
	PANEL_SHOW_ITEM, 		FALSE,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Edit", 4, mush_font),
	PANEL_NOTIFY_PROC, 		do_edit,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_SHOW_ITEM,		FALSE,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Headers", 7, mush_font),
	PANEL_CHOICE_STRINGS,	
	    "ALL      ~h", "To:      ~t", "Subject: ~s",
	    "Cc:      ~c", "Bcc:     ~b", "Fcc:", NULL,
	PANEL_NOTIFY_PROC,		tilde_from_menu,
	NULL);

    sign_item = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_DISPLAY_LEVEL,		PANEL_ALL,
	PANEL_SHOW_MENU_MARK,		TRUE,
	PANEL_SHOW_ITEM, 		FALSE,
	PANEL_LABEL_STRING,		"Autosign:",
	PANEL_CHOICE_STRINGS,		"Off", "On", NULL,
	NULL);
    panel_set_value(sign_item, !!do_set(set_options, "autosign"));
    /* Create a link to avoid global */
    panel_set(send_item, PANEL_CLIENT_DATA, sign_item, NULL);

    filename_item = panel_create_item(panel, PANEL_TEXT,
	PANEL_ATTRIBUTE_LIST, 		button_args,
	PANEL_SHOW_ITEM,		FALSE,
	PANEL_LABEL_STRING,		"Filename:",
	PANEL_VALUE_DISPLAY_LENGTH, 	30,
	PANEL_NOTIFY_STRING, 		"\033",
	PANEL_NOTIFY_PROC, 		file_dir,
	NULL);

    (void) panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_SHOW_ITEM,		FALSE,
	PANEL_CLIENT_DATA,		filename_item,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Import", 6, mush_font),
	PANEL_CHOICE_STRINGS,		"Insert", "Replace", NULL,
	PANEL_NOTIFY_PROC,		load_from_file,
	NULL);

    (void) panel_create_item(panel, PANEL_BUTTON,
	PANEL_ATTRIBUTE_LIST, 		button_args,
	PANEL_SHOW_ITEM,		FALSE,
	PANEL_CLIENT_DATA,		filename_item,
	PANEL_LABEL_IMAGE,
	    panel_button_image(panel, "Export", 6, mush_font),
	PANEL_NOTIFY_PROC,		save_to_file,
	NULL);

    fortune_item = panel_create_item(panel, PANEL_CHOICE,
	PANEL_ATTRIBUTE_LIST, 		choice_args,
	PANEL_DISPLAY_LEVEL,		PANEL_ALL,
	PANEL_SHOW_MENU_MARK,		TRUE,
	PANEL_SHOW_ITEM, 		FALSE,
	PANEL_LABEL_STRING,		"Fortune:",
	PANEL_CHOICE_STRINGS,		"Off", "On", NULL,
	NULL);
    panel_set_value(fortune_item, !!do_set(set_options, "fortune"));
    /* Create a link to avoid global */
    panel_set(sign_item, PANEL_CLIENT_DATA, fortune_item, NULL);

    window_fit_height(panel);
    return panel;
}

#include "glob.h"

#ifdef WALK_MENUS
folder_menu_notify(menu, mi)
Menu menu;
Menu_item mi;
{
}

static Menu_item
add_path_to_menu(menu, path)
Menu menu;
char *path;
{
    DIR			*dirp;
    struct dirent	*dp;
    struct stat 	s_buf;
    Menu_item		mi;
    Menu		next_menu;
    char		buf[MAXPATHLEN];

    /* don't add a folder to the list if user can't read it */
    if (stat(path, &s_buf) == -1 || !(s_buf.st_mode & S_IREAD))
	return NULL;
    if ((s_buf.st_mode & S_IFMT) == S_IFDIR) {
	int cnt = 0;
	if (!(dirp = opendir(path)))
	    return NULL; /* don't bother adding to list if we can't scan it */
	next_menu = menu_create(MENU_NOTIFY_PROC, folder_menu_notify, NULL);
	while (dp = readdir(dirp))
	    if (strcmp(dp->d_name, ".") && strcmp(dp->d_name, ".."))
		if (mi = add_path_to_menu(next_menu,
			sprintf(buf, "%s/%s", path, dp->d_name))) {
		    menu_set(next_menu, MENU_APPEND_ITEM, mi, NULL);
		    cnt++;
		}
	closedir(dirp);
	mi = menu_create_item(MENU_STRING, trim_filename(path), NULL);
	if (!cnt) {
	    menu_destroy(next_menu);
	    menu_set(mi, MENU_INACTIVE, TRUE, NULL);
	} else
	    menu_set(mi, MENU_PULLRIGHT, next_menu, NULL);
	return mi;
    }
    /* we should check that this file is actually a folder */
    return menu_create_item(MENU_STRING, trim_filename(path), NULL);
}
#endif /* WALK_MENUS */

static
add_path_to_menu(item, path, n)
Panel_item item;
char *path;
int *n;
{
    char		**names, **np;
    struct stat 	s_buf;
    char		buf[MAXPATHLEN];

    /* don't add a folder to the list if user can't read it */
    if (stat(path, &s_buf) == -1 || !(s_buf.st_mode & S_IREAD))
	return;
    if ((s_buf.st_mode & S_IFMT) == S_IFDIR) {
	sprintf(buf, "%s/{.*,*}", path);
	if (filexp(buf, &names) > 0) {
	    for (np = names; np && *np; np++) {
		if (!glob(*np, "*/{.,..}"))
		    add_path_to_menu(item, *np, n);
	    }
	    free_vec(names);
	}
    } else if (test_folder(path, NULL))
	panel_set(item,
	    PANEL_CHOICE_STRING, (*n)++, savestr(trim_filename(path)),
	    NULL);
}

/*
 * Open the user's mail folder (either user set or default path) and find all
 * the files (assumed to be mail folders) and add them to the menu list of
 * folders to use.
 */
add_folder_to_menu(item, n)
Panel_item item;
{
    char	*tmp = NULL, *p;
#ifdef WALK_MENUS
    Menu_item	mi;
#endif /* WALK_MENUS */

    if (!(p = do_set(set_options, "folder")) || !*p)
	p = DEF_FOLDER;
    if (p) {
	int x = 0;
	tmp = getpath(p, &x);
	if (x == -1) {
	    if (errno != ENOENT)
		print("%s: %s\n", p, tmp);
	    tmp = NULL;
	}
    }
    if (tmp) {
#ifdef WALK_MENUS
	mi = add_path_to_menu(menu, tmp);
#else /* WALK_MENUS */
	add_path_to_menu(item, tmp, &n);
#endif /* WALK_MENUS */
    }
}
