If the mailbox were already sorted by author,
.sp
.ti +2
pick \-f argv@zipcode.com | sort \-s
.sp
would find all messages from the user \*Qargv@zipcode.com\*U
and sort them by subject.
You may specify the exact message list by specifying
that message list on the command line and using a pipe:
.sp
.ti +2
10\-. | sort d
.sp
This command means to sort the messages from 10 to the current message
according to the date.
.sp
To specify subsorting from with the curses interface, the temporary
curses escape key must be used (the colon `:') and the command issued
at the `:' prompt (as if giving an \*Qex\*U command to \*Qvi\*U).
When the command is finished, the \*Q...continue...\*U prompt is given and
the user may continue or return to the top level of the curses mode.
.sp
In the tool mode, subsorting can be specified only by typing message numbers
in the \*QRange:\*U item at the top of the main frame, before selecting the
\*QSort\*U item.
The sort range must consist of consecutive messages.
Reversed sorting is not currently available in tool mode.
.sp
If the variable
.I sort
is set, messages are sorted each time the user's system mailbox is
read as the current folder.
The
.I sort
variable can be set either to nothing or to legal "sort" arguments.
.sp
\fINote\fR:  For compatibility with older versions, sort options are
recognized even if they are not preceded by a `\-'.
Also, if a `\-' is given by itself (separated by spaces from any following
arguments) it is interpreted as \-r.
.TP
.B stop
For systems with job control, stop will cause
.I Mush
to send a SIGTSTP to itself.
The command was introduced to facilitate
the stop-job action from a complex command line alias rather than the user
having to type his stop character explicitly.
.TP
.B top
Takes a message list and prints the top few lines of each.
The number of lines printed is controlled by the variable
.B toplines
and defaults to the size of the value of the variable
.B crt.
This command is ignored in the tool mode.
.TP
.BR undigest " [-m] [-p pattern] [msg-list] [filename]"
A \*Qdigest\*U is a mail message which is a collection of other mail messages
mailed to a \*Qmoderator\*U by other users.  The moderator compiles all the
messages into a folder and sends the result to all the subscribers of the
mailing list.  The
.B undigest
command disassembles the entries into the set of messages which comprises
the digest.
.sp
The -m option will merge these messages into the current folder.  Otherwise,
if a filename is specified, a new folder is created and the user can change
folders to read the messages separately.
.sp
The -p option specifies an alternate pattern to be used as the digest
article separator.
This pattern must match literally at the beginning of the line.
The default pattern is \*Q\-\|\-\|\-\|\-\|\-\|\-\|\-\|\-\*U (eight hyphens).
This is the defacto USENET standard digest article separator and should
work for most digests, but some use another separator.
The -p option is also useful for \*Qbursting\*U forwarded messages out
of a wrapper message; for example:
.sp
.ti +4
undigest -m -p "--- Forward"
.sp
will burst out messages forwarded by another user of
.I Mush
and merge them into the current folder.
.sp
If a message list is specified, each digest in the list is disassembled to
the same filename (if given).
If no filename is given and the user did not request
a merge, then a temporary file is made.
.TP
.BR update " [-r]"
Updates your current folder, writing back changes just as if you
.BR quit.
Headers are not listed when the folder is read back in.
The \-r option puts the folder into read-only mode
.I after
updating it.
.sp
See the
.BR folder
command for complete information.
.sp
.SH VARIABLES
Shell variables are controlled via the
.B set
and
.B unset
commands.
Options may be either boolean, in which case it is only
significant to see whether or not they are set;
string, in which case the actual value is of interest;
numerical, in which case the numerical value is important;
or multivalued, in which case they may be set to a list of values.
Some variables may have attributes
of boolean and string or multivalued at the same time.
.PP
If you or the program references a variable that is not explicitly set,
then the environment variables are checked and that data is returned.
.PP
Variable values can be modified by one of four variable modifiers, or by a
numeric string.
The modifiers `:h', `:t', `:l' and `:u' may be applied to the variable names.
The current implementation allows only one `:' modifier on each `$' expansion.
.TP
:t
The variable is treated as a file path name, and the name of the file
(the \*Qtail\*U of the path) is substituted for the variable.
That is, everything to the right of the last `/'
is returned.
.TP
:h
The variable is treated as a path name, and the \*Qhead\*U of the pathname
is substituted for the variable.
That is, everything up to, but not including, the last `/' is returned.
.TP
:l
All alphabetic characters in the variable's value are converted to lower case.
.TP
:u
All alphabetic characters in the variable's value are converted to upper case.
.TP
.RI : number
The value of the variable is converted to a list of space-separated words,
which are numbered from one (1), and the word described by
.I number
is selected and returned.
It is not an error for
.I number
to be greater than the actual number of words; an empty string is returned
in this case.
.PP
Following is a list of all variables with predefined meanings.
.TP
.B alwaysignore
(Boolean/Multivalued)
If set with no value, the mail headers set by the
.B ignore
command are always ignored.
Normally, ignored headers are not ignored when sending messages to
the printer, when interpolating messages into letters with ~f or ~I,
when the `P' or `T' command is given (see the \fBprint\f command),
or with the \-I flag to the
.B mail
or
.B reply
commands.
Setting
.B alwaysignore
will ignore those headers even in the situations mentioned here.
No headers can be ignored during updates and when using the
.B save
command since the user may ignore headers that are required by
.I Mush
or any other mail system to read those folders.
.sp
This variable can also be set to a list of words
separated by commas or spaces.
Currently recognized words, and their meanings, are:
.nf
.ta 1.5i
.in +4
.\" \& escapes are to make obvious the tab after each word
forward\&	Ignore headers when forwarding messages (~f).
include\&	Ignore headers when including messages (~I).
pipe\&\&	The \fBpipe\fR command ignores headers.
printer\&	The \fBlpr\fR command ignores headers.
.in -4
.fi
.sp
Also see the
.B ignore
command and the
.B show_hdrs
variable for more information.
.TP
.B ask
(Boolean)
If set, you will be prompted for a subject header for outgoing mail.
Use the tilde escape \*Q~s\*U to set the header once in the message
or specify the \-s option on the
.B mail
command line at the
.I Mush
prompt.
.TP
.B askcc
(Boolean)
If set, you will be prompted for a Cc (carbon copy) list when you are
finished editing a letter to be sent.
If the variable
.B edit_hdrs
is set, prompting will not occur, but a Cc: line will be added to the
edit file.
This also applies to the tool mode.
.TP
.B autodelete
(Boolean)
When exiting mail, all messages that have been read
.I "regardless of whether they have been marked for deletion"
are removed.
Only messages that haven't been read or that have been marked as
.B preserved
are not removed.
.TP
.B autoedit
(Boolean)
If set, you are automatically put into your editor whenever you
send or reply to mail.
.TP
.B autoinclude
(Boolean)
When replying to any mail, a copy of the message being replied to
is automatically inserted into your message body indented by
the string described by the variable
.BR indent_str .
.TP
.B autoprint
(Boolean)
After you delete a message, the next message is printed automatically.
.TP
.B auto_route
(Boolean/String)
If set boolean (not to a string), all the recipients in a message that
is being replied to (via \fBreplyall\fR), will be routed through the path
back to the original author.
.sp
For example, if the original sender of a message came from the remote host
.B c3p0
and the list of recipients looked like
.sp
.nf
.in +2
From: c3p0!user1
To: yourhost!you
Cc: r2d2!user2, r2d2!user3
.in -2
.fi
.sp
then clearly, \*Quser1\*U on the machine c3p0 can talk to your machine
and the machine named r2d2.
However, you would not be able to respond to those users if your machine
did not exchange UUCP mail with the host r2d2.
.sp
.I Mush
will attempt to solve this problem by reconstructing the addresses
for \*Quser2\*U and \*Quser3\*U according to the address of the original
sender, \*Qc3p0\*U.
The new addresses for \*Quser2\*U and \*Quser3\*U should therefore become
.sp
.ti +2
c3p0!r2d2!user2, c3p0!r2d2!user3.
.sp
If your machine not only talks to c3p0,
but talks to r2d2 as well, it becomes unnecessary to route the mail
through both c3p0 and r2d2.
So, the variable
.B known_hosts
may be set to a list of hosts which you know your machine to have
UUCP mail connections with.
This list is checked when constructing mail addresses for replies only and
the shortest path is made by removing from the UUCP path those hosts
that do not need to be called or are redundant.
See the entry for
.B known_hosts
for more information.
.sp
If
.B auto_route
is set to a specific \fBpathname\fR (host names separated by !'s),
all addresses in the reply will have this route prepended to their addresses.
This ignores the original path of the author.  This is quite useful for
hosts which talk uucp to a node which is connected to the internet or uunet
since both of those machines tend to be one-hop away from all other hosts
(or reroute accordingly).  For example, if a message was addressed like so:
.sp
.in +2
.nf
To: root@ucbvax.berkeley.edu, argv@zipcode.uucp
Cc: ucbcad!foo!bar
.sp
.fi
.in -2
If auto_route were set to "ucbcad", then replies to this address would be
directed addressed like so:
.sp
.in +2
.nf
To: ucbcad!ucbvax.berkeley.edu!root, ucbcad!zipcode.uucp!argv
Cc: ucbcad!foo!bar
.sp
.fi
.in -2
.sp
This assumes that the host in question talks uucp with ucbcad.  This example
demonstrates several things.  First, notice that all addresses are converted
to uucp-style format.  Whenever routing is changed, the format is converted
like this.  Secondly, note that the Cc: line did not change.  This is because
all redundant hostnames from UUCP pathnames are removed
to avoid unnecessary UUCP connections and speed up mail delivery.
.sp
Another example of how auto_route truncates UUCP paths:
.sp
.ti +2
pixar!island!sun!island!argv
.sp
Here, mail was probably originally sent to users at pixar and sun from
somewhere undetermined now.
Since sun and pixar do not talk to each other, the users on those machines may
have responded to mail creating the type of addresses stated above.
Here, it can be seen that we can reduce the path to the host
.IR island :
.sp
.ti +2
pixar!island!argv
.sp
See the MAIL ADDRESSES section for more detailed information
about legal mail addresses.
.sp
Note that the -r flag to \fBreply\fR and \fRreplyall\fR overrides the
value of \fBauto_route\fR.
.TP
.B autosign
(Boolean/string)
Append a signature to outgoing mail.
If this variable is set, but not to a string (e.g., boolean-true)
then the file ~/.signature is used.
.sp
Otherwise, the variable is interpreted in one of four ways.
By default, the string is interpreted as a pathname relative to the
.I current
directory.
For this reason, it is advisable to use full pathnames here.
As usual, the special characters `~' and `+' are expanded.
If a file is found, it is opened and its contents are read into the
message buffer.
.sp
If the variable is set to a string that begins with `$', then that string
is interpreted as a user-definable variable and is expanded and appended
to the letter.
.sp
If the variable is set to a string that begins with a backslash (\\)
then the string itself (minus the `\\' character) is used; no expansion
is done and no files are read.
.sp
Finally, if the variable is set to a string that begins with a vertical
bar (or \*Qpipe\*U) character (|), the rest of the string is interpreted
as a command whose output will be used as the signature.
The special characters `~' and `+' are NOT expanded in the command name,
but the command is run via /bin/sh so $PATH will be searched and redirection
can be specified.
The list of addresses to which the letter will be sent is passed to
the command as its arguments, in the same form that they will be passed
to the Mail Transport Agent (MTA).
Depending on your MTA, each address may be followed by a comma.
.sp
In the latter three cases, it is advisable to set the variable using single
quotes to protect the `$', `\\' and `|' characters from being interpreted.
Examples:
.sp
.nf
.ti +2
set autosign = '$foo'
.ti +2
set autosign = '\\  Dan Heller zipcode!argv@ucbcad.berkeley.edu'
.\" Need a pipe example?
.fi
.sp
.BR Warning :
if redirection from the calling shell is used,
no signature or fortune will be added to outgoing mail.
For example,
.sp
.ti +2
% mush \-s report manager < report_file
.sp
In this command, mail is being sent to the user \*Qmanager\*U and the
subject is set to \*Qreport\*U and the file \*Qreport_file\*U is being
redirected as input.
In this case, there will be \fIno\fR signature appended.
.sp
.IR Note :
The `|' syntax for calling a program to sign the letter is a little
counterintuitive and may change in future releases.
.TP
.B autosign2
(String)
This alternate signature is available for special cases where the default
signature is not desired or if no signature is desired for special addresses
or if only special addresses require a signature.
The format for this variable is:
.sp
.ti +2
autosign2 = \*Qaddress1, address2, ... : <signature>\*U
.sp
Each address can be one of these types:
.RS
.TP
1)  address
Legal mailing addresses that do not contain comment
fields (see the sections MAIL ADDRESSES for more information on legitimate
mail addresses) will match literally.
.TP
2)  *username
If the username is present on the recipient list, regardless of what
remote site the user may reside on (including locally), the pattern matches.
.TP
3)  !hostname !host1!host2...
Any user who appears as a recipient will match the pattern provided he
resides on the specified hostname.
If a path of hosts is specified, then the user must reside on the last
host of the specified path.
.\" Nroff note: there is a problem with the @sub.domain line.  Why?
.\" The .br is intended to deal with this.
.TP
4)  @sub.domain
.br
The user must reside on any host within the domain specified.
Neither the user or the hostname needs to match; only the domain name must
be required to match.
.RE
.\" Nroff note: RE takes us all the way out of TP, so step back in again.
.RS
.sp
Example:
.sp
.nf
.ti +2
set autosign2 = \*Q!zipcode @sun.com @mit.edu *schaefer root: \--dan\*U
.fi
.sp
This means that any mail sent to 1) anyone at zipcode, 2) anyone within
the sun domain, 3) anyone within the mit domain, 4) Bart Schaefer
(at any host anywhere -- even locally),
and 4) root on the local machine only (or, root@local-machine-name)
will be signed with the \*Qalternate\*U signature.
If any address on the
recipient list fails to satisfy these four matches, the mail will be
signed by my regular signature.
.sp
One can have a local signature and a remote signature by specifying
the autosign2 to include the hostname of the home machine the user
is logged into.  Note the \*Qzipcode\*U example above.
.sp
The list of recipients, after alias expansion and comment removal, is
then scanned and the following patterns are matched against those addresses
specified in the autosign2 or fortunates variable according to these rules.
.sp
The signature description is the same as described by
.B autosign
variable.  The colon (:) separates the list of addresses from the signature
description.  If there is no colon or the address list is missing, the
entire string is considered the signature (except for the colon).
.sp
If
.B autosign
is not set, then autosign2 will ONLY work if the tilde command \*Q~S\*U
is specified.  In this way, a user may never have autosign set and just
set autosign2 to be some signature value.  The user may then issue the
tilde command to automatically sign the letter.
If a list of addresses is given (terminated by a colon), then all
recipients of the message must be in the list of addresses in autosign2;
otherwise, the signature in \fBautosign\fR (if set) is used instead.
A null signature in autosign2 will not sign the letter.
.sp
Example:
.sp
.nf
.ti +2
set autosign2 = "fred, barney, wilma, betty: ~/flintstone.sig"
.fi
.sp
If a message is sent to:
.sp
.ti +2
To: fred, wilma
.sp
Then the file ~/flintstone.sig will be used.
However, if the address were:
.sp
.ti +2
To: barney, betty, bambam
.sp
Then autosign2 will not be used because bambam is not in the list.
.sp
Note that mail sent via redirection from the calling shell will not
sign letters or append fortunes.
.RE
.TP
.B cdpath
(String)
Set to a string of pathnames separated by spaces to use when searching
for a directory when the
.B cd
command is issued.
If this variable is used, it is recommended that the path `.' be included.
Note that this differs from the
.IR csh ,
which does not require that `.' be present.
.TP
.B cmd_help
(String)
This variable gives the path name of the general help file, which is read
by the
.B help
command.
This variable is normally reset only in the system initialization files,
when the default location of the help file has changed.
.TP
.B complete
(String)
Setting this variable enables word completion.
The first character of the value of
.B complete
is used as the
.IR "completion character" ;
if
.B complete
is set, but not to a value, the escape character is used as the default.
When the completion character is typed at the end of a word prefix,
.I Mush
will interactively complete that word.
If the prefix is not unique, the word will be completed as far as possible
and a bell will sound (see, however, the variable
.BR quiet ).
If the word contains filename metacharacters,
.IR "all possible matches will be completed" .
If the list overflows the command line buffer, it will be truncated, so
this feature should be used with care.
Metacharacters recognized are the same as in
.IR csh .
.sp
The second character of the value of
.B complete
is used as the completion listing character.
When this character is typed, the possible completions will be printed, and
.I Mush
will prompt again with the original prefix.
If
.B complete
is set to only a single character, completion listing is disabled;
if it is set with no value, control-D (^D) is used as the default
listing character.
.sp
See the description of the variable
.B fignore
for ways to exclude filenames from completions.
.sp
Word completion is currently supported only for file names.
Command name and alias completion may be added in a future version.
Completion is not possible if the \-e (\-echo) flag was given, and
is currently not available in tool mode.
.TP
.B crt
(Numeric)
Set to a value that describes the number of lines a message
must have before invoking the
.B pager
to view a message.
.TP
.B crt_win
(Numeric)
Set to the height (in lines) of the message display window in tool mode.
.TP
.B curses_help
(String)
This variable may be set to a space-separated list of curses mode command
names (see the CURSES section for the possible choices).
If set but without a value, a default list established by your
.I Mush
maintainer is used.
When it is set, a display of the current bindings for the listed commands
will appear at the bottom of the screen in curses mode.
This help display will normally shorten the display of headers, but the
the user may explicitly scroll over the help display if he wishes to see
more headers.
.TP
.B cwd
(String)
The
.B "current working directory"
string is automatically set upon startup of
.I Mush
and is reset each time the commands
.B cd
and
.B pwd
are called.
It may be changed or referenced like any other shell variable.
.TP
.B date_received
(Boolean)
When message headers are printed, the date is normally shown is
the time and date the sender sent the message.  If this variable
is set, then the date displayed is the date received.
.sp
When sorting messages by date, this variable is queried to determine
whether the messages should be sorted by date sent or date received.
.sp
\fBWarning:\fR For mailers that store messages \fIwithout\fR a line
that starts with \*QFrom \*U, this option does nothing.
.TP
.B dead
(String)
File to use instead of dead.letter when interrupted mail is saved.
May be set to a \fIunix\fR command by prefixing the value with `|'.
For more information, see the variable
.B nosave.
.TP
.B domain_route
(Boolean/String)
In combination with
.BR auto_route ,
this variable specifies that addresses containing a fully-qualified domain
should be short-circuited to mail directly to the rightmost fully-qualified
domain.
If set boolean (not to a string), only short-circuiting is done.
If set to a string, the address is rewritten to UUCP form and the value
of the variable is prepended.
Domain short-circuiting applies \fIonly\fR to addresses containing a
fully-qualified domain, but short-circuits in spite of any path specified
with the \-r flag of
.B reply
or through the string value of
.B auto_route
(thus possibly omitting the auto_route or \-r paths altogether).
See
.B auto_route
for more information.
.TP
.B dot
(Boolean)
Causes
.I Mush
to accept a `.' on a line by itself,
in addition to `^D', to terminate messages.
.TP
.B editor
(String)
Specifies the editor to use when the \*Q~e\*U escape or the
.B edit
command is used.
Default is the value of the environment string EDITOR or the variable
.BR visual .
.TP
.B edit_hdrs
(Boolean)
When in letter-composition mode (via \fBmail\fR or \fBreply\fR, etc),
the headers of the outgoing message are stored in the same buffer as
the text of the letter.
So, if the editor is called to edit the message
buffer, the headers of the message can be edited as well.
However, there are some restrictions.
.sp
There must be a To: header.
Without this, 
.I Mush
will not deliver the letter.
Instead, the editor must be reentered and a To: header with
a valid recipient must be inserted.
A valid Cc: header does not remove this restriction.
You may have as many To: and Cc: headers as you like.
.sp
The From: header normally should not be changed.
If you change this header to an address that
.I Mush
is unable to identify as
authentic, the original From: header will silently be put back.
.sp
The Date: header will always be replaced by one with a more accurate
time and date stamp.
Therefore, changing or removing this header has no effect.
.sp
You cannot add a Status: header, and blank headers are dropped.
For example, if an empty Cc: header exists, the header will
not show up in the outgoing message.
Therefore, leaving empty headers has no effect.
.sp
Aliases specified on the command line are expanded and put into the
message buffer in their expanded form regardless of the value of
.B no_expand.
However, if the user changes the headers using the editor and specifies
aliases, those aliases will not be expanded if
.B no_expand
is set.
Otherwise, they are expanded as usual.
.sp
The headers Bcc: and Fcc: are removed as expected.
.sp
One added side effect of
.B edit_hdrs
is that you can add an Fcc: header to specify a \*QFile Carbon Copy\*U.
This must be a pathname to a file or program.
For programs, the pathname must be preceded by a pipe character (|).
Note that \fIall\fR addresses on the Fcc: line that do not begin with `|'
are interpreted as file names; don't put other kinds of addresses there.
.sp
When using
.B edit_hdrs,
certain tilde escapes don't work.
Specifically, any tilde escape that allows you to add or set headers or to
empty the file are inactive.
These functions are to be done in the editor only.
.sp
Once a letter is being edited,
.B edit_hdrs
cannot be set or unset; the user must end the letter (either
by sending it or forcefully terminating it) first.
.sp
Header editing is required (and happens automatically) when using the
\*QCompose\*U tool mode item.
.TP
.B escape
(Character)
When composing a mail message (not in an editor), and the
.B escape
character is the first character on the line, the next character
is examined and a corresponding function associated with that
.I "escape command"
is executed.
See
.B "tilde escapes"
for more information.
.TP
.B fignore
(String)
This variable is tested when filename completion is used (see the variable
.B complete
for details).
The value of
.B fignore
may be a list of filename extensions (\*Q.c\*U, \*Q.o\*Q, etc.), a list
of filename patterns containing metacharacters (*?{}[]), or a mixture of
the two.
Each element in the list must be separated from the others by a space.
When a filename completion occurs, any filenames with the extensions
listed in
.BR fignore ,
or matching the patterns given there, will be omitted from the completion.
.sp
For example,
.sp
.ti +4
set fignore = ".o .s [Mm]ake*"
.sp
will cause any filename ending in \*Q.o\*U or \*Q.s\*U, and any filename
beginning with \*QMake\*U or \*Qmake\*U, to be excluded from completions.
.sp
If all files in the current directory match the extensions or patterns,
.B fignore
is disabled and completion will occur.
For this reason, it is usually not a good idea to include \*Q*\*U in the list.
.TP
.B folder
(String)
The folder variable is set to the path of a directory where folders are kept.
This path is used by various commands to expand the `+' metacharacter (see
the
.B folder
command for details).
\*Q~/Mail\*U is the default expansion of `+'.
.TP
.B fortune
(Boolean/string)
If fortune is set, a random fortune is appended to the end of
all outgoing mail using the
.IR UNIX (TM)
command
.B /usr/games/fortune
(may vary from system to system).
If fortune is set to something that starts with
a `\-', then it is interpreted as a flag to fortune (e.g., \*Q\-o\*U).
If
.B fortune
starts with a `/', then the program described by
the string is executed (thus not doing fortune at all, if you want).
By default,
.I "fortune \-s"
(short fortunes) is used.
.TP
.B fortunates
(String)
When fortunes are added to messages, sometimes it is desirable to
make sure that only a selected group of people get a fortune since
certain people may not understand the messages at the end of your
mail.  Therefore, you can set a list of addresses (either pure addresses
or aliases that are expanded to addresses) to be the only people who
receive fortunes if one is to be appended.  Therefore,
if the To: and Cc: lines contain only address listed in this string
variable, then a fortune is appended to the message.
If those lists contain names that are not on the fortunates
list, then no fortune is added.
This cannot be overridden; using the
tilde command \*Q~F\*U does not force a fortune to be added unless the
individuals on the recipient list are all included in the fortunates
list.  The list is made up of addresses or aliases separated by spaces or
commas.
.I "NOTE: fortune must be set in order for fortunates to work."
.TP
.B hangup
(Boolean)
If this variable is set,
.I Mush
will update your folder before exiting when it receives a SIGHUP signal.
This is useful if you frequently read mail when dialed in over a noisy phone
line that often drops carrier.
.sp
.IR WARNING \|:
Certain errors are ignored during this update, because it is presumed to be
impossible to query the user for instructions.
Except in the event of a write error, the folder will be forced to contain
exactly those messages that were not deleted at the time of the hangup.
In particular, this means that if an error occurs when loading new mail before
the update, the new mail will be lost.
Write errors will still cause both the working tempfile and as much of the
folder as possible to be preserved.
.TP
.B hdr_format
(String)
This variable controls the format of the headers displayed by the
.B headers
command and in the curses and tool modes.
The format style of this variable string is similar to printf in C.
When printing the information, the variable is evaluated and each
character in the string is echoed unless a `%' character is
encountered.
If one is found, the following string substitutions are made:
.sp
.in +2
.nf
.ta 0.5i
%a	address of the author
%c	number of characters (bytes) in the message
%f	entire \*QFrom:\*U field (author)
%l	number of lines in the message
%i	the message-id (may not be present)
%n	name of the author
%s	subject of the message
%t	\*QTo:\*U field (recipients)
%d	date and time of the message
%T	time only of the message
%N	day number of the month of the message
%W	day of the week (Sun, Mon, etc.)
%M	month name of the message
%Y	year of the message
%y	last two digits of %Y
%Z	time zone of the message
\\n	a newline
\\t	a tab
.fi
.in -2
.sp
A field width specifier may be used in all options.
Thus, \*Q%20f\*U will print the
first 20 characters of the from line.
No matter what the formatting string, the message number
followed by a `>' (for current message) is printed.
.sp
The \*Qaddress\*U and \*Qname\*U of the author
are extracted from the \*QFrom:\*U field of the message.
The name may be given in parentheses and
the rest of the line is the address, or the address is given in angle
brackets (`<' and `>') and the rest of the line is the name.
Sometimes the address is the only thing on the line,
in which case the name and address are the same.
.sp
A special format is also provided to obtain the contents of any header
not listed above.
If a format of the form \*Q%?header-name?\*U (both leading and following `?'
characters are required) appears in the value of 
.BR hdr_format ,
the named header will be looked up.
For example,
.sp
.ti +4
set hdr_format = "%a %n %?phone?"
.sp
causes the electronic address, name, and (if a \*QPhone:\*U header is present)
phone number of the sender to be displayed.
.TP
.B history
(Numeric)
This variable is set to the number of commands the shell interface
will remember.  It is just like the history variable used in
.I csh.
If unset, the last command can always be referenced, but none other.
.TP
.B hold
(Boolean)
Normally, on termination of mail, read messages are saved in
your mbox (except those marked as preserved).
Setting
.B hold
prevents this from happening,
and messages remain in /usr/spool/mail/user.
This does not apply to folders, obviously.
.TP
.B home
(String)
This variable describes the user's home directory.
The variable is initialized to the value of the environment variable HOME,
but can be modified at any time during the
.I Mush
session.
The home directory is the same directory where temporary
files are kept for editing and so forth.
If the home directory cannot be found or read/write access is denied, an
alternate directory, typically /tmp, is used.
.TP
.B hostname
(String)
This is the name of your computer.  Currently, its sole usage is to
compose a correct \*QFrom:\*U line for use with Mail Transport Agents
that do not create this header automatically.  This will aid the
recipients of your mail in replying to your messages.
.sp
Note: the user should not have to set
this variable since it should be set automatically by the system.  However,
it may happen that the system's hostname cannot be queried and the user may
have to set this variable manually.
.TP
.B ignore_bang
(Boolean)
If set,
.I Mush
will ignore the `!' character as a history reference.
Note that this severely limits use of the
.B cmd
facility, which depends upon history references for argument substitutions.
.TP
.B ignoreeof
(Boolean/string)
If set, `^D' will not exit from
.IR Mush .
If set to a string, that string is executed as a command
when `^D' is typed.
This does not effect termination of messages under the
.B mail
and
.B reply
commands.
.TP
.B indent_str
(String)
When including messages into the text of a letter you are editing,
each line of the messages is preceded by the value of
.BR indent_str .
If it is unset, the message body is indented by the string \*Q> \*U.
See also the variables
.B pre_indent_str
and
.BR post_indent_str .
.TP
.B in_reply_to
(String)
This variable may be set to a string that will complete the
header \*QIn-Reply-To:\*U.
The format of this string is identical to the options for the variable
.BR hdr_format .
.sp
For example, if the user were to respond to a message
from Dan Heller that was sent on October 21, 1987, at 10:39pm, with
.B in_reply_to
set to the string
.nf
.in +2
.sp
%n's message as of %d.
.sp
.ti -2
the header line
.sp
In-Reply-To: Dan Heller's message as of Oct 21, 1987, 10:39pm.
.in-2
.fi
.sp
would be added to the message.
.TP
.B keepsave
(Boolean)
If set, the commands
.B save
and
.B write
will
.I not
mark messages for deletion.
.TP
.B known_hosts
(String)
Used in conjunction with the variable
.BR auto_route ,
this variable is set to a list of hosts, separated by spaces, tabs,
and/or commas, and describes
the hosts with whom you know your machine shares UUCP connections.
When replying to mail, many times you will see that the return path
constructed will have hostnames that your site could call, but instead
the mail has been routed through a number of different machines first.
.sp
For example, if you respond to mail that would mail to the path
.sp
.ti +2
unicom!pixar!root
.sp
but your know your machine already calls pixar, then sending the mail
to unicom first is unnecessary.
If you have set your known_hosts string to include pixar in its list,
the resulting address would look like
.sp
.ti +2
pixar!root
.sp
Also see the command
.B replyall
for more information on constructing correct return addresses.
.TP
.B logfile
(String)
Set to a filename which logs the headers of outgoing messages.  The message
body of the message is not logged as it is for the
.B record
filename.  The logfile can be read as a folder to scan for the fact that
messages have been sent.  If \fBlogfile\fR and \fBrecord\fR are both set,
then the logfile and the record files will match exactly.  In this case,
the record file can be quickly scanned by scanning the log file instead.
.sp
If set, but not to a string, the log file defaults to ~/mail.log.
.TP
.B mail_icon
(String)
Set to a pathname for an alternate icon pixmap to use when the
.I Mush
tool is closed.
The number of messages in the mailbox is displayed as an icon label unless
the string
.I iconlabel
appears as one of the values of the variable
.BR quiet .
See also the variable
.B newmail_icon
for the icon displayed when new mail arrives or is present.
.TP
.B mbox
(String)
Set to the pathname of a file you'd like 
.I Mush
to use as the default folder for read mail.
The default is ~/mbox.
.TP
.B metoo
(Boolean)
When replying to mail, you are normally deleted from the list of
recipients.
If metoo is set, you remain on the list.
See the 
.B alternates
command
for information on determining whether or not you're even on the list.
.TP
.B mil_time
(Boolean)
Whenever the time is displayed in a message header or in the prompt,
it can be displayed in either 12-hour am/pm format, or in 24 hour
military time format.
The default is the 12 hour format, but can be
reset to use the 24 hour format by setting this variable.
.TP
.B newline
(Boolean/string)
If set, carriage returns are ignored.
If set to a string, that string is executed as a command when a
carriage return is typed.
Otherwise, carriage return prints the next undeleted message.
.B newmail_icon
(String)
Set to a pathname for an alternate icon pixmap to use
when new mail is available.
.TP
.B no_expand
(Boolean)
When a
.I Mush
alias is used to reference a list of addresses, the list is expanded on
the To: and Cc: lines to indicate the complete list of all the recipients of
the message.
When no_expand is set, aliases are not expanded and the headers
reflect the same information as typed by the user.
.TP
.B no_hdrs
(Boolean)
If set, this variable tells 
.I Mush
not to include your personalized mail headers in messages.
This does not unset your headers, it just disables them.
.TP
.B no_reverse
(Boolean)
In curses mode and in the tool mode, reverse video is not used to indicate the 
.I "current message"
if this variable is set.
In the tool mode, if reverse video is not in use,
text is displayed in \*Qbold\*U.
.TP
.B nonobang
(Boolean)
If this variable is set, history references that don't match anything will
be left unexpanded, rather than generating error messages.
This is useful if you want argument referencing in
.B cmd
expansions, but do
not want to remember to escape every `!' you type in UUCP addresses.
It is also recommended for use with curses mode, because history is not
kept for line mode escapes from that interface.
.TP
.B nosave
(Boolean)
When composing a letter, the user can terminate the letter without sending
it by using the tilde escape \*Q~q\*U or by sending two \*Qinterrupt\*U
signals.
When the message is terminated, a copy of it is saved to the
file \*Qdead.letter\*U in the user's home directory or to the file described
by the variable
.BR dead .
If the variable
.B nosave
is set, then a backup copy of the message will not be saved.
.TP
.B output
(Read-only string)
This variable holds a message list representing the output of the last
successful command.
This is useful for recovering from broken pipes or to capture the output
of a command without affecting the information it displays (some commands
limit or suppress output when used in a pipeline).
Commands which return an error status (see the variable
.BR status )
do not affect the value of
.BR output ,
but successful commands that return no message list will clear it.
Also, many curses mode commands return an error status to indicate that
the display has been altered, even if no actual error occurred.
This variable is thus most useful in line mode and in scripts.
.TP
.B pager
(String)
If a message is longer than the number of lines that the variable
.B crt
is set to, then this program is executed to view a message.
If the user does not have this variable set, the user's environment PAGER
is checked.
If this isn't set, then the default value for pager (set up
by the system manager) is used.
This may or may not be the internal pager.
To use the internal pager, you may set the variable pager to
.I internal
or to a null string.
.TP
.B pre_indent_str
(String)
If this variable is set, when including the body of a message into an outgoing
mail message (using the \-i option to
.I reply
or
.IR mail ,
or when using the \*Q~i\*U escape),
a line preceding the first line of
included text is printed using the string value of the variable.
This string uses the same printf style formatting characters as the
.B hdr_format
variable.
For example, you could set
.B pre_indent_str
as follows:
.sp
.ti +2
set pre_indent_str = '[In the message entitled "%s", on %7d\\n %n writes:]'
.sp
You can then include a message body using \*Q~i\*U, and you might
get something like this:
.sp
.in +2
.nf
[In the message entitled "This is a test.", on Jan 19,
 Dan Heller writes:]
> This is a test message to show how
> pre_indent_str might be used.
.ti -2
.sp
.fi
This example assumes that the string value of
.B indent_str
is not set.
.TP
.B post_indent_str
(String)
This variable has the same function as
.B pre_indent_str
except that the string is inserted into the message body
.I after
the text of the included message rather than before.
The purpose of this variable is to complement the string described by
the variables
.B pre_indent_str
and
.BR indent_str .
For example,
.sp
.in +2
.nf
set pre_indent_str = "/*"
set indent_str = " * "
set post_indent_str = " */"
.sp
.ti -2
An included message might look something like this:
.sp
/*
 * This is a test message to show how
 * post_indent_str and pre_indent_str
 * can work together with indent_str.
 */
.fi
.in -2
.TP
.B printer
(String)
Used to set the default printer for the lpr command.
.TP
.B print_cmd
(String)
This string should describe a
.IR UNIX (TM)
command other than "lpr" for sending
messages to the line printer.
Some people may choose to use a device independent
troff style program, but virtually any UNIX command will suffice.
Common usage might include:
.sp
.ti +2
set print_cmd = 'ptroff \-ms \-Plp'
.ti +2
lpr .\-$
.sp
This command would send all messages from the current message to the last
message through the ptroff command, supplying the appropriate arguments.
.TP
.B prompt
(String)
You can set your prompt to tell you many different pieces of information.
By default, the prompt is set to the string
.sp
.ti +2
\*QMsg %m of %t: \*U
.sp
If you have 10 messages and your current message is 5, then your prompt
would look like:
.sp
.ti +2
Msg 5 of 10:
.sp
The string value that prompt is set to will be printed as your prompt.
If the string contains a `%', then that character is
ignored, the next character is evaluated and an appropriate
value is printed in its place:
.sp
.nf
.in +2
.ta 0.5i
%F	full path name of the current folder
%f	name of the current folder (tail of %F)
%m	\*Qcurrent message\*U number
%t	total number of messages
%n	number of \*Qnew\*U messages
%u	number of unread messages
%d	number of deleted messages
%T	current time (hours and seconds)
%N	today's date (Number of the day in the month)
%W	weekday name (Sun, Mon, Tue, ...)
%M	current month
%Y	this year
%y	last two digits of %Y
\\n	a newline
\\t	a tab
.fi
.in -2
.TP
.B quiet
(Boolean/Multivalued)
This variable tells
.I Mush
to be quiet in various circumstances.
If set, but not to any values, the currently running version of
.I Mush
is not printed on startup.
Otherwise,
.B quiet
may be set to one or more words separated by spaces or commas.
Currently recognized words are:
.sp
.nf
.ta 1.5i
.in +4
.\" \& escapes are to make obvious the tab after each word
autosign	Suppress messages when appending signature.
await\&\&	Suppress \fBawait\fR's bell for new mail.
complete	Suppress word completion error bells.
fkey\&\&	Suppress warnings about unset function keys.
fortune\&	Suppress messages when appending fortune.
iconlabel	Suppress showing message count as icon label.
newmail\&	Suppress new mail notification messages.
pick\&\&	Suppress descriptions of pick searches.
startup\&	Suppress the startup message.
tool\&\&	Suppress tool mode bell for new mail.
.in -4
.fi
.sp
Error conditions for signatures and fortunes are still reported.
See the variables
.BR autosign ,
.BR complete ,
and
.B fortune
for more details.
The
.I newmail
setting does not prevent automatic inclusion of new mail, it only
suppresses the announcement of its arrival, including tool mode bells.
The
.I fkey
setting applies only to tool mode.
.TP
.B realname
(String)
Set to the name of the user.
The name is initialized to the value of the environment variable
.B NAME
upon invocation of the program.
If that isn't set, then the name is gotten from the password file if
available.
If this variable wants to be reset or changed after the
program has started, the user should issue the command:
.sp
.ti +2
set realname = "Your name here"
.TP
.B record
(String)
Set to the name of a file to record all outgoing mail.
This should be a full pathname or the current directory is searched.
The pathname may begin with `+' (indicating the user's ~/Mail directory
or the value of the 
.B folder
variable) or with a `~' (or \*Q~user\*U)
indicating the user's home directory.
.TP
.B reply_to_hdr
(String)
When replying to mail,
.I Mush
searches for return paths from the message by searching for
the message headings \*QReply-to\*U, \*QReturn-path\*U, and \*QFrom:\*U,
in that order.
If none are found, then the first line of the
message created by the delivery system is parsed and the address
given there is used.  This special message header is created by most
mail delivery programs, but not all of them (MMDF, for one).  This line
is called the
.B From_
header because it is a colon-less header, but contains the return address
of the author of the message.
If the variable
.B reply_to_hdr
is set to a list of headers (delimited by spaces or commas), then that list
is searched.  If none of the headers listed in the variable exist
in the message, then a warning message is printed and the default
headers are used.  The special case From_ header can be specified
as one of the headers to search for.
.sp
.nf
.ti +2
set reply_to_hdr = "sender reply-to return-path from_"
.fi
.sp
This example shows that 
.I Mush
will search for (in order), the headers listed in the reply_to_hdr variable.
If one header isn't found, then
.I Mush
looks for the next in the list.
If none of the headers in the list are found, the default headers (mentioned
above) are searched.
The last header listed in the example is the special \*QFrom \*U header.
Also see the
.B reply
command.
.TP
.B save_empty
(Boolean)
Normally, when all messages in a folder are deleted and the user updates
the folder or changes to a new folder, the empty folder is deleted.
.B save_empty
prevents the folder from being deleted and it is left zero length.
Note: the main system mailbox is never deleted, even when empty.
.TP
.B screen
(Numeric)
May be set to the number of message headers to display at a time in the
line and curses modes.
.TP
.B screen_win
(Numeric)
May be set to the number of message headers to display in the tool mode.
A subwindow is created for message headers, and its size is large
enough to hold $screen_win headers.
.TP
.B sendmail
(String)
If set, the program and arguments described by this variable will
be executed to actually deliver mail sent by
.I Mush.
.TP
.B show_deleted
(Boolean)
If true, deleted message headers are displayed along with
other messages (`*' indicates a deleted message) for the \fBheaders\fR
command.  Also, deleted messages can be displayed using any command which
displays a message.
In curses mode, this variable is ignored and deleted messages are always
displayed with other messages to facilitate undeleting messages.
.TP
.B show_hdrs
(Multivalued)
Set to a list (space and/or comma separated) of headers that are to be the
only headers displayed when viewing a message.
This variable disables the headers suppressed by the
.B ignore
command.
For example,
.sp
.ti +2
set show_hdrs = \*Qfrom date subject to cc\*U
.sp
will only display the headers
.B From: Date: Subject: To: Cc:
in their entirety.
.TP
.B sort
(Boolean/string)
The value of this variable is the same as the arguments to the
.B sort
command.
This variable is used for the initialization file to presort
mail in the system mailbox upon entering
.IR Mush .
See the COMMANDS section for more information.
.TP
.B squeeze
(Boolean)
Whenever messages are read, piped, or saved, if this variable is set,
all consecutive blank lines are squeezed into one blank line.
.TP
.B status
(Read-only numeric)
This variable records the success or failure status of the most recently
executed command.
All line-mode commands return 0 (zero) for success and a negative value for
error.
Some curses mode commands return an error status to indicate that the
display has been corrupted, even when no actual error has occurred.
This variable is most useful in scripts to test the success of an operation
before proceeding.
.TP
.B tmpdir
(String)
This variable describes the path to use as the directory
for all tempfiles that
.I Mush
uses.  By default, the user's home directory is used.  If that
cannot be accessed, a directory writable by all is used (typically, /tmp).
If \fBtmpdir\fR is set, then it is used first.
.TP
.B thisfolder
(Read-only string)
The full path name of the current mailbox.
This variable cannot be modified or displayed by the
.B set
command; its value changes whenever a new folder is entered with the
.B folder
command.
During sourcing of the initialization files,
.B thisfolder
is not set, because the current folder has not yet been read.
If you refer to \*Q$thisfolder\*U in an initialization file
.RI ( e.g. ,
.IR .mushrc ),
be sure to do so inside an \*Qif $?thisfolder\*U test.
.TP
.B toplines
(Numeric)
The number of lines of a message to print when the
.B top
command is issued.  If unset, $crt lines are printed.
Note that the message body only is printed when using the
.B top
command; message headers are not counted as lines since they are not displayed.
.TP
.B unix
(Boolean)
If set, commands that are not
.I Mush
commands are considered to be
.IR UNIX (TM)
commands.
This removes the inconvenience of requiring the user to do
shell escapes to do quick
.I UNIX
commands.
For systems that support job control, SIGTSTP will stop the entire shell as
well as the process being executed.
When SIGCONT is delivered, both will receive the
signal and the shell will continue to wait for the job to finish.
.sp
Due to the lack of real job control, input/output redirection and UNIX command
piping, this mode of the shell is not intended to be used as a login shell.
.sp
If a
.I Mush
command conflicts with a
.I UNIX
command, use the command
.B sh
to force execution as a shell command or use the full pathname of the command
(e.g. starting with a '/').
.sp
.BR Warning :
.I "Be aware that Mush pipes transmit message lists, NOT TEXT."
You cannot pipe the output of
.I UNIX
commands to or from
.I Mush
commands or other
.I UNIX
commands with the
.I Mush
pipe mechanism.  You can, however, pipe
.I Mush
commands to a final UNIX
command (see the \fBpipe\fR command for more information).
UNIX commands should be simple commands without pipes or metacharacters.
.sp
This feature is not available for the tool mode.
.TP
.B verbose
(Boolean)
Passes verbose flag to mail delivery systems when sending mail, and
causes
.I Mush
to print additional information about the sending process.
.TP
.B verify
(Boolean)
When through editing messages, just before sending,
.B verify
will ask you if you want to send, continue editing, or abort the
whole message altogether.
.TP
.B version
(Read-only String)
The value of this variable is the version string, printed by
.I Mush
at startup (unless
.B quiet
is set) and included in the \*QX-Mailer:\*U header in messages.
.TP
.B visual
(String)
May be set to the visual editor to use when ~v is specified.
Default is vi or the environment string VISUAL.
The visual editor is invoked by the \-e arguments to the
commands, 
