.B respond
and
.BR mail .
.TP
.B warning
(Boolean)
If set, warning messages are printed when:
.in +4
.ti -2
\(bu A command line alias (\*Qcmd\*U) looks like a command.
.br
For example,
.ti +2
cmd mail 'set fortune; \\mail'
.ti +2
cmd respond 'unset fortune; \\respond;'
.ti -2
\(bu The date format of a message is unknown.
.br
The date of a message is taken from the \*QDate:\*U header.
If the date on that header is unknown, other headers are searched for a
valid date format until a legal one is found.
This date may not be
correct in that it was the date the message was received, not sent.
.ti -2
\(bu A variable is unset without first being set.
.br
For example, if you give the command
.ti +2
unset metoo
and the variable
.B metoo
is not set, you will be notified that the variable is not defined.
.ti -2
\(bu No header can be found for a digest article.
.br
This occurs when the
.B undigest
command encounters what appears to be an article separator but cannot
find a \*QFrom:\*U or \*QDate:\*U header in the following text.
.in -4
.sp
The intent is so that users who are used to their own environments
will be aware of changes in other environments should they be forced
to use them.
There may also be warning messages of failed routines
or assertions that are not fatal enough to interrupt normal running
of the program.
.TP
.B wrap
(Boolean)
Normally, when the last message is deleted, the current message
pointer remains pointing to the last message and the user is done
reviewing his mail.
If the
.B wrap
variable is set, the current message pointer will wrap around to the
beginning of the user's messages again to the next undeleted message.
This also applies to the
.B next
command.
.TP
.B wrapcolumn
(Numeric)
May be set to a column number at which line wrap will occur when
composing messages.
If set, but given no value, column 78 will be assumed.
When
.I Mush
is able to determine the number of columns on your screen, it will
enforce a maximum value for
.B wrapcolumn
of two less than that number of columns.
Line wrapping can be disabled either by unsetting
.B wrapcolumn
or by setting it with the explicit value of 0 (zero).
.sp
Line wrapping occurs only at whitespace (spaces or tabs).
Lines containing no whitespace to the left of the specified column
will not be wrapped.
If \fIMush\fR was started with the \-e (echo mode) option, or is in tool mode,
line wrapping cannot be done due to I/O incompatibilities.
.PP
In addition to the named variables described above, three special
variable forms are recognized.
.TP
.B $$
This string returns the process id (PID) of the current
.I mush
process.
Colon modifiers are not recognized for this special variable.
.TP
.BI $[ %fmt ]
The string \fI%fmt\fR is interpreted as a header formatting string
(as in the
.B hdr_format
variable) and is expanded using the headers from the current message.
Colon modifiers are allowed to follow the format.
For example,
.sp
.ti +4
save $[%4n]:l
.sp
will save the current message in a file whose name is the first four
characters of the name of the author, converted to lower case.
.TP
.BI $( %c )
The string `\fI%c\fR' is interpreted as a prompt format
(as in the
.B prompt
variable) and is expanded.
Colon modifiers are allowed.
For example,
.sp
.ti +4
echo $(%T)
.sp
will print the current time.
Note that \*Q$(%F)\*U is equivalent to \*Q$thisfolder\*U.
.PP
NOTE:  Evaluation of many \*Q$[%...]\*U or \*Q$(%...)\*U values in a single
command is inefficient.
If expansion of several formats is desired, it is better to use the \-h
and \-p options of
.B echo
or
.BR eval ,
which also provide better quoting of the interpolated strings.
.SH "MUSH SCRIPTS"
One of the most useful features of
.I Mush
is the ability to write scripts of
commands, which can be read by the
.B source
command from within
.IR Mush ,
or by redirecting input from the script and using the \-i option.
If your operating system supports the \*Q#!\*U interpreter mechanism,
a script can be even be executed as a program.
Script files can use all the usual
.I Mush
commands; the only restriction is
that the `!' history notation for referencing arguments of
.B cmd
aliases is disabled in scripts, so only very simple
.BR cmd s
will work.
.PP
For example, a filtering file, \*Qfilter\*U, might contain:
.sp
.nf
.in +2
set newfolder = /usr/spool/mail/$USER
if is_shell
.in +4
if -z $newfolder
.ti +4
set newfolder = $mbox	# mbox must be set!
endif
if -e $newfolder
.ti +4
folder $newfolder
else
.ti +4
quit
endif
.in -4
endif
.sp
pick -f Mailer-Daemon | save mail_errors
pick -f yukko | delete
pick -s -i thesis | save +thesis_mail
pick -t unix-wizards | +wizmail
update
sort d
.in -2
.fi
.sp
Then the first command the user types when beginning a
.I Mush
session might be \*Qsource filter\*U, and the following would happen:
.sp
.in +2
First, a new variable called \fBnewfolder\fR is set to the the user's spool
mailbox (the system mailbox).
A test is made to see if the shell is running, because the \fBfolder\fR
command can only be used from the shell.
Then a test is done to see the spool mailbox is zero length, and if it is,
the variable is reset to the value of the user's \fBmbox\fR variable
(mbox must already be set by this time or this will fail).
A final test assures that the new folder exists.
If it does, \fIMush\fR changes folders to the new folder.
If it doesn't exist, the program exits (via \fBquit\fR).
.sp
Once the correct folder has been loaded, all messages that have
\*QMailer-Daemon\*U in the From header will be saved in the file mail_errors.
Then, all mail from the user \*Qyukko\*U will simply be deleted.
Next, all mail that has in the Subject field, \*Qthesis\*U
(case ignored, so \*QThesis\*U would also match) will be
saved in the file $folder/thesis.
The next command will find all messages that are addressed to
the group \*Qunix-wizards\*U (of which the user is an elite
member) and save them in the file $folder/wizmail.
Last, the folder will be updated, removing all deleted mail
(saved mail may be marked as deleted)
and the folder is reread and sorted according to the date of the messages.
.in -2
.PP
If the \*Q#!\*U mechanism is supported, the \*Qfilter\*U script can be
made into a program by adding as the first line:
.sp
.ti +4
#! /usr/local/bin/mush -F
.sp
(The actual location of
.I mush
may vary from system to system; /usr/local/bin is used as an example.)  Then
make the file executable:
.sp
.ti +4
chmod +x filter
.sp
Now, when the command \*Qfilter\*U is typed at the user's regular shell
prompt, the
.I mush 
program will be invoked by the operating system.
.I Mush
will first read the commands from the \*Qfilter\*U file and perform them,
exactly as described above, and then will continue into the usual interface.
If it would be preferable for
.I mush
to exit after reading the script, the first line can be changed to:
.sp
.ti +4
#! /usr/local/bin/mush -F!
.sp
The \-F! option should also be used when running
scripts in the background or in other circumstances where the standard
input cannot be a terminal, and the only commands to be executed are those
in the script itself.
.PP
Note that any additional arguments passed to a \*Q#!\*U script are
interpreted by
.IR mush ;
they are not passed along in any way that makes them accessible to the script.
Thus,
.sp
.ti +4
% filter \-f mbox
.sp
would apply the commands in the \*Qfilter\*U script to the \*Qmbox\*U folder.
.SH MACROS
Macros are available in several different modes in
.IR Mush .
.I "Curses mode macros"
are created by using the
.B bind
command with the special function
.B macro
(or by using
.BR bind-macro ,
which is synonymous).
These macros are effective only when the curses interface is active.
.I "Line mode macros"
are created with the
.B map
command, and are effective only in the line-oriented command interface.
Finally,
.I "composition mode macros"
are created with the
.B map!
command, and are effective only when composing mail messages.
Macros are not available in the
.I tool
mode, nor when composing messages from the tool mode.
Line and composition mode macros are also nonfunctional when
.I Mush
is started with the \-e (echo) option.
.PP
In general, macros consist of two parts:  a
.I "key sequence"
and an
.IR expansion .
The
.B "key sequence"
is the character or string of characters which, when typed in the
appropriate mode, is recognized by
.I Mush
as a reference to a macro.
The
.B expansion
part of a macro is the string that will actually be \*Qseen\*U by
.I Mush
when the key sequence is recognized.
Macros are like an interactive search-and-replace function;
if a key sequence appears in the input, the associated expansion is
substituted in its place.
Thus, if you create a macro whose key sequence is \*Q^X^W\*U (control-X
control-W) and whose expansion is \*Qsave\*U, then when you hold down the
control key and type the two characters `x' and `w', the effect will be
as if you had actually typed the four characters `s', `a', `v' and `e'.
This is called \*Qexpanding\*U the macro.
More detailed examples of macros will be presented in the subsections
for each mode in which macros can be used.
.PP
Key sequences are usually made up of control characters or special
strings of characters generated by \*Qfunction keys,\*U
but may in fact be almost any string the user desires.
Keys that generate a signal or an end-of-file from the keyboard
(for example, on BSD systems, control-Z generates a TSTP signal and
control-D generates an end-of-file) can never appear
in key sequences, and macros in line or composition modes cannot
.I begin
with a newline, control-D, or any of the editing keys
(erase, word-erase, line-erase, etc.).
Otherwise, there are no restrictions.
It should be kept in mind, however, that for the line and composition
modes, key sequences should be unusual characters or combinations of
characters, not individual lower-case letters.
If common characters or strings are used for key sequences, much
confusion can result when typing commands or messages.
This is not important in the curses mode.
.PP
In the line and composition modes, a
.I timeout
is used for key recognition; that is, once the first character of the
key sequence has been typed, the succeeding characters must be typed
after it relatively quickly, or
.I Mush
will fail to recognize them as a continuous sequence.
It is for this reason that key sequences are usually either very short,
or are strings that are automatically generated by pressing a special
key on the terminal.
On the other hand, the timeout can be used intentionally to prevent a
macro from being expanded; simply type the first character of the macro,
then wait for it to echo before typing the next.
This does not work in curses mode, because curses macros
never \*Qtime out.\*U
.PP
In any mode, macros are
.IR recursive ;
that is, if the
.I "key sequence"
of one macro appears in the
.I expansion
of another macro (or even of the same macro), the second key sequence
will be recognized when the first macro is expanded, and this new key
sequence will also be expanded.
Great care should be taken when creating macros to be certain that
recursive expansions do not happen unintentionally.
Expansion can be prevented in line or composition modes by using a
.I literal-next
character.
.PP
Literal-next characters may be used from the keyboard or embedded
in expansions.
In either case, they prevent the next character
from being interpreted as part of a key sequence.
.I Mush
recognizes the literal-next character from the tty settings of the
terminal, if the \*Qnew\*U BSD-style device driver is available;
otherwise, `^V' (control-V) is recognized as a literal-next.
Note that, if you have a tty literal-next character,
then when typing you will need to type
.I two
of them in order to send one to \fIMush\fR; this is because the tty
driver consumes the first one.
It is not necessary to use two literal-nexts in macro expansions
unless you wish to cause the second literal-next to be literal.
.PP
Backslash can be used as a literal-next when typing, and can
sometimes be used as a literal-next in expansions; but use it
with caution, because it also introduces escape sequences
(see \*QMacro syntax,\*U below).
There is no literal-next mechanism for curses mode.
.PP
A macro will always abort whenever
.I any
command called by the macro returns an error.
This includes recursive expansions, so no matter how often a macro has
recurred, it will be terminated completely.
Errors in curses mode include illegal cursor movements, such as up from
the top of the screen or down from the last message.
.PP
.BR "Macro syntax" .
.PP
A special syntax is provided for specifying control characters and other
non-printing characters in macro key sequences and expansions.
This syntax is the same as that for bindings, discussed in the
CURSES INTERFACE section; it can be summarized as:
.ta 1.25i
.in +2
.nf
\\CX	control-X (where X is any capital letter)
\\E	the escape character
\\n	a newline (other C-style escapes also work)
.fi
.in -2
.sp
Thus, to create a line mode macro for control-X control-W, as in the
example above, the command would be
.sp
.ti +4
map '\\CX\\CW' save
.PP
Also provided is a syntax for executing functions from within macros.
There are two special functions that are effective in all modes;
these are
.I getstr
and
.IR getline .
Both of these functions interrupt expansion of the current macro,
and wait for a newline-terminated string to be entered from the
standard input.
This input string is inserted into the macro expansion.
The functions differ in that
.B getline
retains the newline character (carriage-return) at the end of the
input string, whereas
.B getstr
strips off the newline (one must still be typed to terminate input).
These functions can be executed by surrounding their name with
square brackets
.RB ( [ ,
.BR ] );
for example,
.sp
.ti +4
map '\\CX\\CW' save [getline]
.sp
creates a line mode macro, which is expanded when control-X control-W is
typed, and which displays \*Qsave\*U followed by a space and then waits
for the user to type a line of input; the input line will be used as the
arguments to the save command.
.PP
Additional functions are currently available only in the curses mode.
However, the syntax of enclosing the function name in square brackets
applies to all functions, regardless of mode.
Note that
.I ONLY
the function name can appear in the brackets; no whitespace is allowed.
.PP
.BR "Curses mode macros" .
.PP
Macros in curses mode are the most versatile, because they can access the
full range of curses commands quickly and easily.
Every character that appears in the expansion part of a curses mode macro
can reference a curses command or another macro.
Like other curses functions, curses mode macros are created with the
.B bind
command.
For example, to sort your messages by date and then send the most recent
one to the printer, you could use
.sp
.ti +4
bind @ macro 'od$|'
.sp
When the `@' key is typed, this macro first invokes sort
(`o' from the default bindings) and instructs it to use date (d)
for sorting; it then moves the current-message pointer to the last
message ($) and prints that message (|).
.PP
Admittedly, the above macro is somewhat cryptic, and is dependent upon
the bindings for sort, last-msg, and lpr being set to the defaults.
It would be better, and possibly more understandable, to refer to the
desired curses functions without using their key bindings.
To allow this, the \*Q[function]\*U syntax described above may be used
in curses mode macros to reference curses functions.
The only function that is prohibited from appearing in the \*Q[\|]\*U
is the special
.I macro
function, which cannot be called when it has no binding.
The example macro can therefore be rewritten as
.sp
.ti +4
bind @ macro [sort]d[last-msg][lpr]
.sp
Such references to curses functions may be made only in curses mode
macros, and are effective only when \fIMush\fR is actually in curses mode.
That may sound strange, but the most common use of curses macros is
to quickly perform functions that require an escape to the line mode.
For example, although there is a variation of the curses mode
.I mail
function that will prompt for additional flags, there is no function
to prompt for flags to be passed to
.IR reply .
A macro can easily be created to provide this:
.sp
.ti +4
bind R macro '[line-mode]reply '
.sp
This macro binds `R' to perform an escape to line mode and type
the string \*Qreply\*U followed by a space.
Macro expansion then ends, leaving it up to the user to supply
flags to the command or to backspace over it if a different command
(or none) is desired.
Of course, the macro could also have provided some default arguments:
.sp
.ti +4
bind R macro '[line-mode]reply \-ei '
.PP
Note that, if the
.B getline
or
.B getstr
function is used in a line-mode escape, it is not possible to
erase the text that is typed before the
.IR get ;
that is, if the macro had been
.sp
.ti +4
bind R macro '[line-mode]reply \-ei [getline]'
.sp
then the user would be forced to use the \-ei flags.
.PP
.BR "Line mode macros" .
.PP
Line mode macros combine some of the convenience of single-keystroke
commands with the versatility of the line-oriented text interface.
As has been noted, the choice of characters for line mode key sequences
should be made carefully, so as not to interfere with normal typing.
Line mode macros are created with the
.B map
command; for example, suppose you frequently forward messages to a
friend named \*Qfred.\*U  You could create a macro to do this:
.sp
.ti +4
map '\\CF' 'mail \-f . fred\\n'
.sp
This macro causes the single keystroke `^F' (control-F) to forward
the current message to \*Qfred.\*U  Note the newline
character \*Q\\n\*U at the end of the expansion;
this causes the command to be executed immediately,
without you having to type a carriage-return.
.PP
The expansion part of a line mode macro will echo to the screen when
it is expanded, so you can see what the macro is doing.
You can therefore use parts of the expansion as a \*Qprompt.\*U  In
the above example, suppose you wished to enter a message list rather
than always forwarding the current message.
Change the macro to:
.sp
.ti +4
map '\\CF' 'mail \-f [getstr] fred\\n'
.sp
This version of the macro prints \*Qmail \-f\*U and a space, then waits
for a newline-terminated string from the standard input.
The newline is stripped, and the string is used as the message list
passed to the \*Qmail \-f\*U command.
The address \*Qfred\*U is also passed to
.BR mail ,
so the messages in the list are forwarded to fred.
.PP
If you want to be able to \*Qchange your mind\*U after starting a
line mode macro, you must leave the \*Q\\n\*U out of the expansion.
Without the newline, the macro will not be executed immediately, so
you have a chance erase the line (or part of it) and type
something different.
Remember that the
.B getline
function keeps the newline in the string it gets, so if you don't
want a newline to appear, you must use
.BR getstr .
When using the
.I get
functions, you should also remember that you can
.I never
backspace past the \*Qbeginning\*U of a
.BR getline ,
and you can backspace past the beginning of a
.B getstr
only after the get has been completed.
.PP
When the
.B getstr
function is used in line mode macros,
.I Mush
will reprint the current input line so you can see what the whole
thing looks like, but will not redisplay the line mode prompt
(see the entry for
.B prompt
in the VARIABLES section for information on what the
prompt looks like).
Don't let this worry you.
The input line is also reprinted when
.B getline
is used, but the newline in the input string usually results in a
new prompt being displayed.
.PP
.IR NOTE :
Line mode macros are not available when using the line-mode escape
function in curses mode.
It is necessary to escape all the way to line mode (that is, leave
curses mode by typing carriage-return at the `:' prompt) in order
to access line mode macros.
This is to prevent possible confusion when similar macros exist
in both line and curses modes.
.PP
.BR "Composition mode macros" .
.PP
Composition mode macros are very similar to line mode macros, and
provide a \*Qpower typing\*U function when composing messages.
For example, you might want to have the word \*Qpercent\*U inserted
into your message whenever you hit the `%' key:
.sp
.ti +4
map! % percent
.sp
Another use is to simulate the indentation features of editors.
For example, you might
.sp
.ti +4
map! '\\CT' '\ \ \ \ '
.sp
(where the expansion is four spaces, enclosed in single quotes).
This macro causes four spaces to be inserted into the message whenever
control-T is typed.
.PP
Composition mode macros can also be used to execute
.I tilde-escapes
(see the GENERAL USAGE section for a list of these).
For example, you could create a macro to invoke the editor:
.sp
.ti +4
map! '\\CE' '\\n~v\\n'
.sp
When control-E is typed, this macro prints a newline (to be sure that
the tilde-escape is the first thing on a line), then types \*Q~v\*U
followed by another newline, to start the editor.
Similar macros can be created for other tilde-escapes.
.PP
.BR "Mixed mode macros" .
.PP
It is not normally possible to mix macros among the different modes.
However, once expansion has begun, it is interrupted only by an error
or by the appearance of one of the special
.I get
functions.
It is therefore possible to have a macro expansion which causes
the mode to change before the expansion has completed.
In this case, recursive expansions will apply to the new mode.
Suppose we are using a variation of the editor-starting macro shown
above for composition mode:
.sp
.ti +4
map! '\\CE' '\\n~v emacs\\n'
.sp
This macro causes the \*Qemacs\*U editor to be started when control-E
is typed in composition mode.
We can now create a line mode macro that makes use of this
composition mode macro:
.sp
.ti +4
map '#' 'reply \-i [getline]~t[getline]\\CE'
.sp
When the `#' key is pressed in line mode, this macro will
print \*Qreply \-i\*U and wait for a message list, then enter
composition mode (by executing the
.B reply
command).
In composition mode, it will display the To: line
(the \*Q~t\*U escape) and wait for other addresses to be added.
Finally, it will recursively expand the control-E macro, to
start editing the message with emacs.
.PP
As can be seen from this example, the
.I Mush
macro facility is very powerful.
Be very careful not to accidentally expand recursive macros,
especially when using macros that change modes.
When testing new macros, it is a good idea to start
.I Mush
in
.I read-only
mode (the \-r command line flag) to be sure that messages are
not lost or altered.
.PP
.BR "Getting rid of macros" .
.PP
It is not necessary to delete a macro in order to redefine it.
New expansions for existing key sequences will automatically replace
the old expansions.
If it is necessary to remove a macro completely, the commands
.BR unbind ,
.B unmap
and
.B unmap!
can be used to remove curses mode, line mode, and composition mode
macros, respectively.
Remember to use a backslash or other literal-next character to prevent
the expansion of line mode macros when using these commands, especially
.BR unmap .
.SH "MAIL ADDRESSES"
Whenever a command that requires a user address or set of addresses
is specified
.RB ( mail ,
.BR reply ,
.BR alias ,
.BR etc )
the addresses given must be separated by commas.
Most casual users specify addresses that contain no comments or whitespace.
The simplest addresses are just the login names of the users you wish to send
your message to:
.sp
.ti +2
\fBmail\fR fred barney wilma betty
.sp
In these cases,
.I Mush
can figure out that they are separate addresses and
insert commas between addresses automatically.
.sp
.ti +2
To: fred, barney, wilma, betty
.sp
Addresses may also contain `!', `@' and `%' characters which are used
to separate hostnames and the final user name from each other.
This is primarily used to mail to users on other machines.
UUCP addresses are specified as
.sp
.ti +2
host1!host2!user
.sp
where there may be as many hosts as necessary to route the message
to the recipient user.
Here, the user's account is on \*Qhost2\*U
and that machine is connected to \*Qhost1\*U.
.I Domain
addresses (also called Arpanet, Internet, RFC822, and \*Qfully qualified\*U
addresses) are specified as
.sp
.ti +2
user@host.domain
.ti +2
user%host2.domain@host1
.sp
where \*Qdomain\*U is a domain name such as \*Q.berkeley.edu\*U or \*Q.com\*U.
As in the first example, the user is on \*Qhost2\*U, but that machine talks
to \*Qhost1\*U.
It is beyond the scope of this document to discuss in detail the ramifications
of inter-network mailing.
More information can be obtained through your system manager.
.PP
.I Mush
understands addresses containing a comment field.
Comment fields do not affect the destination address of mail being sent.
These fields are purely for
human legibility and may be specified according to the following constraints: 
.sp
Anything within angle brackets is an address; whatever is outside of the
address is considered a comment:
.sp
.ti +2
Dan Heller <zipcode!argv@cad.berkeley.edu>
.ti +2
Dan Heller <argv@zipcode.com>
.sp
Anything that has parentheses is a comment; whatever is outside of the
parentheses is considered the address:
.sp
.ti +2
zipcode!argv (Dan Heller)
.ti +2
argv@zipcode.com (Dan Heller)
.sp
Double quotes (") are treated just like parentheses:
.sp
.ti +2
"Dan Heller" zipcode!argv
.ti +2
"Dan Heller" argv@zipcode.com
.sp
If the comment is to contain a comma, the first case above may not be used;
you must use either the parenthesis or double-quote cases.
.sp
.ti +2
fred@flintstone.bed.rock (Fred Flintstone, Cave Man)
.sp
If the comment contains unbalanced quotes, unpredictable results may occur
.RI ( Mush
won't deliver the mail).
.sp
Since the angle brackets have the highest precedence, quotes or parentheses
may be used in conjunction with one another.
.sp
.ti +2
Yabba Dabba Doo (Fred Flintstone) <fred>
.ti +2
Scoobie "Doobie" Doo <scooby@shaggys.mystery.machine>
.PP
Multiple addresses may appear on a line:
.sp
.in +2
argv@zipcode.com argv@garp.mit.edu dheller
.in -2
.sp
Because there is no indication of comments (parenthesis, angle bracket,
or quotes), it is assumed that these are separate addresses and
.I Mush
will insert commas between these addresses accordingly.
It is for this reason that the user is encouraged to explicitly insert
commas between all mail addresses and not depend on the automation of comma
insertion to correctly separate addresses from one another.
.PP
Mail aliases may contain addresses of the form described above.
.sp
.nf
.in +2
.ta 1.5i
alias george	George Jetson <george@spacely.space.sprockets>
alias jane	Jane Jetson <jane@sky-high.appts>
alias group	george, jane
.in -2
.fi
.sp
You can mail using the alias as an address and it will be expanded
accordingly.
You cannot, however, reference an alias and specify a
comment or another address at the same time.
.sp
.ti +2
To: The Jetsons <group>
.sp
The alias \*Qgroup\*U will not be expanded because the angle brackets
causes it to be considered as another address entirely.
.SH FILES
.nf
.ta 2.0i
/usr/spool/mail/*	Directory for incoming mail
~/Mail	Default \fBfolder\fR directory
~/mbox	File where old mail is saved
~/.mushrc	File giving initial \fIMush\fR commands
~/.mailrc	Alternate initialization file
~/.edXXXXXXX	Temporary for file for outgoing messages
~/.mushXXXXXX	Temporary mail file (copy of current folder)
.fi
.PP
Temporary files that are created by the program are always
created with read/write access to the owner only; group and other
permissions are never set.
This is also true for the /usr/spool/mail/* files.
All other files created by the user via commands internal or external
to the program have permissions set by the user's default umask.
If the umask is reset within the program, the mask remains
intact even after exiting.
Remember to set the variable
.B unix
before attempting to set the umask value.
.PP
If your system is using Sun Microsystem's NFS, take special note to
read the manual page for mount(1).
Filesystems mounted for read/write
access should be mounted as \*Qhard\*U NFS mounts or you may lose
mailboxes during a timeout during a write or update.
.PP
Filesystems that use RFS still have bugs to be ironed out in the way
of owners and permissions concerning utime(2).
.SH "SEE ALSO"
.IR Mail (1),
.IR binmail (1),
.IR csh (1),
.IR aliases (5),
.IR mount (1),
.IR mailaddr (7),
.IR sendmail (8),
.IR printf (3),
.IR execl (3),
.IR umask (1),
.IR utime (2).
.SH AUTHOR
The original
.I Mush
was written entirely by Dan Heller.
Code to support macros, line wrapping, and a whole lot of other miscellaneous
details, was written by Bart Schaefer, who gets his name in print
because he updated and proofread this manual.
Numerous others have supplied valuable suggestions
and assorted bits and pieces.
.PP
argv@sun.com       zipcode!argv
.SH DISCLAIMERS
.I Mush
contains no
.IR UNIX (TM)
sources and never has.
It is also not a modified version of any other mail user agent.
Similarities
with any other mailer may have been designed for compatibility reasons.
.PP
.I UNIX
is a trademark of AT&T.
.PP
The Flintstones and The Jetsons are trademarks of Hannah-Barbara Inc.
.SH BUGS
The curses interface uses the curses library.
The routines from the library that are used are the most basic and simple
so as to avoid possible bugginess that
different versions of UNIX might have.
However, one unavoidable problem is the reverse video mode.
Depending on your terminal,
the termcap entry for it, and the version of curses you are running,
the reverse video may make things worse than desired.
In such situations, the user should set the variable
.B no_reverse
to not get reverse video.
\&`^R' may still be entered at runtime in the curses
interface to toggle reverse video.
.PP
Toggling from the curses mode to the line mode to get the full
functionality of the shell/line mode is unfortunately necessary
in order to maintain the display in a sensible manner and to keep the
keystroke-command interface simple and \*Quser friendly\*U.
Mostly, such escapes are only necessary
for piping of commands and using the pick command.
Macros are a big help with this.
.PP
If the program is already running and the system [later] has to swap
and there is no swap space left, there may be problems.
One such problem is sending mail.
If this happens, then sending mail
will fail and a segmentation fault from the spawned/forked child may occur
(unless the -v flag was given to mail).
The unsent letter will not be removed from the editing file ($home/.edXXXXXX)
and may be recovered.
.PP
Many functions available to the line oriented mode (shell mode)
are not available to the tool mode.
For example,
.B pick
may not be directly accessed although experienced users may find that
typing pick commands within single backquotes in the \*QRange:\*U panel item
above the header window and then selecting a command that uses the the range
will indeed pick messages.
This is mostly for selecting the \*Qdelete range\*U item
or the middle mouse button icon in the header panel.
.PP
Version 6.5.6 was the last version designed to run under SunWindows, and is
therefore the most recent version that will function under SunOS 2.x.
The current version, 7.0, has been ported to SunView, and may have
a completely new set of problems in addition to those described below.
Also, some of those described below may have been eliminated, and remain
in this discussion only for completeness.
.PP
Shell escapes (of any kind) may be called only from the \*Qpipe\*U command
in the tool mode, should not be interactive, and should produce
output only to a file.
The reason for this is that there is no tty
.I window
in which to do input/output.
Since the interactive function-key binding interface has gone away, it is
unfortunately only possible to execute commands that have been pre-defined
in the initialization file.
Future revisions may correct these deficiencies.
.PP
The function keys and their ability to
.I work
has been variable depending on the version of SunWindows/SunView
your Sun Workstation has.  From time to time, it works, but when it
doesn't, it seems to be related to other user or system definable
dot-files or whatever.
This of course means that the function keys are relatively untested
in conjunction with SunView (SunOS later than 3.3).
The default function key bindings have been eliminated
to avoid collisions with SunView window system functions.
.PP
Changing the value of the
.BR screen_win ,
.BR crt_win ,
or
.B msg_win
variables after the tool is running simply has no effect.
.PP
When using
.B vi
in the tool mode, the window is periodically one
line \*Qshort.\*U
That is, scrolling is off by one line and you have
to redraw the window (using \*Qz.\*U in vi) to get it in sync again.
This problem remains in most SunView implementations, but does not
seem to appear with the current default composition window size.
.PP
When running on full filesystems,
.I Mush
may complain or not even run since it needs temporary space with which
to work.
Instead of finding new filesystems on its own,
.I Mush
leaves this task up to the user.
The workaround is to set the variable
.B tmpdir
in the initialization file to be a writable place in a filesystem that
has enough disk space.
.PP
Most of the other known and documented bugs
are in the supplied README files accompanying the source.
The source is also an excellent place to look as many known bugs are
documented in comments.
A good way to track suspicious bugs is to use the
.B debug
command, but note that
this command is very difficult to use in curses mode.
