binding control character sequences in the initialization file.
This format
is also used to display the current key-command mappings by the program.
.PP
To specify control characters in ASCII format for the bind command, the
sequence \*Q\\Cc\*U is used where `c' is the
character that the control key will translate to and must be in upper case.
The sequence \*Q\\CP\*U would map to control-P.
If the user wishes to indicate the RETURN key, this is specified
with the string \*Q\\n\*U and
the tab key is specified by the string \*Q\\t\*U.
As a more complex example, on a Wyse-50 terminal, the 8th function key
outputs the three characters: control-A, H, line-feed.
To map this function key to a command, the
user would have to enter the sequence \*Q\\CAH\\n\*U as the key sequence,
then follow up with a valid curses command.  From then on, if the user
presses that function key,
the command mapped to it will be executed.
.PP
The ESCAPE key is signified by the sequence, \*Q\\E\*U.
On a Sun-3 workstation,
the R1 key outputs the character sequence: ESC, [, 2, 0, 8, z.
The corresponding
.B bind
key sequence would be \*Q\\E[208z\*U.
Restrictions are that key sequences may not contain the space character
unless bound in line mode, and can never begin with a digit.
.PP
Whenever a command is entered, other than `^L'
.RB ( redraw ),
which causes the screen to scroll or be refreshed in any way,
.I Mush
is left in the
.I continue
mode.
When in this mode, the user is given his line-mode prompt followed
by \*Q...continue...\*U indicating that he may issue a new command or
return to the top level where the current message headers are displayed
on the screen.
Remember that this is still the curses mode, but much time
is saved by avoiding redrawing the screen after each command.
The user may move up and down messages using the appropriate commands
(j/k by default) or anything else the curses mode allows.
Only the exit and quit commands will return to the top level.
Because of this, there are 2 additional
ways to \*Qquit\*U from curses mode and return to the login shell.
The \*Qexit\*U and \*Qquit\*U commands will quit from the top level, but
the commands
.B exit!
and 
.B quit!
are used to exit from the \*Qcontinue\*U level in the curses interface as well
as from the top level.
.PP
Note that the best way to understand the curses interface is to just use it.
In line mode, the command \*Qcurses\*U puts you into curses mode.
.SH "GRAPHICS TOOL INTERFACE"
When running the window-based tool interface, there will be five
subwindows:
a panel for folder-related commands and general options,
a scrollable display of message header summaries,
another panel of message manipulation commands,
a four-line scrollable window for warnings and output from certain commands,
and a larger window which is used for displaying messages.
The message display and command output windows can be scrolled with
the up and down cursor keys (function keys R8 and R14 by default),
and also recognize \*Qvi\*U movements (j, k, ^U, ^D, etc.),
in addition to having scrollbars.
.PP
In the header summary window, pressing the LEFT mouse button while pointing
at a message header displays that message in the large message window at the
bottom of the frame.
Pressing the middle button deletes the message, and pressing the RIGHT mouse
button displays a menu of actions that will affect the message.
Possible actions are to display the message, delete or undelete it, reply to
it, save it, preserve it
(see the
.B preserve
command), or print it (hardcopy).
.PP
All panel items in the frame have labels describing their functionality.
Selecting
a panel item with the LEFT mouse button causes the action to be executed.
The RIGHT mouse button displays a menu of options that the command may
branch to.
For example, the
.B Save
panel item by default will save messages to the file \*Qmbox\*U, but the
RIGHT mouse button causes a menu to be displayed, and the choices of
where to save the message increase to include the items in the menu.
These typically include the files in the user's folder directory (see the
.B folder
variable below).
.PP
At the end of most lists of menu entries for panel items is an item
labelled \*Qhelp\*U.
When this item is chosen, an new window is opened where help for that
command is displayed.
The help windows can be scrolled in the same ways as the message
display window.
.I "Note:  The limited number of file descriptors in SunOS 3.5 forces"
Mush
.I "to display help information in the"
.IR "message window in the main frame" .
.\" Some nroffs can't handle long .IR arguments
.PP
When composing letters,
a separate frame is created which includes a panel of command items,
a four-line scrollable window,
and a large window for editing the letter.
Panel items for including messages, editing (via your usual text editor),
sending, aborting the message, and various other manipulations are supplied.
See the section on \*QSending mail\*U, under the summary of tilde escapes,
for more details of composition frame command items.
As long as the composition frame is open, all
.I Mush
command output is
redirected from the small window in the main frame to the small window here.
\fINote:  This subwindow is not present in SunOS 3.5 due
to the limited number of file descriptors; command output stays in the
main frame in that case\fR.
The SunView
.I textsw
interface is used by default in the large window for paging and editing.
Cursor movement with the function keys (R8, R10, R12, and R14 by default)
is supported.
.SH COMMANDS
Described below are legal commands understood by
.I Mush
that you can type at the line mode prompt.
Most commands have abbreviations
(given in parentheses) and can be followed by message lists.
In most cases,
whitespace is not necessary to separate commands from message lists.
For example, \*Qd*\*U will delete all messages, and \*Qu1-7 {4}\*U will
undelete messages 1 through 7 except for message number 4.
.B NOTE:
\fIThis \*Qtoken splitting\*U may have unexpected side effects, especially
for \fRUNIX\fI commands whose names contain digits.\fR
.PP
The ability to customize commands using the
.B cmd
facility allows users to customize
.I Mush
to resemble other mailers.
However, efforts have already been made to include commands that are backwards
compatible with other line-mode mailers.
Users of the graphics tool mode of
.I Mush
may have little need for the command line mode because the icon based
interface allows interaction with many commands.
The tool mode is much more restrictive in favor of a simpler, user
friendly interface, but most useful commands may be achieved anyway.
.PP
The following is a list of all recognized commands.
Since most commands accept a
.I "message list"
as an argument, arguments are noted only when they differ from a message list.
.TP
.BR alias " [name] [address-list]"
.ns
.TP
.BR unalias " name"
The
.B alias
command defines a name to stand for a list of addresses.
The defined name can then be substituted for the entire list when
sending mail.
For example,
.sp
.nf
.ti +2
alias dan dheller@cory.berkeley.edu argv@zipcode.com
.fi
.sp
This defines the name \*Qdan\*U to be shorthand for two addresses,
both of which happen to be Dan Heller.
.sp
The command
.B unalias
can be used to remove an alias definition.
.sp
With no arguments,
.B alias
prints out all the current aliases.
With one argument, it prints the list associated with that name,
and with more than one argument, it creates a new alias.
.TP
.BR alternates " [host-list] [!path!login] [*[user]]"
.RB ( alts )
This command
is useful if you have accounts on several machines.
It can be used to inform
.I Mush
that your login name at each of the listed hosts is really you.
When you
.B reply
to messages,
.I Mush
will not send a copy of the message to your login name at any of the
hosts listed on the
.B alternates
list.  If the special symbol \*Q*\*U is used, then your login name is
matched against all pathnames and local addresses.
A user name may be appended to the \*Q*\*U, in which case that name is
matched instead of your login name.
.sp
If you have another login name on the local or remote machine, then
that login may be specified by preceding the login name or the path
to the login name by a `!' character.
.sp
For example,
.sp
.nf
.ti +2
alts zipcode maui1 !cory.berkeley.edu!dheller !root
.fi
.sp
are all either hostnames or pathnames to my other accounts.
The last item, \*Q!root\*U will match root that is only destined for my
workstation.
Root accounts elsewhere are not considered to be me.
.sp
If the
.B alternates
command is given with no arguments, the current set of alternate
names is displayed.
.TP
.BR await " [\-T timeout]"
Directs the shell to wait for the arrival of new mail.
New mail is checked approximately every 30 seconds, or every
.I timeout
seconds as specified by the \-T option.
This command does not return until new mail arrives
or until a keyboard interrupt (^C) is typed.
Unless the string \*Qawait\*U appears in the value of the variable
.BR quiet ,
the terminal bell will ring when
.B await
reads in a new message (see the VARIABLES section for details).
.TP
.BR bind " [string [command [parameters]]]"
.ns
.TP
.BR unbind " string"
.rs
Bind the sequence of keystrokes specified by
.I string
to the curses-mode function,
.IR command .
The
.I string
is usually one or two characters, or a sequence sent by
one of the \*Qfunction keys\*U of a particular terminal.
See the CURSES INTERFACE section for a complete list of curses-mode
functions; this interface is not available on all systems.
The
.I parameters
are currently recognized only for the special
.B macro
function; see the
.B bind-macro
command for details.
.sp
If no arguments are given to
.BR bind ,
the current set of curses bindings are listed;
if only a
.I string
argument is given, the binding for that string is listed;
and if both a
.I string
and a
.I command
are given, a curses binding is created such that when the
.I string
is typed in curses mode, the function specified by
.I command
will be executed.
.sp
Bindings can be removed by using the
.B unbind
command.
.TP
.BR bind-macro " [string [expansion]]"
This command is an abbreviation, which invokes the
.B bind
command with the special function
.B macro
as the second argument.
The effect of binding a curses macro is that whenever the
.I string
is typed in curses mode, the effect is the same as if the
.I expansion
had been typed instead.
A special syntax is provided for including non-printing (control)
characters in both the
.I string
and the
.IR expansion ;
see the CURSES INTERFACE section and the MACROS section for details.
.sp
If no arguments are given,
.B bind-macro
will list the current curses mode macros.
It is otherwise identical to
.in +4
.B bind
.I string
.B macro
.IR expansion .
.in -4
.TP
.B cd
Change the working directory to that specified, if given.
If no directory is given, then changes to the user's home directory.
.TP
.BR cmd " [name [command]]"
.ns
.TP
.BR uncmd " name"
.rs
Command line aliases are set and unset using these commands.
More extensive information is given in the LINE-MODE INTERFACE section.
.B Uncmd
may take `*' as an argument to uncmd everything set.
.TP
.BR curses " [off]"
The
.B curses
command causes
.I Mush
to change from the line-oriented mode to the screen-oriented (curses)
mode, as described above in the CURSES INTERFACE section.
This command may not be given when curses mode is already active.
When used in an initialization file (such as
.IR .mushrc )
this command is the same as giving the \-C (\-curses) switch on the
.B mush
command line.
.sp
The argument
.I off
may be used
.I only
in initialization files, including those read with \-I (\-init),
and has the effect of turning off the \-C switch.
.I Off
is ignored at all other times, even in files read with \-F (\-source).
.TP
.BR debug " [N]"
Set debugging level to N (1 by default).
When in debug mode, the user can see some of the flow of
control the program makes while executing.
The intent of the debug level is for tracking down
bugs with the program at specific locations.
Occasionally, the program may segmentation fault and core dump.
When this happens, the user can reenter the program,
set the debugging level and recreate the problem.
.sp
If the user suspects memory allocation problems, a debugging
level of 5 or higher will prevent memory from being freed so that
memory bounds won't get overwritten.
.sp
If the user suspects Mail Transport Agent errors,
a debugging level of 3 or higher will prevent the MTA from starting
and outgoing mail is directed to the standard output instead of actually
being sent.
.TP
.BR delete / undelete
.RB ( d / u )
Takes a message list as argument and marks them all as deleted.
Deleted messages will not be saved in
.IR mbox ,
nor will they be available for most other commands.
If the folder has not been updated, deleted messages can be recovered
with
.BR undelete .
.TP
.B dt
Deletes the current message and prints the next message.
.TP
.BR echo " [-n] [-h | -p] arguments"
Echoes all the arguments given on the command line, expanding variables
and history references.  If the -n flag is given, then no newline is appended.
If the -h flag is given, then echo looks for formatting parameters
as if the "from" command were given on the "current" message.
If the -p flag is given, then echo looks for formatting parameters
as if your prompt were changed temporarily.
.sp
Examples:
.sp
.nf
.ti +2
echo -h This message is from %a and is dated %d.
.br
might produce:
.ti +2
This message is from zipcode!argv and is dated Dec 14, 1988.
.sp
.ti +2
echo -p There are %n new messages to read in %f.
.br
might produce:
.ti +2
There are 5 new messages to read in /usr/spool/mail/argv.
.fi
.sp
Note that -h and -p cannot be specified together.
.TP
.B edit
.RB ( e ,
.BR v )
This function lets you edit messages in your folder.  When editing messages,
be careful not to remove certain message headers such as Date or From or
any others that looks important.  If you remove or change something you
shouldn't have, you will be notified and the temporary file used to edit
the message will not be removed.
.TP
.BR eval " [\-h | \-p] arg ..."
As in most shells, the list of arguments to
.B eval
is re-parsed and then executed as a command.
This is useful primarily for causing multiple levels of variable expansion.
.sp
If the \-h option is given,
.B eval
will expand header format strings in the argument list before executing the
command.
Similarly, the \-p option will expand prompt format strings in the argument
list before executing.
These formats are expanded \fIlast\fR, after all history and variable
expansion is completed, and are implicitly quoted, so embedded quotes,
spaces, tabs, `!'s, etc. are handled correctly.
Header formats are expanded using the 
.I current
message.
For example,
.sp
.ti +2
eval \-h pick \-f %a
.sp
will find all messages from the same author as the current message.
See the the entries for
.I hdr_format
and
.I prompt
in the VARIABLES section for more details.
.sp
Note that -h and -p cannot be specified together.
.TP
.B exit
.RB ( x )
Returns immediately to the login shell without
modifying the current folder or system spool directory.
.TP
.BR expand " alias-list"
Aliases, given as arguments, are expanded as they would be if you
were to send mail to each.
.TP
.BR flags " [ [ + | \- ] [ D f N O P p R r S U ] ] [msg-list]"
This command modifies the flag bits set on the listed messages.
It should not normally be needed, but is provided to allow users, through
the
.B cmd
facility, to alter the ways that certain conditions are recorded.
Multiple flag bits may be set or modified at once.
The modifiable flag bits are:
.sp
.nf
.ta 2i
.in +4
D	deleted
f	forwarded
N	new
O	old
P	preserved
p	printed
R	read
r	replied-to
S	saved
U	unread
.in -4
.fi
.sp
If a `+' or `\-' is included in the list of bits, the specified bits are
turned on or off respectively, without modifying other bits.
If no `+' or `\-' is given, then the list of bits is set explicitly and
all other bits are lost.
The `\-' modifier can be escaped with a backslash (i.e., \*Q\\\-\*U) to
prevent its interpretation as part of a message range, or it may be given
\fIafter\fR the list of bits for the same reason.
.sp
Message lists can be piped to the
.B flags
command; for example, you may use
.sp
.nf
.ti +4
cmd r 'flags \\!* + r | reply'
.fi
.sp
to mark as
.I replied-to
all messages included in a reply.
.TP
.BR folder " [\-N] [-n] [\-r] [ %[user] | # | & | file ]"
.RB ( fo )
Change current folder.
With no arguments, prints the name of the current folder.
The arguments are:
.nf
.ta 1i
.in +2
\-N	No headers are displayed upon entering new folder
\-n	The current folder is not updated
\-r	Set Read-Only mode (can't alter new folder)
%[user]	Change to /usr/spool/mail/[user] (default is yours)
#	Switch back to the previous folder
&	Change folder to $mbox (default is ~/mbox)
.in -2
.fi
.sp
File names that do not begin with `/' are interpreted relative to the current
directory unless they begin with one of the metacharacters `+' or `~'.
As in
.IR csh ,
the character `~' expands to the user's home directory (or to some other
user's home directory if used as \*Q~username\*U).
The character `+' is expanded to the name of the user's
.I folder
directory (defaults to \*Q~/Mail\*U or the value of the variable
.BR folder ).
For compatibility with other mailers, no `/' character needs to appear
between the `+' and the name of the folder (see \*QFilename metacharacters\*U
in the LINE-MODE INTERFACE section).
.sp
This command can only appear in a pipeline if it is the first command;
it returns a list of all the messages in the new folder.
This command cannot be used in initialization files before the shell
has started.
.sp
For compatibility with older versions, the argument `!' with
no leading `\-' is interpreted as \-n.
.TP
.B folders
List the names of the folders in your folder directory.
Your folder directory is the directory
.I Mail
in your home directory.
Or, you can set the variable
.B folder
to specify another folder directory.
.br
.TP
.BR from " [ + | \- ] [msg-list] [pattern]"
.RB ( f )
With no arguments,
.B from
will print the current message's header summary (see the variable
.BR hdr_format ).
If given a pattern,
.B from
will print the headers of those messages whose \*QFrom:\ \*U lines
match the pattern.
When a message list precedes the pattern, or when a message list is
supplied by a pipeline, the search is restricted to that list.
If only a message list is given (or piped),
.B from
will print the headers of the listed messages.
.sp
The special arguments `\-' and `+' can be given to move the
current message pointer to the previous or next message,
respectively, while also printing that message's header.
If a message list was given in addition to `\-' or `+', then
the current message pointer will be set to the first or last
message, respectively, in the message list given.
Examples:
.sp
.ti +2
from + Dan
.sp
will print the headers of all messages that contain \*QDan\*U in
in the author's name and set the current message pointer to
the last one of that kind in the list.
.sp
.ti +2
from \- 10-30 {16}
.sp
will print the headers of messages 10 through 30 except for
message 16 and set the current message pointer to 10.
.sp
.ti +2
from +
.sp
will print the header of the message after the current message
and increment the current message pointer to the next message.
.sp
.ti +2
from $
.sp
will print the last message's header and not move the current
message pointer.
.TP
.BR headers " [ [\-H][:c] ] [ + | \- ]"
.RB ( h ,
.BR z )
Prints a screenful of message headers listed in the
current folder.
If a message number is given on the command line,
the first message of the screenful of messages will be
that message number.
The `z' command is identical to the \*Qh +\*U
command and remains for compatibility reasons.
The variable
.B screen
may be set to tell how many headers are in a screenful.
In the graphics tool mode, the variable
.B screen_win
contains the number of headers used in the headers subwindow.
.sp
A typical header may look like:
.sp
.ti +2
5 >N  argv@spam.istc.sri.com Feb 19, (10/278) Test
.sp
This line indicates that it is message number 5 and the
.I >
indicates that the \*Qcurrent message pointer\*U is pointing to this
message.
The next two positions indicate the message status.
The first
may be one of, \*QN\*U (new and unread), \*QU\*U (old, but still
unread), \*Q*\*U (deleted), \*QS\*U (saved), \*QP\*U (preserved),
or \*Q \*U (read).
The second position may have an \*Qr\*U if the message
has been replied to.
.sp
The author of the example message header is
.IR argv@spam.istc.sri.com ,
the date is
.IR "Feb 19" ,
the number of lines in the message is
.IR 10 ,
the number of characters is
.I 278
and the subject of the message is
.IR Test .
The format of the message header shown here is described by
the string variable
.BR hdr_format .
The example given above has a hdr_format of
.sp
.ti +2
set hdr_format = "%25f %7d (%l/%c) %25s"
.sp
See the description of
.B hdr_format
in the VARIABLES section for more information on header formats.
.sp
You can print a special subset of message headers by using the
.I \-H:c
option, where `c' is one of:
.nf
.in +2
.ta 1i
.if t .ta 1.5i
a       all messages
d       deleted messages
n       new messages
o       old messages
r       replied to messages
s       saved messages
u       unread messages
.fi
.in -2
Note that the \-H is not required; \*Qheaders :c\*U is valid.
.sp
More options to the
.B headers
command include
.RI ` + '
and
.RI ` \- '.
Each will print the next or previous screenful of message headers.
The
.B z
command can also be used; `z' alone will print the next
screenful (thus, the `+' is optional)
and \*Qz \-\*U is equivalent to \*Qh \-\*U.
.sp
Headers affects all the messages it displays, so piping may be done
from the headers command.
Piping to the headers command causes the
message headers affected by the previous command to be printed.
This action is identical to piping to the
.B from
command.
.TP
.BR help " [topic]"
Help is provided on a per topic basis and on a general basis.
For general help, just typing
.I help
will provide some general information as to how to get further help
and a list of topics suggested for more specific help.
There is also help provided for each command by using the \-?
option to most commands.
This option will provide command line usage information as well as a
description of what the command does and how to use it.
.sp
If no help file is found, an error message will be printed.
The location of the help files may be reset by setting the variables
.B cmd_help
and
.B tool_help
to the paths of the new help files.
.sp
The
.B tool_help
variable is recognized only by versions capable of using suntool mode
(tool mode need not be active).
.TP
.BR history " [\-h] [\-r] [N]"
This command displays the command history in chronological order; early
commands are printed first followed by more recent commands displayed last.
Option
.I \-h
suppresses printing of history event numbers with each history command.
Option
.I \-r
reverses the order of the history events displayed.
.sp
If a number
.I N
is given, then that number of previous commands is
echoed rather than the number set by the variable
.BR history .
.sp
See the LINE-MODE INTERFACE section for a description of referencing the
history in commands.
.TP
.BR ignore / unignore " [header-list]"
Display or set a list of headers to be ignored when displaying messages.
When reading messages, all the message headers are displayed with the text
body of the message.
Since these message identifier fields are cumbersome and uninteresting
in many cases, you can filter out unwanted headers by using this command.
For example,
.sp
.ti +2
ignore Received Date Message-Id
.sp
will ignore the three specified fields.
Additional
.B ignore
commands are cumulative.
The command
.B unignore
is used to reverse the effects of
.BR ignore .
.sp
For another way to control this, see the variable
.BR show_hdrs .
.TP
.BR lpr " [-h] [-n] [\-Pname] [msg-list]"
Takes a message list and sends those messages, one by one, to the printer,
each separated by page feeds.
The \-h option suppresses printing of ignored headers (see the
.B ignore
command and the variables
.B show_hdrs
and
.BR alwaysignore ),
and the \-n option suppresses all headers.
A default printer name is supplied if one is not specified on the
command line
.RI (\-P printer-name ).
If you have the variable
.B printer
set, that printer name will be used.
.sp
If the variable
.B print_cmd
is set, the command described by that variable will be used instead
of the default system command.
In such cases, the -P option and the
.B printer
variable are ignored and the command is simply executed as is.
.sp
The \*Qprinted\*U status bit is set for each message printed by this command.
.TP
.BR ls " [flags]"
This command duplicates the
.IR UNIX (TM)
command
.I /bin/ls.
By default,
.I ls
always uses the -C flag (columnate output).
.TP
.BR mail " [flags] [recipient ...]"
.RB ( m )
Send mail to a list of users.
If no recipient list is specified on the
.I Mush
command line, then a \*QTo: \*U prompt will request one.
A list of recipients must be supplied at some time before the message is
sent, but is not required to begin composing a letter.
This implementation of
.I Mush
supports mailing to files and programs as recipients.
Filenames must be full pathnames; thus, they must start with a `/' or there
is no way to know whether a recipient is a pathname or a user name.
The special characters `+' and `~' may precede pathnames since they are
expanded first to the user's folder directory (+), as described by the variable
.BR folder ,
and the user's home directory (~).
Mailing to programs is indicated by the pipe `|' character preceding the
program name.
Since the user's path is searched, full pathnames are not required for
programs that lie in the user's PATH environment variable.
.sp
Example:
.sp
.ti +2
mail username, /path/to/filename, "|program_name", +folder_name, ~user/mbox
.sp
Options are:
.nf
.in +2
.if n .ta 1.5i
.if t .ta 1.8i
\-b addr-list	set list of blind carbon recipients
\-c addr-list	set list of carbon copy recipients
\-E	edit outgoing message headers
\-e	immediately enter editor (autoedit)
\-F	add random fortune to the end of message
\-f [msg-list]	forward messages (not indented)
\-H file	read file as prepared text (no headers)
\-h file	read file as a draft (text and headers)
\-I [msg-list]	include messages with headers (indented)
\-i [msg-list]	include messages in letter (indented)
\-s [subject]	prompt for subject [set subject explicitly]
\-U	send draft immediately (use only with \-h)
\-u	unsigned: no signatures or fortunes added
\-v	verbose (passed to mail delivery program)
.in -2
.fi
.sp
The verbose option may not be available depending on the mail transport
agent on your system.
.sp
The \-e flag causes you to enter the editor described by the variable
.BR visual .
.sp
The \-E flag causes
.I Mush
to place the headers of the outgoing message in
the editor file so they can be changed.
See the description of the variable
.B edit_hdrs
for details.
.sp
The \-i flag will include the current message into the body of the
message you are about to send.
The included message is indented by
the string \*Q> \*U or by the string described by the variables
.BR indent_str ,
.BR pre_indent_str ,
and
.BR post_indent_str .
See the VARIABLES section for more information on these string values.
If a message list is given after the \-i option, then the messages
described by that list are included.
The \-I option is identical to the \-i option except that the headers of
the message are also included.
.sp
The \-s flag looks at the next argument and sets the subject to that
string.
If the string is to contain spaces, enclose the entire subject
in quotes.
If there is no following argument, then the subject will
be prompted for.
This flag is useful if the user:
.sp
.in +2
.nf
\(bu does not have the variable \fBask\fR set, or
\(bu wishes to change the subject used with \fBreply\fR
.in -2
.fi
.sp
The subject is not prompted for and is ignored completely if the \-f flag
is specified (see below).
.sp
The \-f flag is for message forwarding only.
An optional message list can be given just as the -i option has.
The forward option does not allow you to edit the message(s) being forwarded
unless the -e flag is also specified.
The subject of the message (if available) is the same as the
.I current
message; it is not necessarily the subject of the message being forwarded.
The subject of forwarded mail cannot be changed.
However, using the \-e flag
will allow the user to change the subject once in editing mode either by
using the escape sequence, \*Q~s\*U, or by editing the \*QSubject:\*U header.
.sp
Forwarded mail that has not been edited by the user will contain special
headers such as
.sp
.ti +2
Resent-To:
.ti +2
Resent-From:
.sp
and perhaps others, depending on your mail transport agent.
Sendmail, for example, may add a number of other \*QResent-*\*U headers.
.sp
The \-u option, meaning \*Qunsigned\*U, prevents signatures and fortunes
from being appended to the message.
It overrides the variables
.B autosign
and 
.BR fortune ,
but will affect the \-F option only if given after it on the command line.
.sp
The \-h option indicates that the given file is a previously prepared
message, possibly a partial one saved with \*Q~w\*U.
Such a file is called a \fIdraft\fR.
The file argument must be given, and
in the current implementation
all message headers must either be
present in the file or must be added manually by the user.
At minimum, there must be a \*QTo:\*U header;
.I Mush
will add \*QFrom:\*U and \*QDate:\*U headers when sending, if necessary.
To read a prepared text file that does not contain headers, use \-H.
If the \-U option is also given, then the letter is sent immediately without
further editing.
.sp
.TP
.BR map [ ! "] [string [expansion]]"
.ns
.TP
.BR unmap [ ! "] string"
.rs
The
.B map
command creates or lists macros for the line mode interface, and the
.B map!
command creates or lists macros for the message composition mode.
In either mode, macros act in such a way that, when
.I string
is typed, the effect is the same as if
.I expansion
had been typed instead.
The
.I string
is usually one or two control characters, or a sequence sent by
one of the \*Qfunction keys\*U of a particular terminal.
See the MACROS section for the syntax used to specify the
.I string
and the
.IR expansion ,
and for comments on the interactions of macros in the same and in
different modes.
.sp
If no arguments are given, these commands will display the list of
macros and expansions for the appropriate mode.
If only a
.I string
is given, they will display the
.I expansion
associated with that string for the appropriate mode.
Otherwise, they will create a macro, associating the given
.I expansion
with the specified
.IR string .
.sp
Line mode macros are unset with the
.B unmap
command, and composition mode macros are unset with the
.B unmap!
command.
.TP
.BR merge " [-N] folder-name"
Messages from the named folder are read into the current folder.
The header summaries of the merged messages are printed unless the \-N
option is given (see the
.B folder
command, above).
This command can only appear in a pipeline if it is the first command;
it returns a list of all the messages from the merged-in folder.
This command cannot be used in initialization files before the shell
has started.
.TP
.BR my_hdr / un_hdr " [header]"
You can create personalized headers in your outgoing mail using this command.
.sp
.nf
Command usage:
.in +2
.ta 2.5i
my_hdr	print all your headers
my_hdr header	print value of header
my_hdr header: string	set header to string
un_hdr header:	unset header
.in -2
.sp
.fi
To set a header, the first argument must be a string
that contains no whitespace (spaces or tabs) and must end with
a colon (:).
The rest of the command line is taken to be the
text associated with the mail header specified.
If any quotes are used in the header and the header itself is not set in
quotes, then quotes should be escaped (preceded) by a backslash.
This holds true for semicolons, pipe characters
or any other metacharacter that
.I Mush
might interpret as a command line modifier.
.sp
If the variable
.B no_hdrs
is set, then your headers will not be added to outgoing messages,
but no headers will be unset.
The
.B un_hdr
command may take `*' as an argument to un_hdr everything set.
.sp
Example:
.sp
.ti +2
my_hdr Phone-Number: (415) 499-8649
.sp
.I Mush
treats the the header \*QFrom:\*U as a special case.
If you have set your own From:, a simple test is performed to determine
whether the address given is valid.
Any UUCP or domain address that directs mail to your login at the local
machine should be acceptable, but certain configurations may prevent some
combinations from being recognized.
If the address is valid, your From: header will be used; otherwise, an
address known to be valid will be generated and used instead.
Some mail transport agents are \*Qpicky\*U and will not allow
.I Mush
to supply a From: header; in these cases, your From: header is silently
removed at send time, and replaced with one generated by the MTA.
.sp
Note:  You cannot set the \*QDate:\*U.
Attempting to do so will not result in any
error messages; your date will simply be overwritten
by the system when your mail is sent.
.TP
.BR pick " [flags] [<pattern>]"
Allows the user to select particular messages from a folder.
The <pattern> is a \*Qregular expression\*U as described by
.IR ed .
If no arguments are given, the previous expression searched for is used.
You can search for messages from a user, for a particular subject line,
between certain dates, and limit searches to a range of messages.
You can also find all messages that do not
match the same arguments mentioned above.
.sp
.nf
Options:
.ta 1.5i
.in +2
+<num>	keep only the first <num> messages matched (head).
\-<num>	keep only the last <num> messages matched (tail).
\-ago <format>	search for messages relative to today's date.
\-d [+|\-]date	messages sent on or [+ after] [`\-' before] date.
\-e	take all remaining arguments to be the pattern.
\-f	search for pattern in \*QFrom\*U field only.
\-h header	search for pattern in specified header only.
\-i	ignore case of letters when searching.
\-r msg-list	search only the listed messages.
\-s	search for pattern in \*QSubject\*U field only.
\-t	search for pattern in \*QTo\*U field only.
\-x	select messages that do \fInot\fR match the pattern.
.in -2
.fi
.sp
The
.I \-ago
option can be abbreviated as
.IR \-a .
Only one of \-a, \-d, \-f, \-h, \-s and \-t can be specified at once.
Entire messages are scanned for the <pattern>
unless \-a, \-d, \-f, \-h, \-s or \-t is specified.
Messages marked for deletion are also searched.
No patterns can be specified with the \-a or \-d options.
The \-x option may not be used in conjunction with
.IR + n
(head) and
.IR \- n
(tail).
.sp
For the \-d option, \*Qdate\*U is of the form:
.sp
.ti +2
month/day/year
.sp
with an optional `\-' to specify that the messages of interest are those
older than that date.
Omitted fields of the date default to today's values.
Examples of selecting on date:
.nf
.in +2
.ta 2.0i
.sp
pick \-d 4/20	on April 20, this year.
pick \-d \-/2/85	on or before the 2nd, this month, 1985.
pick \-d +5/4	on or after May 4 of this year.
pick \-d /	today only.
.fi
.in -2
.sp
At least one `/' char must be used in a date.
There is no strong date checking; 2/30 would be considered a valid date.
.sp
For the \-ago option, the format is very simple.  Specify the number of
days followed by the word \*Qdays\*U, or the number of weeks followed by
the word \*Qweeks\*U, and so on with months and years.  Truncation is allowed,
since only the first character is examined, so all of the following are
equivalent:
.sp
.in +2
.nf
pick \-ago 1 day, 2 weeks
pick \-ago 2Weeks 1Day
pick \-ago 2w,1day
pick \-a 2w1d
.fi
.in -2
.sp
These examples will find all messages that are exactly 2 weeks and 1 day
old.  All \*Qago\*U dates collapse into \*Qday\*U time segments.  This
means that months are 30.5 days long.  If more precise date selection is
required, use the \-d option and specify specific dates.
.sp
Also note that the \-ago option allows
the \*Qbefore\*U (\-) and \*Qafter\*U (+)
arguments.  Thus, you may pick all messages older than 1 week with:
.sp
.ti +2
pick \-ago \-1 week
.sp
Other examples of
.B pick:
.sp
.ti +2
pick \-d 2/5/86 | pick \-d \-2/5/87 | pick \-s "mail stuff" | lpr
.sp
Will find all the messages between the dates February 5, 1986, and
February 5, 1987, that contain the subject "mail stuff" and send them
to the printer.
.sp
.ti +2
pick -s Re: | delete
.sp
Deletes messages that have \*QRe:\*U in the Subject header.
.sp
.ti +2
folder +project | pick \-f frank
.sp
Finds all messages from frank in the folder described by +project.
.sp
.ti +2
pick \-h return-path ucbvax
.sp
Searches all messages that have the header "Return-Path:" and determines
if the string \*Qucbvax\*U is in the header.
Note that case sensitivity
applies only to the pattern searched, not the header itself.
.sp
.ti +2
pick \-ago +1w | save +current
.sp
This finds all messages that are a week or less old and saves them in the file
called \fIcurrent\fR, which is found in the user's \fIfolder\fR variable.
.sp
.ti +2
pick +3 mush-users
.sp
Finds the first three messages containing the string \*Qmush-users\*U.
.sp
.ti +2
eval -h "pick +2 \-r .-$ \-s %s" | pick \-1
.sp
Finds the next message with the same subject as the current message.
.TP
.BR pipe " [\-p pattern] [msg-list] unix-command"
Allows the user to send the texts of a list of messages to a
.IR UNIX (TM)
command.
The list of messages may either be given explicitly or may come from a
.I Mush
pipeline (see \*QPiping commands\*U under the LINE-MODE INTERFACE section).
If a list is neither given nor piped, the current message is used.
All headers are considered part of the message text for purposes of this
command unless the value of the variable
.B alwaysignore
includes the word \*Qpipe\*U (see
.B alwaysignore
in the VARIABLES section for more information).
For example,
.sp
.in +4
.nf
pipe 3 5 7 patch
.fi
.in -4
.sp
sends the text and headers of messages 3, 5 and 7 to the
.I patch
utility.
.sp
If a
.I pattern
is specified with the \-p option, \fIMush\fR will search
the message for a line beginning with that string.
The matching line and all succeeding lines will be sent to the
.IR unix-command .
If \-p is not given, and the
.I unix-command
is omitted, \fIMush\fR will search for a line beginning with \*Q#!\*U
and feed that line and all succeeding lines to \*Q/bin/sh\*U.
Thus,
.B pipe
with no arguments treats the current message as a shell script.
.sp
The pattern may also be of the form
.I /pattern1/,/pattern2/
in which case printing will begin with the line containing
.I pattern1
and end with the line containing
.I pattern2
(inclusive).
Patterns of this form must still match at beginning of line, and
regular expressions are not currently allowed.
.sp
The
.B pipe
command can also be invoked as
.B Pipe
(note capitalization), in which case only the body of the messages,
and none of the message headers, are sent to the unix command.
.sp
When the variable
.B unix
is set,
.IR UNIX (TM)
commands can appear anywhere
.I except as the first command
in a 
.I Mush
pipeline without explicitly using
.BR pipe .
However, it is still necessary to specify
.B Pipe
in order to exclude all headers.
.sp
.IR Note :
All messages listed as arguments to
.B pipe
or
.B Pipe
are sent to the standard input of the
.I same
process as a continuous stream!  This is probably not desirable when
extracting shell scripts in particular, so take care.
Future revisions may provide an option to control this behavior.
.TP
.B preserve
.RB ( pre )
Saves a message list in your spool directory rather than
your mailbox unless it has been explicitly deleted.
The variable
.B hold
causes all messages to be held in your spool directory automatically.
.TP
.B print
.RB ( p ,
.BR type ,
.BR t )
Takes a message list and displays each message on the user's terminal.
If the first letter of the command is a capital letter (`P' or `T')
then \*Qignored\*U headers are not ignored
.I provided
that the variable
.B alwaysignore
is either not set or is set to one of its possible values.
If this variable is set with no value, the ignored headers will be
ignored regardless of the command used to display the message.
See the
.B ignore
command for more information about ignored message headers.
.sp
The `+' and the `\-' keys can be used to display the \*Qnext\*U
and \*Qprevious\*U messages respectively.
The `+' key has the caveat that the
message is not paged at all and none of the messages headers are displayed.
.TP
.B pwd
Prints the current working directory.
.TP
.B quit
.RB ( q )
Updates the current folder and exits from
.IR Mush .
If the variable \*Qhold\*U is set, all messages not marked for deletion are
saved in the spool directory.
Otherwise, messages that have been read are saved to
.I ~/mbox
or to the file described by the string variable
.BR mbox .
Messages marked for deletion are discarded.
Unread messages go back to the spool directory in all cases.
.TP
.BR reply / replyall " [msg-list] [-r path] [flags] [users]"
.RB ( r / R )
Messages are replied to by sending mail to the sender of each message
in the given message list.
The command
.B replysender
is equivalent to
.BR reply .
.B Replyall
responds to all the recipients as well as the sender of the message.
These commands understand all the same flags as the
.B mail
command.
.sp
When constructing a return mail address to the author of a message,
.B reply
searches for special mail headers in the author's message that
indicate the most efficient mail path for return mail.
.I Mush
will search for the \*QReply-To:\*U, \*QReturn-Path:\*U,
and \*QFrom:\*U headers, in that order, by default.
.sp
If none of these fields are found in the message, the first line of the
message is parsed if possible;
this \*QFrom\ \*U line is different from the \*QFrom:\ \*U line.
If the user wishes to change the order or the actual fields to search for
return paths, then the variable
.B reply_to_hdr
may be set to a list of headers to be used (in the order specified).
If it is set, but has no value, the first \*QFrom\ \*U line is used
regardless of what headers the author's message contains.
The \*QFrom\ \*U line may be specified explicitly as an item in the
list of reply-to headers by specifying the header:
.B From_.
See the VARIABLES section for more information about
.B reply_to_hdr.
.sp
When replying to all recipients of the message using the
.B replyall
.RB ( R )
command, only the original author's address can be obtained from
the message headers.
There is no way to determine the best path to the
other recipients of the message from message headers aside from taking
their addresses directly from the \*QTo:\*U and \*QCc:\*U lines.
.sp
Example:
.sp
.ti +2
replyall 3,4,5 -i 4,5 7 -s response mail-group
.sp
Here, messages 3, 4 and 5 are replied to (all the authors are obtained
from each of those messages as well as the recipients from those messages)
and the text from messages 4, 5 and 7 are included in the body of the reply.
The subject is set to "response" and the alias mail-group is appended to
the list of recipients for this message.
.sp
The -r flag will prepend the path to each recipient in the address list
with the indicated path.  This overrides the value of \fBauto_route\fR,
but has the exact same functionality.  See the explanation of the variable
in the VARIABLES section.  Also see the MAIL ADDRESSES section for more
information concerning replying to messages.
.nf
.TP
.BR save / write / copy " [\-f] [\-s | \-a] [msg-list] [filename / directory]"
.fi
.RB ( s / w )
With no arguments,
.B save
and
.B write
will save the current message to the file
.I mbox
in the user's home directory (or the file specified by the
.B mbox
variable).
If a message list is given, then the messages specified by
the list are saved.
If a filename is given, then that filename is used instead of mbox.
The \-s options forces the filename used to be that of the subject of
the message.  Similarly, the \-a option causes the filename used to be
that of the author of the message being saved.  If more than one message
is being saved, the subject or author name used is that of the smallest
message number (since message lists have no order of precedence).  With
these two options, a directory name may be given to specify a directory
other than the current directory.
.sp
If the file exists and is writable, the specified command
will append each message to the end of the file.
If \-f is given, then the file is overwritten causing whatever contents it
contains to be lost.
For compatibility with older versions, the character `!' may be substituted
for \-f (no `\-' is used with `!').
If the current folder is the system mailbox, then saved messages are
marked for deletion when the user exits using the
.B quit
command.
If the variable
.I keepsave
is set or the current folder is not the system mailbox, then messages are
not marked for deletion.
.sp
The
.B write
command differs from
.B save
and
.B copy
in that the message headers are
.I not
saved in the file along with the body of text.
The
.B copy
command is is like
.B save
except that messages are never marked for deletion, whether or not
.B keepsave
is set.
.sp
Because message lists are used to determine the messages to be saved,
if the user wishes to save messages to a file that begins with a digit
or any other message list metacharacter, a backslash should precede
the filename to escape the message list expansion routine.
The backslash will not become a part of the filename.
.TP
.BR saveopts " [file]"
The complement of
.BR source ,
.BR saveopts ,
will save all settable variables, aliases
and cmd's in the initialization file.
(See the INITIALIZATION
section for more information on initialization files.)
If an argument is given, that file is used.
Beware that this will overwrite files, so any \*Qif\*U expressions
will be lost, as will settings that have changed since entering
.IR Mush .
Using saveopts is highly discouraged
and is intended for the naive user only.
.TP
.BR set " [[?]variable [= value]]"
.ns
.TP
.BR unset " variable"
.rs
With no arguments,
.B set
prints all variable values.
Otherwise, it sets the named
.IR variable .
Arguments are of the form \*Qvariable=value\*U (whitespace is allowed).
Boolean options such as
.I autoedit
need not have \*Q=value\*U associated in the command.
Multivalued variables are set in the same way as other variables, and
the list of values should be enclosed in quotes if whitespace is used
to separate the items.
See the VARIABLES section for details of the format of each type of variable.
.sp
The special command
.sp
.ti +2
set ?all
.sp
will print all known variables utilized by the program and a brief
description of what they do.
The user may set and manipulate his own set of variables, but internal
variables that are utilized by the program are the only ones displayed.
.sp
The command
.sp
.ti +2
set ?variable_name
.sp
will print the same information for one variable instead of all variables.
You may unset everything by issuing the command \*Qunset *\*U.
.sp
It is possible to set a variable to a list of messages returned by another
command by using the piping mechanism.  For example,
.sp
.ti +2
pick \-s Status Reports | set reports
.sp
The variable
.I reports
now contains a message list which can be used
as the message list argument to any command which accepts a list.
.sp
.ti +2
mail \-i $reports boss
.sp
This command will mail to \*Qboss\*U and include the text of all the
messages held in the \fIreports\fP variable.
.TP
.BR sh " [command]"
Invokes an interactive version of the shell.
The shell spawned is described by the variable
.BR shell .
If the optional argument
.I command
is given, then that command is executed under the Bourne Shell.
If the special character `&' is at the end of any shell command,
then the command will be executed in background.
.TP
.BR source " [file]"
Read
.I Mush
commands from a file.
If no filename is specified, the files searched
for are .mushrc or .mailrc in the user's home directory.
If the environment variable
.I MUSHRC
or
.I MAILRC
is set, then the file named by the variable is sourced instead.
If a filename is given on the command line, that file is sourced.
See the INITIALIZATION heading and the
.B home
variable descriptions for more information.
.TP
.BR sort " [\-i] [[\-r] \-a | \-d | \-l | \-R | \-s | \-S]"
This command will sort messages according to author, date, status or subject
(with or without considering the \*QRe: \*U, in replied messages).
In addition, the messages can be sorted in reverse order (same arguments).
.sp
.nf
Options:
.in +2
.ta 1i
\-i	ignore case in alphabetical sorts
\-r	reverse sort order of next option
\-a	sort by author (alphabetical)
\-d	sort by date
\-l	sort by length of message
\-R	sort by subject including \*QRe:\*U
\-s	sort by subject (alphabetical)
\-S	sort by message status
.in -2
.fi
.sp
By default (no arguments),
.B sort
sorts messages by
.IR status .
New, unread messages are first, followed by preserved messages,
and finally deleted messages are placed at the end of the list.
If \-r is the only option given, the status ordering is reversed.
.sp
When sorting by date, the boolean variable
.B date_received
is checked.  If it is set, then sorting goes by date received.
Otherwise (default), sorting is by date sent by the original author.
.sp
If more than one sort option is specified, they will be applied in
left-to-right sequence to each comparison.
Thus:
.sp
.ti +2
sort \-a \-d
.sp
sorts messages by author and, if the author of any set of messages
is the same, sorts within that set by date.
Note that the \-r option applies to only one other option at a time;
to reverse the sort of both author and date requires:
.sp
.ti +2
sort \-r \-a \-r \-d
.sp
The options can also be grouped:
.sp
.ti +2
sort \-ra \-rd
.ti +2
sort \-rard
.sp
Currently, only the line mode interface supports multiple sort criteria,
but the other interfaces allow subsorting indirectly
when appropriate actions are taken, as discussed below.
.sp
It is also possible to sort a consecutive sublist of messages by using pipes.
