		}
		if (c == 'd') {
		    rm_edfile(-2);
		    return 0;
		} else if (c == 'c') {
		    wprint("(continue editing letter)\n");
		    return -1;
		} else if (c == 's')
		    break;
	    }
	}
    }

    if (send_it() == -1) {
	if (isoff(flags, SEND_NOW))
	    wprint("(continue)\n");
	return -1;
    }
    return 0;
}

/*
 * actually send the letter.
 * 1. reset all the signals because of fork.
 * 2. determine recipients (users, address, files, programs)
 * 3. determine mailer, fork and return (if not verbose).
 * 4. popen mailer, $record, and other files specified in step 1.
 * 5. make the headers; this includes To: line, and user set headers, etc...
 * 6. copy the letter right into the array of file pointers (step 1).
 * 7. close the mailer and other files (step 1) and remove the edit-file.
 * return -1 if mail wasn't sent.  could be user error, could be the system.
 * allow user to try again or to save message to file and abort message.
 * return 0 if successful.
 */
static int
send_it()
{
    register char *p, *b, *addr_list;
#ifdef MAXFILES
    register int size = MAXFILES - 1;
    FILE *files[MAXFILES];
    char *names[MAXFILES];
#else
    register int size = getdtablesize() - 1;
    FILE *files[30];  /* 30 should be sufficiently large enough */
    char *names[30];
#endif /* MAXFILES */
#if defined(VERBOSE_ARG) && !defined(SUNTOOL)
    SIGRET (*oldchld)();
#endif /* VERBOSE_ARG && !SUNTOOL */
    int next_file = 1; /* reserve files[0] for the mail delivery program */
    int log_file = -1; /* the index into the files array for mail logging */
    char buf[3*HDRSIZ];
    char *orig_to, *orig_cc, *orig_bcc; /* save originals to restore on error */
    char expand = !do_set(set_options, "no_expand");
    int fork_err = 0;

    names[0] = names[1] = NULL; /* for free_vec() */
    /* If edit_hdrs, make sure the correct headers exist and are intact
     * before bothering to continue.
     */
    if (ison(flags, EDIT_HDRS)) {
	/* fool header_field into thinking that the file is the folder */
	FILE *save_tmpf = tmpf;
	long old_offset = msg[msg_cnt].m_offset;

	if (!ed_fp) {
	    wprint("No file for headers!\n");
	    return -1;
	}
	Debug("Getting headers from file ... ");

	tmpf = ed_fp;
	msg[msg_cnt].m_offset = 0L;
	if (p = header_field(msg_cnt, "to")) {
	    (void) strcpy(To, p);
	    Cc[0] = Bcc[0] = 0;
	    if (p = header_field(msg_cnt, "cc"))
		(void) strcpy(Cc, p);
	    if (p = header_field(msg_cnt, "bcc"))
		(void) strcpy(Bcc, p);
	    if (p = header_field(msg_cnt, "fcc"))
		next_file += find_files(p, names+next_file, size-next_file, 1);
	} else
	    *To = 0; /* Error caught below */
	msg[msg_cnt].m_offset = old_offset;
	tmpf = save_tmpf;
	Debug("\n");
    }
    if (!*To) {
	wprint("You must have a To: recipient to send mail.\n");
	if (!istool) {
	    (void) signal(SIGINT, oldint);
	    (void) signal(SIGQUIT, oldquit);
	    (void) signal(SIGTERM, oldterm);
	}
	free_vec(&names[1]);
	return -1;
    }

    if (!(p = do_set(set_options, "sendmail")))
	p = MAIL_DELIVERY;

#ifdef VERBOSE_ARG
    if (ison(flags, VERBOSE) || do_set(set_options, "verbose")) {
	turnon(flags, VERBOSE); /* prevent fork when "verbose" has changed */
#ifndef SUNTOOL
	oldchld = signal(SIGCHLD, SIG_DFL); /* let pclose() do the wait() */
#endif /* SUNTOOL */
#ifdef MMDF
	b = &buf[strlen(sprintf(buf, "%s%s", p, VERBOSE_ARG))];
#else /* MMDF */
	b = &buf[strlen(sprintf(buf, "%s %s", p, VERBOSE_ARG))];
#endif /* MMDF */
    } else
#endif /* VERBOSE_ARG */
	b = buf + Strcpy(buf, p);
#ifdef METOO_ARG
    if (!strcmp(p, MAIL_DELIVERY) && do_set(set_options, "metoo"))
	b += strlen(sprintf(b, " %s", METOO_ARG));
#endif /* METOO_ARG */
    *b++ = ' ', *b = 0; /* strcat(b, " "); */
    addr_list = b; /* save this position to check for addresses later */

    /* save original list.  If alias expansion fails, replace address lists
     * with what was originally typed so user can fix it.  This isn't necessary
     * if the lists are already in the file the user is editing (edit_hdrs).
     */
    if (isoff(flags, EDIT_HDRS))
	orig_to = savestr(To);
    /*
     * Build the address lines to give to the mail transfer system.  This
     * address line cannot contain comment fields!  First, expand aliases
     * since they may contain comment fields within addresses. Copy this
     * result back into the Buffer since this will go into the header ...
     * Next, remove all comments so the buffer contains ONLY valid addresses.
     * Next, strip off any filenames/programs which might occur in the list.
     * Finally, add this information to the command line buffer (buf).
     * Remove commas if necessary (see ifdefs).  In the event of errors,
     * force a dead letter by rm_edfile(-1).
     */
    if (!(p = alias_to_address(To))) {
	print("address expansion failed for To: list.\n");
	free_vec(&names[1]);
	if (isoff(flags, EDIT_HDRS))
	    strcpy(To, orig_to), xfree(orig_to);
	return -1;
    } else {
	next_file += find_files(p, names+next_file, size-next_file, 0);
	if (expand)
	    (void) strcpy(To, p);
	rm_cmts_in_addr(p);
	skipspaces(0);
	b += Strcpy(b, p);
    }
    if (isoff(flags, EDIT_HDRS))
	orig_cc = savestr(Cc);
    if (*Cc) {
	if (!(p = alias_to_address(Cc))) {
	    wprint("address expansion failed for Cc: list.\n");
	    free_vec(&names[1]);
	    if (isoff(flags, EDIT_HDRS)) {
		strcpy(To, orig_to), xfree(orig_to);
		strcpy(Cc, orig_cc), xfree(orig_cc);
	    }
	    return -1;
	} else {
	    next_file += find_files(p, names+next_file, size-next_file, 0);
	    if (expand)
		(void) strcpy(Cc, p);
	    rm_cmts_in_addr(p);
	    skipspaces(0);
	    if (*p) {
		*b++ = ',', *b++ = ' ';
		b += Strcpy(b, p);
	    }
	}
    }

    /* expand Bcc addrs, but don't add to list yet.  sign letter first */
    if (isoff(flags, EDIT_HDRS))
	orig_bcc = savestr(Bcc);
    if (*Bcc) {
	if (p = alias_to_address(Bcc))
	    p = strcpy(Bcc, p);
	else {
	    wprint("address expansion failed for Bcc: list.\n");
	    free_vec(&names[1]);
	    /* rm_edfile(-1); */
	    if (isoff(flags, EDIT_HDRS)) {
		strcpy(To, orig_to), xfree(orig_to);
		strcpy(Cc, orig_cc), xfree(orig_cc);
		strcpy(Bcc, orig_bcc), xfree(orig_bcc);
	    }
	    return -1;
	}
    } else
	p = NULL;

    /* Sign the letter before adding the Bcc list since they aren't
     * considered when adding a signature.
     */
    if (*addr_list && ison(flags, SIGN|DO_FORTUNE) &&
	    isoff(glob_flags, REDIRECT) && isoff(flags, FORWARD))
	sign_letter(addr_list, flags, ed_fp);

    if (p) { /* p still points to expanded Bcc list */
	next_file += find_files(p, names+next_file, size-next_file, 0);
	rm_cmts_in_addr(p);
	skipspaces(0);
	if (*p) {
	    *b++ = ',', *b++ = ' ';
	    b += Strcpy(b, p);
	}
    }
    if (!*addr_list && next_file == 1) {
	wprint("There must be at least 1 legal recipient.\n");
	if (isoff(flags, EDIT_HDRS)) {
	    strcpy(To, orig_to), xfree(orig_to);
	    strcpy(Cc, orig_cc), xfree(orig_cc);
	    strcpy(Bcc, orig_bcc), xfree(orig_bcc);
	}
	return -1;
    }

#ifdef NO_COMMAS
    for (p = buf; p = index(p, ','); p++)
	*p = ' ';
#endif /* NO_COMMAS */

    Debug("mail command: %s\n", buf);

    if (isoff(flags, VERBOSE) && debug < 3)
	switch (fork()) {
	    case  0:  /* the child will send the letter. ignore signals */
#ifdef SYSV
		if (setpgrp() == -1)
#else /* SYSV */
		if (setpgrp(0, getpid()) == -1)
#endif /* SYSV */
		    error("setpgrp");
#ifndef SUNTOOL
		(void) signal(SIGCHLD, SIG_DFL);
		(void) signal(SIGTERM, SIG_IGN);
#endif /* SUNTOOL */
		(void) signal(SIGINT, SIG_IGN);
		(void) signal(SIGHUP, SIG_IGN);
		(void) signal(SIGQUIT, SIG_IGN);
#ifdef SIGTTIN
		(void) signal(SIGTTOU, SIG_IGN);
		(void) signal(SIGTTIN, SIG_IGN);
#endif /* SIGTTIN */
#ifdef SIGCONT
		(void) signal(SIGCONT, SIG_IGN);
		(void) signal(SIGTSTP, SIG_IGN);
#endif /* SIGCONT */
		turnon(glob_flags, IGN_SIGS);
	    when -1:
		error("fork failed trying to send mail");
		fork_err++;
		if (isoff(flags, EDIT_HDRS)) {
		    strcpy(To, orig_to);
		    strcpy(Cc, orig_cc);
		    strcpy(Bcc, orig_bcc);
		}
		/* fall thru */
	    default:
		/* istool doesn't need ed_fp, so don't keep it around */
		if (istool || !fork_err && isoff(glob_flags, REDIRECT))
		    (void) fclose(ed_fp), ed_fp = NULL_FILE;
		free_vec(&names[1]);
		if (isoff(flags, EDIT_HDRS))
		    xfree(orig_to), xfree(orig_cc), xfree(orig_bcc);
		if (!istool) {
		    (void) signal(SIGINT, oldint);
		    (void) signal(SIGQUIT, oldquit);
		    (void) signal(SIGTERM, oldterm);
		}
		return 0 - fork_err;
	}


#ifdef MMDF
    *(addr_list-1) = '\0';
#endif /* MMDF */
    if (debug > 2) {
	files[0] = stdout;
	if (!*addr_list)
	    addr_list = "[no recipients]";
    } else if (*addr_list) {
	if (!(files[0] = open_file(buf, TRUE, FALSE))) {
	    rm_edfile(-1); /* force saving of undeliverable mail */
	    if (isoff(flags, VERBOSE) && debug < 3)
		exit(-1);
	    else
		return 0;
	}
    } else
	files[0] = NULL_FILE;

    if (ison(flags, VERBOSE))
	wprint("Sending letter ... "), (void) fflush(stdout);
#ifdef MMDF
    /* give address list to submit */
    for (p = addr_list; *p && (p = any(p, ",<")); p++)
	if (*p == ',')
	    *p = '\n';
	else
	    p = index(p, '>');
    if (*addr_list)
	(void) fprintf(files[0], "%s\n\n", addr_list);
#endif /* MMDF */

    /* see if log is set.  This is just to add message headers. No msg body. */
    if (p = do_set(set_options, "logfile")) {
	if (!*p)
	    p = "~/mail.log";
	if (!index("~|/+", *p))
	    (void) sprintf(buf, "%s/%s", do_set(set_options, "cwd"), p);
	else
	    (void) strcpy(buf, p);
	log_file = next_file;
	next_file += find_files(buf, names+next_file, size-next_file, 0);
	if (log_file == next_file)
	    log_file = -1;
    }

    /* see if record is set.  If so, open that file for appending and add
     * the letter in a format such that mail can be read from it
     */
    if (p = do_set(set_options, "record")) {
	if (!*p)
	    p = "~/record";
	if (!index("~|/+", *p))
	    (void) sprintf(buf, "%s/%s", do_set(set_options, "cwd"), p);
	else
	    (void) strcpy(buf, p);
	next_file += find_files(buf, names+next_file, size-next_file, 0);
    }

    /* Don't need to open names[0] as files[0], so skip those */
    next_file = 1 + open_list(names + 1, files + 1, next_file - 1);

    /* First, put the message separator in... */
    for (size = 1; size < next_file; size++)
#ifndef MSG_SEPARATOR
	{
	    time_t t;
	    (void) time(&t);
	    (void) fprintf(files[size], "From %s %s", login, ctime(&t));
	}
#else /* MSG_SEPARATOR */
#ifdef MMDF
	(void) fputs(MSG_SEPARATOR, files[size]);
#else /* MMDF */
	(void) fprintf(files[size], "%s\n", MSG_SEPARATOR);
#endif /* MMDF */
#endif /* MSG_SEPARATOR */

    /* if redirection, ed_fp = stdin, else rewind the file just made */
    if (isoff(glob_flags, REDIRECT))
	rewind(ed_fp);
    else
	ed_fp = stdin;

#ifndef MSG_SEPARATOR
    /* If forwarding or reading a draft, skip the leading From_ line.
     * This is done for drafts so that messages saved by dead_letter()
     * can be read back in as a draft; in other cases, this isn't done
     * for edit_hdrs because FORWARD wouldn't be set.
     */
    if (ison(flags, FORWARD|SEND_NOW) && fgets(buf, sizeof buf, ed_fp) &&
	strncmp(buf, "From ", 5) != 0)
	rewind(ed_fp); /* No From_ line (should never happen) */
#endif /* MSG_SEPARATOR */
    {
	long offset = add_headers(ed_fp, files, next_file, flags);
	if (offset == -1)
	    offset = 0L;
	(void) fseek(ed_fp, offset, L_SET);
    }

    /* Read from stdin or the edfile till EOF and send it all to the mailer
     * and other open files/folders/programs. Check for "From " at the
     * beginnings of these lines to prevent creating new messages in folders.
     */
    while (fgets(buf, sizeof buf, ed_fp))
	for (size = 0; size < next_file; size++) {
	    if (!files[size]) /* files[0] will be NULL if not calling MTA */
		continue;
	    if (size == log_file)
		continue;
#ifndef MSG_SEPARATOR
	    if (!strncmp(buf, "From ", 5))
		(void) fputc('>', files[size]);
#endif /* MSG_SEPARATOR */
	    if (fputs(buf, files[size]) == EOF) {
		if (size == 0) {
		    error("Lost connection to MTA");
		    dead_letter(-1);
		    break;
		} else {
		    /* Drop this file, but continue writing others */
		    if (names[size]) {
			error("Write failed: %s", names[size]);
			(void) close_lock(names[size], files[size]);
			xfree(names[size]);
		    } else
			error("Write failed");
		    if (size < --next_file) {
			names[size] = names[next_file];
			files[size--] = files[next_file];
		    }
		    files[next_file] = NULL_FILE;
		    names[next_file] = NULL;
		}
	    }
	}

    /* loop thru the open files (except for the first: the mail delivery agent)
     * and append a blank line so that ucb-mail can read these folders.
     * Then close the files.
     */
    for (size = 1; size < next_file; size++) {
#ifdef END_MSG_SEP
	(void) fputs(END_MSG_SEP, files[size]);
#endif /* END_MSG_SEP */
	if (names[size]) {
#ifndef END_MSG_SEP
	    (void) fputc('\n', files[size]);
#endif /* !END_MSG_SEP */
	    if (close_lock(names[size], files[size]) == EOF) {
		error("Warning: Close failed: %s", names[size]);
	    }
	    xfree(names[size]);
	} else {
	    if (debug < 3)
		(void) fclose(files[size]); /* Don't mess with pclose() */
	    else
		(void) pclose(files[size]); /* unless we never forked */
	}
    }

    if (debug < 3) {
	int reply_code = files[0]? pclose(files[0]) : (MTA_EXIT << 8);
	Debug("pclose reply_code = %d\n", reply_code);
	rm_edfile((reply_code == (MTA_EXIT << 8))? 0 : -1);
    } else
	rm_edfile(0);

#ifndef SUNTOOL
#ifdef VERBOSE_ARG
    if (ison(flags, VERBOSE))
	(void) signal(SIGCHLD, oldchld);
#endif /* VERBOSE_ARG */
#endif /* SUNTOOL */

    if (ison(flags, VERBOSE) || debug > 2) {
	if (isoff(glob_flags, REDIRECT))
	    wprint("sent.\n");
	if (!istool) {
	    (void) signal(SIGINT, oldint);
	    (void) signal(SIGQUIT, oldquit);
	    (void) signal(SIGTERM, oldterm);
	}
    } else
	exit(0); /* not a user exit -- a child exit */
    return 0;
}

/*
 * Add the necessary headers to make a file a legitimate mail message.
 * This could be for a file which the user will edit (via edit_hdrs) or
 * for delivery to an MTA.
 * Make folders conform to RFC-822 by adding From: and Date: headers.
 * Prefix certain header with the "Resent-" prefix when forwarding.
 * Return offset of fp if we're parsing it for headers (for delivery to MTA).
 */
static long
add_headers(fp, files, size, flags)
FILE *fp, *files[];
int size;
u_long flags;
{
    char buf[BUFSIZ], From_buf[256], *pF = From_buf, date_str[64];
    char *host = NULL, *p, *subj = NULL, *own_from = NULL; /* See WARNING */
    int i, for_editor = (fp == NULL_FILE);
    int got_date = for_editor, got_from = for_editor;
    struct options *opts;

    if (for_editor && hfile) {
	i = file_to_fp(hfile, files[0], "r");
	xfree(hfile), hfile = NULL;
	return (i < 0 ? -1 : TRUE);
    }

    buf[0] = 0;
    if (ourname)
	host = ourname[0];
    if (for_editor)
	turnoff(flags,FORWARD); /* forwarded messages must not be edited */

    /* [Re]create a From: header -- check first to see if the user has
     * created a From: header with the my_hdr command (the own_hdrs list).
     * If his is not legitimate, warn user and use the other header.
     */
    if ((for_editor || isoff(glob_flags, EDIT_HDRS)) &&
	    own_hdrs && !do_set(set_options, "no_hdrs")) {
	for (opts = own_hdrs; opts; opts = opts->next)
	    if (!strcmp(opts->option, "From:")) {
		p = opts->value;
		skipspaces(0);
		sprintf(buf, "%sFrom: %s\n",
				ison(flags, FORWARD)? "Resent-" : "", p);
		own_from = buf;
		/* WARNING: the above depends on the following facts:
		 * 1. If for_editor, own_from will be output immediately,
		 *    so buf will not be overwritten;
		 * 2. If !for_editor but EDIT_HDRS, the "real" from line
		 *    will be read from the file so own_from isn't needed;
		 * 3. If neither, From: is the first line output, so
		 *    buf will not be overwritten.
		 * Any change in the above means a new buffer for own_from
		 * may be needed.  Check carefully.
		 */
	    }
	}
    if (ison(flags, FORWARD))
	pF += Strcpy(From_buf, "Resent-");
    pF += Strcpy(pF, "From: ");
#ifdef UUCP
    if (host && *host)
	pF += strlen(sprintf(pF, "%s!", host));
#endif /* UUCP */
    pF += Strcpy(pF, login);
#ifndef UUCP
    if (host && *host)
	pF += strlen(sprintf(pF, "@%s", host));
#endif /* UUCP */
    if ((p = do_set(set_options, "realname")) ||
	(p = do_set(set_options, "name")))
	pF += strlen(sprintf(pF, " (%s)", p));
    *pF++ = '\n', *pF++ = 0;

    /* First print From, Date, In-Reply-To */
    for (i = 0; i < size; i++) {
	if (!files[i])
	    continue;
	if (for_editor)
	    if (own_from)
		(void) fputs(own_from, files[i]), *own_from = 0;
	    else
		(void) fputs(From_buf, files[i]);
	else if (isoff(flags, EDIT_HDRS)) {
#ifdef PICKY_MAILER
	    if (i > 0)
#endif /* PICKY_MAILER */
	    if (own_from)
		(void) fputs(own_from, files[i]), *own_from = 0;
	    else
		(void) fputs(From_buf, files[i]);
	    got_from = TRUE;
	}
	if (for_editor || isoff(flags, EDIT_HDRS)) {
#ifdef PICKY_MAILER
	    if (i > 0 && !for_editor)
#endif /* PICKY_MAILER */
	    (void) fprintf(files[i], "%sDate: %s\n",
		ison(flags, FORWARD) ? "Resent-" : "", rfc_date(date_str));
	    got_date = TRUE;
	    if (*in_reply_to)
		fprintf(files[i], "In-Reply-To: %s\n", in_reply_to);
	}
    }
    /* next print user's own message headers */
    if (for_editor || isoff(flags, EDIT_HDRS))
	if (own_hdrs && !do_set(set_options, "no_hdrs")) {
	    for (opts = own_hdrs; opts; opts = opts->next) {
		if (!strcmp(opts->option, "From:"))
		    continue;
		for (i = 0; i < size; i++) {
		    if (!files[i])
			continue;
		    p = opts->value;
		    skipspaces(0);
		    fprintf(files[i], "%s %s\n", opts->option, p);
		}
	    }
	}

    /*
     * Now either prepare to put the rest of the headers into the file
     * or (when sending edited headers) copy them back out of the file
     */
    if (for_editor) {
	char *orig = NULL;
	/* for edit_hdrs, print the headers followed by a blank line */
	if (To[0]) {
	    orig = savestr(To);
	    if (!(p = alias_to_address(To))) {
		wprint("To: list unmodified.\n");
		p = orig;
	    }
	    (void) strcpy(To, p);
	}
	if (Cc[0]) {
	    strdup(orig, Cc);
	    if (!(p = alias_to_address(Cc))) {
		wprint("Cc: list unmodified.\n");
		p = orig;
	    }
	    (void) strcpy(Cc, p);
	}
	if (Bcc[0]) {
	    strdup(orig, Bcc);
	    if (!(p = alias_to_address(Bcc))) {
		wprint("Bcc: list unmodified.\n");
		p = orig;
	    }
	    (void) strcpy(Bcc, p);
	}
	xfree(orig);
    } else if (ison(flags, EDIT_HDRS)) {
	/* copy the headers of the message removing special headers */
	int print_hdr = FALSE;
	if (isoff(flags, SEND_NOW))
	    rewind(fp); /* Drafts may have had fp positioned */
	while (fgets(buf, sizeof(buf), fp)) {
	    (void) no_newln(buf);
	    if (!buf[0])
		break;
	    /* if the first char is NOT a space, it MUST be a new header.
	     * Otherwise, it is considered part of the message body.
	     */
	    if (!isspace(buf[0])) {
		print_hdr = TRUE;
		if (!(p = any(buf, " \t:")) || isspace(*p))
		    break; /* this is not a legitimate header */
		skipspaces(1);
		if (!*p)
		    print_hdr = FALSE; /* blank headers are not allowed */
		p = buf;
		if (!lcase_strncmp(buf, "resent-", 7)) {
		    if (ison(flags, EDIT_HDRS))
	    wprint("You can't use \"Resent-\" headers in edited messages.\n");
		    p += 7;
		}
		if (!lcase_strncmp(p, "to:", 3) ||
		    !lcase_strncmp(p, "cc:", 3) ||
		    !lcase_strncmp(p, "bcc:", 4) ||
		    !lcase_strncmp(p, "fcc:", 4) ||
		    !lcase_strncmp(p, "x-mailer:", 9) ||
		    !lcase_strncmp(p, "status:", 7))
		    print_hdr = FALSE;
		else if (!lcase_strncmp(p, "date:", 5))
		    if (got_date)
			wprint("You can't change or add date headers.\n");
		    else {
			got_date = TRUE;
			(void) sprintf(buf, "Date: %s", rfc_date(date_str));
			p = buf;
		    }
		else if (!lcase_strncmp(p, "subject:", 8))
		    (print_hdr = FALSE), strdup(subj, p);
		else if (!lcase_strncmp(p, "from:", 5)) {
		    char not_me[BUFSIZ];
		    (void) strcpy(not_me, buf + 5);
		    take_me_off(not_me);
		    if (*not_me) {
			/* Ignore bogus From: if we have a good one */
			if (got_from)
			    print_hdr = FALSE;
			/* otherwise, output a good one */
			else {
			    (void) strcpy(buf, From_buf);
			    (void) no_newln(buf);
			}
		    }
		    got_from = TRUE;
#ifdef PICKY_MAILER
		    /* don't send From: to mta -- fool "for loop" below
		     * by initializing the loop at files[1], not files[0]
		     */
		    if (!for_editor)
			print_hdr = 2;
#endif /* PICKY_MAILER */
		}
	    }
	    if (print_hdr)
		/* print_hdr may be 2 for From: header */
		for (i = print_hdr-1; i < size; i++)
		    if (files[i]) {
			(void) fputs(buf, files[i]);
			(void) fputc('\n', files[i]);
		    }
	}
    }
    /* Finally, do the required (or changed) headers (Date, To, Cc) */
    (void) wrap_addrs(To, 80);
    (void) wrap_addrs(Cc, 80);
    (void) wrap_addrs(Bcc, 80);
    for (i = 0; i < size; i++) {
	if (!files[i])
	    continue;
#ifdef PICKY_MAILER
	if (i > 0) {
#endif /* PICKY_MAILER */
	if (!got_from)
	    if (own_from)
		(void) fputs(own_from, files[i]);
	    else
		(void) fputs(From_buf, files[i]);
	if (!got_date)
	    (void) fprintf(files[i], "%sDate: %s\n",
		ison(flags, FORWARD) ? "Resent-" : "", rfc_date(date_str));
#ifdef PICKY_MAILER
	}
#endif /* PICKY_MAILER */
	(void) fprintf(files[i], "X-Mailer: %s\n", check_internal("version"));
	(void) fprintf(files[i], "%sTo: %s\n",
	    ison(flags, FORWARD) ? "Resent-" : "", To);
	if (for_editor || isoff(flags, EDIT_HDRS)) {
	    if (isoff(flags, FORWARD) &&
		    (*Subject || for_editor && (do_set(set_options, "ask") ||
					    do_set(set_options, "asksub"))))
		(void) fprintf(files[i], "Subject: %s\n", Subject);
	} else if (subj && *subj && strlen(subj) > 9)
	    (void) (fputs(subj, files[i]), fputc('\n', files[i]));
	if (*Cc || for_editor && do_set(set_options, "askcc"))
	    (void) fprintf(files[i], "%sCc: %s\n",
		ison(flags, FORWARD) ? "Resent-" : "", Cc);
	if (i > 0 || for_editor)
	    /* Do not send these to mail transfer agent */
	    if (*Bcc)
		(void) fprintf(files[i], "%sBcc: %s\n",
		    ison(flags, FORWARD) ? "Resent-" : "", Bcc);
	if (i > 0)
	    (void) fprintf(files[i], "Status: OR\n");
    }
    for (i = 0; i < size; i++)
	if (files[i])
	    (void) fflush(files[i]);
    if (buf[0]) /* last attempted header read was a line of msg text */
	for (i = 0; i < size; i++) {
	    if (files[i]) {
		(void) fputs(buf, files[i]);
		(void) fputc('\n', files[i]);
		(void) fflush(files[i]);
	    }
	}
    else
	if (isoff(flags, FORWARD))
	    for (i = 0; i < size; i++)
		if (files[i]) {
		    (void) fputc('\n', files[i]);
		    (void) fflush(files[i]);
		}
    return fp? ftell(fp) : (long)TRUE;
}

/* ARGSUSED */
SIGRET
rm_edfile(sig)
{
    if (sig > 0) {
	char *fix;
	if (ison(glob_flags, IGN_SIGS))
	    return;
	/* wrapcolumn may have been trashed -- restore it */
	if ((fix = do_set(set_options, "wrapcolumn")) && *fix)
	    wrapcolumn = atoi(fix);
	mac_flush(); /* abort pending macros */
    }
    /* now check whether we should abort the letter */
    if (sig > 0 && !killme && ison(glob_flags, IS_GETTING)) {
	if (!istool)
	    (void) signal(sig, rm_edfile);
	killme = 1;
	print("\n** interrupt -- one more to kill letter **\n");
	longjmp(cntrl_c_buf, 1);
    }
    killme = 0;
    /* if sig == -1, force a save into dead.letter.
     * else, check for nosave not being set and save anyway if it's not set
     * sig == 0 indicates normal exit (or ~x), so don't save a dead letter.
     */
    if (sig == -1 || sig != 0 && !do_set(set_options, "nosave"))
	dead_letter(sig);
    if (isoff(glob_flags, REDIRECT) && ed_fp) /* ed_fp may be null in toolmode*/
	(void) fclose(ed_fp), ed_fp = NULL_FILE;
    (void) unlink(edfile);

    turnoff(glob_flags, IS_GETTING);
    if (sig == -1)
	return;

    if (sig == SIGHUP)
	cleanup(0);
    if (!istool) {
	(void) signal(SIGINT, oldint);
	(void) signal(SIGQUIT, oldquit);
	(void) signal(SIGTERM, oldterm);
    }

    if (sig == 0 || sig == -2 || istool) /* make sure sigchld is reset first */
	return;

    if (isoff(glob_flags, DO_SHELL)) {  /* If we're not in a shell, exit */
	puts("exiting");
	echo_on();
	exit(1);
    }
    longjmp(jmpbuf, 1);
}

/* save letter into dead letter */
dead_letter(sig)
int sig;	/* signal passed to rm_edfile() or 0 */
{
    char 	*p, buf[BUFSIZ];
    long 	t;
    FILE 	*dead;

    if (ison(glob_flags, REDIRECT)) {
	print("input redirected -- can't save dead letter.\n");
	return;
    }
    /* If the file doesn't exist, get outta here. File may not exist if
     * user generated a ^C from a promptable header and catch sent us here.
     */
    if (!ed_fp && Access(edfile, R_OK) != 0)
	return;
    /* User may have killed mush via a signal while he was in an editor.
     * ed_fp will be NULL in this case.  Since the file does exist (above),
     * open it so we can copy it to dead letter.
     */
    if (!ed_fp && !(ed_fp = fopen(edfile, "r"))) {
	error("can't save dead letter from %s", edfile);
	return;
    }
    /* don't save a dead letter if there's nothing to save. */
    if (fseek(ed_fp, 0L, 2) || ftell(ed_fp) <= 1L)
	return;
    if (!(p = do_set(set_options, "dead")))
	p = "~/dead.letter";
    if (!(dead = open_file(p + (*p == '|'), (*p == '|'), TRUE)))
	return;
    (void) time (&t);
    (void) fflush(ed_fp);
    rewind(ed_fp);
#ifdef MSG_SEPARATOR
	(void) fputs(MSG_SEPARATOR, dead);
#ifndef MMDF
    (void) fputc('\n', dead);
#endif /* MMDF */
#else /* MSG_SEPARATOR */
    (void) fprintf(dead, "From %s %s", login, ctime(&t));
#endif /* MSG_SEPARATOR */
    (void) fprintf(dead, "From: %s\nTo: %s\nSubject: %s\n", login, To, Subject);
    (void) fprintf(dead, "Date: %s\n", rfc_date(buf));
    if (*Cc)
	(void) fprintf(dead, "Cc: %s\n", Cc);
    if (*Bcc)
	(void) fprintf(dead, "Bcc: %s\n", Bcc);
    (void) fputc('\n', dead);
    while (fgets(buf, sizeof(buf), ed_fp))
	(void) fputs(buf, dead);
    (void) fputc('\n', dead);
#ifdef END_MSG_SEP
    (void) fputs(END_MSG_SEP, dead);
#endif /* END_MSG_SEP */
    if (*p != '|')
	(void) close_lock(p, dead);
    else
	(void) pclose(dead);
    wprint("Saved%s letter in %s.\n", sig > 0? " unfinished" : "", p);
}
