/**			cutfile.c		**/

/** This program is written for the MSG mail system (and other programs
    that could use it's functionality, of course!) for the express purpose
    of allowing a message out of a file of messages to be QUICKLY extracted
    into another file.

    Usage: cutfile <filename> <offset-into-file> <number-of-lines> <dest-file>

    It is fed to standard output if dest-file = "-".

    (C) Copyright 1986 Dave Taylor
**/

#include <stdio.h>
#include <errno.h>

#define  SLEN		256		/* string length */

extern int errno;			/* system errno  */

main(argc, argv)
int argc;
char *argv[];
{
	FILE  *infile, *outfile;
	char   buffer[SLEN];
	register lines;

	if (argc != 5)
	  exit (fprintf(stderr, "Usage: %s <filename> <offset> <lines> <dest-file>\n",
	        argv[0]));

	if ((infile = fopen(argv[1], "r")) == NULL) 
	  exit (fprintf(stderr, "%s cannot open file %s for reading!\n",
		argv[0], argv[1]));

	if (argv[4][0] == '-')
	   outfile = stdout;
	else
	  if ((outfile = fopen(argv[4], "w")) == NULL)
	    exit (fprintf(stderr, "%s cannot open file %s for writing!\n",
		argv[0], argv[1]));

	if (fseek(infile, atoi(argv[2]), 0L) == -1)
	    exit (fprintf(stderr, "%s encountered error %d trying to fseek to %ld\n",
		  argv[0], errno, argv[2]));

	lines = atoi(argv[3]);

	while (fgets(buffer, SLEN, infile) != NULL) {
	  fputs(buffer, outfile);
	  if (--lines == 0)
	    exit(0);
	}

	exit(1);	/* 1 indicates read past EOF */
}
