/**			softkeys.c			**/

/** This file and associated routines: (C) Copyright 1986, Dave Taylor **/

#include <stdio.h>
#include "headers.h"

define_softkeys(level)
int level;
{
	dprint0("define_softkeys(level=");

	if (! hp_softkeys) {
	  dprint0("0) [error: no softkeys!]\n");
	  return;
	}

	if (level == MAIN) {
	  dprint0("MAIN)\n");
	  if (notesfile) {
	    define_key(f1, "  Show    Note",   "\r");
	    define_key(f2, "  Reply  to Note",  "r");
	    define_key(f3, " Change  Mailbox", "c");
	    define_key(f4, "  Save    Note",   "s");
	    define_key(f5, " Delete/Undelete", "^");
	    define_key(f6, " Print    Note",   "p");
	    define_key(f7, "  HELP",           "?");
	    define_key(f8, "  Quit     Msg",   "q");
	  }
	  else {
	    define_key(f1, "  Show     Msg",   "\r");
	    define_key(f2, "  Mail     Msg",   "m");
	    define_key(f3, "  Reply  to Msg",  "r");
	    define_key(f4, " Change  Mailbox", "c");
	    define_key(f5, "  Save     Msg",   "s");
	    define_key(f6, " Delete/Undelete", "^");
	    define_key(f7, " Print     Msg",   "p");
	    define_key(f8, "  Quit     Msg",   "q");
	  }
	}
	else if (level == ALIAS) {
	  dprint0("ALIAS)\n");
	  define_key(f1, " Alias  Current",  "a");
	  define_key(f2, " Check   Alias",   "c");
	  define_key(f3, " Make    Alias",   "m");
	  clear_key(f4);
	  clear_key(f5);
	  clear_key(f6);
	  clear_key(f7);
	  define_key(f8, " Return  to Msg",  "r");
	}
	else if (level == YESNO) {
	  dprint0("YES-NO)\n");
	  define_key(f1, "  Yes",  "y");
	  clear_key(f2);
	  clear_key(f3);
	  clear_key(f4);
	  clear_key(f5);
	  clear_key(f6);
	  clear_key(f7);
	  define_key(f8, "   No",  "n");
	}
	else if (level == READ) {
	  dprint0("READ)\n");
	  define_key(f1, "  Next    Page  ", " ");
	  clear_key(f2);
	  clear_key(f3);
	  clear_key(f4);
	  clear_key(f5);
	  clear_key(f6);
	  clear_key(f7);
	  define_key(f8, " Return  to Msg", "\n");
	}
	else if (level == CHANGE) {
	  dprint0("CHANGE)\n");
	  define_key(f1, "  Mail  Directry", "=/");
	  define_key(f2, "  Home  Directry", "~/");
	  clear_key(f3);
	  define_key(f4, "Incoming Mailbox", "!\n");
	  clear_key(f5);
	  clear_key(f6);
	  clear_key(f7);
	  define_key(f8, " Cancel", "\n");
	}

	softkeys_on();
}

define_key(key, display, send)
int key;
char *display, *send;
{

	char buffer[30];

	dprint3("define-key(key=%d, display='%s', send='%s'\n",
	         key, display, send);

	sprintf(buffer,"%s%s", display, send);

	printf("%c&f%dk%dd%dL%s", ESCAPE, key,
		strlen(display), strlen(send), buffer);
}

softkeys_on()	
{ 
	/* turn on softkeys (esc&jB) and turn on MENU and USER/SYSTEM */

	if (hp_softkeys) 
	  printf("%c&jB%c&jR", ESCAPE, ESCAPE); 
}

softkeys_off()	
{ 
	/* turn off softkeys (esc&j@) */

	if (hp_softkeys) 
	  printf("%c&j@", ESCAPE); 
}

clear_key(key)  
{ 	
	/** set a key to nothing... **/

	if (hp_softkeys) 
	   define_key(key, "                ", ""); 
}
