/** 		showmsg.c		**/

/** This file contains all the routines needed to display the specified
    message.

   These routines (C) Copyright 1986 Dave Taylor 
**/


#include "headers.h"
#include <ctype.h>

#ifdef BSD
#undef tolower
#endif

int
show_msg(number)
int number;
{
	/*** display number'th message.  Get starting and ending lines
	     of message from headers data structure, then fly through
	     the file, displaying only those lines that are between the
	     two!
	 	Returns non-zero if message shown!
	***/

	dprint1("show_msg(number=%d)\n", number);

	if (number > message_count) {
	  error1("Only %d messages!", message_count);
	  return(0);
	}
	else if (number < 1) {
	  error("you can't read THAT message!");
	  return(0);
	}

	return(show_message(header_table[number-1].lines, 
	       header_table[number-1].offset,number));
}

int
show_message(lines, file_loc, msgnumber)
int lines, msgnumber;
long file_loc;
{
	/*** Show the indicated range of lines from mailfile
	     for message 'msgnumber' by using 'display'
	     	Returns non-zero if it actually put something on 
	     the screen.
	***/

	dprint3("show_message(lines=%d, loc=%ld, msg-number=%d)\n", 
	        lines, file_loc, msgnumber);

	if (fseek(mailfile, file_loc, 0) != 0) {
	  error1("msg [seek] failed looking %d bytes into file",
		  file_loc);	
	  return(FALSE);
	}

	/* next read will get 'this' line so must be at end of previous */

	Raw(OFF);
	display(lines, msgnumber);
	Raw(ON);

	return(TRUE);	/* we did it boss! */
}
	

/** these two variables are used iff the variable 'title_message' is
    set, and are buffers for output of message title... **/

static char top_of_screen_left [LONG_STRING], 
     	    top_of_screen_right[LONG_STRING];

display(lines, msgnum)
int lines, msgnum;
{
	/** Display specified number of lines from file mailfile.
	    Note: This routine MUST be placed at the first line 
	    of the input file! **/

	char buffer[LONG_STRING], *full_month();

	int lines_on_screen = 0;		/* display */
	int crypted = 0, gotten_key = 0;	/* encryption */
	int weed_header, weeding_out = 0;	/* weeding */ 

	dprint2("display(lines=%d, msgnum=%d)\n", lines, msgnum);

	if (title_messages) {
	  tail_of(header_table[msgnum-1].from, buffer, FALSE);
	  sprintf(top_of_screen_left, "%s #%d %s %s", 
		   notesfile? "Note" : "Message", msgnum, 
		   (strncmp(header_table[msgnum-1].from, "To:", 3) == 0?
		    "to": "from"), buffer);
	  sprintf(top_of_screen_right," %s %s %s, %d at %s",
		  notesfile? "Posted" : "Mailed",
     		  full_month(header_table[msgnum-1].month), 
		  header_table[msgnum-1].day, 
	          atoi(header_table[msgnum-1].year) + 1900,
	          header_table[msgnum-1].time);

	  dprint1("\ttos_left: '%s'\n", top_of_screen_left);
	  dprint1("\ttos_right: '%s'\n", top_of_screen_right);
	}

	weed_header = filter;	/* allow us to change it after header */

	ClearScreen();

	if (cursor_control) transmit_functions(OFF);

	while (lines > 0) {

	    if (fgets(buffer, LONG_STRING, mailfile) == NULL) {
	      PutLine(LINES-1, 0, "Please press <space> to return: ");
	      (void) ReadCh();
	      if (cursor_control) transmit_functions(ON);
	      return(TRUE);
	    }

	    if (strlen(buffer) > 0) 
              no_ret(buffer);

	    if (strlen(buffer) == 0) {
	      weed_header = 0;		/* past header! */
	      weeding_out = 0;
	    }

	    lines--;

	    if (notesfile) {	/* treat notes differently! */

	      if (filter && (first_word(buffer, NOTES_HEADER) ||
	          first_word(buffer, NOTES_FOOTER)) ) 
	        /*** weed this line out of the display! ***/;
	      else if (show_line(buffer, &lines_on_screen, &lines)) {
	          if (cursor_control) transmit_functions(ON);
	          return(TRUE);
	      }
	    }

	    else { /* "normal" message */

	      if (weed_header && matches_weedlist(buffer)) 
	        weeding_out = 1;	 /* aha!  We don't want to see this! */
	      else if (buffer[0] == '[') {
	        if (strcmp(buffer, START_ENCODE)==0)
		  crypted++;
	        else if (strcmp(buffer, END_ENCODE)==0)
	          crypted--;
	        else if (crypted) {
                  encode(buffer);
	          if (show_line(buffer, &lines_on_screen, &lines)) {
	            if (cursor_control) transmit_functions(ON);
	            return(TRUE);
	          }
	        }
	        else
	          if (show_line(buffer, &lines_on_screen, &lines)) {
	            if (cursor_control) transmit_functions(ON);
	            return(TRUE);
	          }
	      }
	      else if (crypted) {
	        if (! gotten_key++) getkey(OFF);
	        encode(buffer);
	        if (show_line(buffer, &lines_on_screen, &lines)) {
	          if (cursor_control) transmit_functions(ON);
	          return(TRUE);
	        }
	      }
	      else if (weeding_out) {
	        weeding_out = (whitespace(buffer[0]));	/* 'n' line weed */
	        if (! weeding_out) 	/* just turned on! */
	          if (show_line(buffer, &lines_on_screen, &lines)) {
	            if (cursor_control) transmit_functions(ON);
	            return(TRUE);
	          }
	      } 
	      else
	        if (show_line(buffer, &lines_on_screen, &lines)) {
	          if (cursor_control) transmit_functions(ON);
	          return(TRUE);
	        }
	    }
	  }
	

	PutLine(LINES-1, 0, "Please press <space> to return: ");
	Raw(ON);
	(void) ReadCh();
        if (cursor_control) transmit_functions(ON);
	return(TRUE);
}

int
show_line(buffer, lines_on_screen, total) 	
char *buffer;
int  *lines_on_screen, *total;
{
	/** Displays the given line if it can.  if not, it will put the
	    'ole 'space to continue' prompt on the bottom of the screen
	    and wait for either a 'space' or 'return'.  If 'return' is
	    hit (or 'q'), then it will return non-zero, otherwise it'll
	    return zero.
	**/

	static char overlap [LONG_SLEN];
	       char mybuffer[SLEN], ch;
	       int  last_line_loc;

	dprint3("show_line(buffer=%s, on-screen=%d, total=%d)\n", 
		 buffer, *lines_on_screen, *total);

	last_line_loc     = *lines_on_screen;	/* one back... */

	*lines_on_screen += ((strlen(buffer) / COLUMNS) + 1);

	if (last_line_loc == 0 && title_messages) {
	  display_title(*total);
	  last_line_loc = 2;
	  *lines_on_screen += 2;
	}
		  
	  
	if (*lines_on_screen > LINES-2) {
	  if (*total > 0) {
	    sprintf(mybuffer, "%d line%s left", *total, plural(*total));
	    PutLine(LINES-1, COLUMNS-20, "%s", mybuffer);
	    PutLine(LINES-1, 0, "Press <space> to continue: ");
	  }
	  else
	    PutLine(LINES-1, 0, "Please press <space> to return: ");
	  Raw(ON);
	  ch = ReadCh();
	  if (ch == '\n' || ch == '\r' || tolower(ch) == 'q')
	    return(TRUE);
	  if (ch == ' ' && *total == 0)	/* don't want '0' lines left */
	    return(TRUE);
	  Raw(OFF);
	  ClearScreen();
	  *lines_on_screen = 0;

	  if (title_messages) {
	    display_title(*total);
	    *lines_on_screen = 2;
	  }
		  
	  PutLine(*lines_on_screen, 0, "%s", overlap);
	  *lines_on_screen  += ((strlen(overlap) / COLUMNS) + 1);
	  last_line_loc = *lines_on_screen;
	  *lines_on_screen += ((strlen(buffer) / COLUMNS) + 1);
	}

	PutLine(last_line_loc, 0, "%s", buffer);      

	if (*lines_on_screen > LINES-6)		/* in case next is too LONG */
	  strcpy(overlap, buffer);
	
	return(FALSE);
}

display_title(lines_into_message)
int lines_into_message;
{
	/** Display top title, including "Page N" **/
	
	register int page;

	dprint1("displaytitle(lines-into-message=%d)\n", lines_into_message);

	page = (int) (lines_into_message) / (LINES - 4);
	
	PutLine(0,0,top_of_screen_left);

	PutLine(0, COLUMNS-strlen(top_of_screen_right), 
	        top_of_screen_right, page);
}
