/**			return_addr.c			**/

/** This set of routines is used to generate real return addresses
    and also return addresses suitable for inclusion in a users
    alias files (ie optimized based on the pathalias database).

    These routines (C) Copyright 1986 Dave Taylor
**/

#include "headers.h"

#include <sys/types.h>
#include <sys/stat.h>

char *shift_lower(), *notes_machine(), *expand_address();

optimize_return(address)
char *address;
{
	/** This routine tries to create an optimized address, that is,
	    an address that has the minimal information needed to 
	    route a message to this person given the current path
	    database...
	**/

	/** first step is to figure out what sort of address we 
	    have... **/

	dprint1("\noptimize_return(address='%s')\n", address);

	if (chloc(address, '%') != -1)
	  optimize_cmplx_arpa(address);
	else if (chloc(address, '@') != -1)
	  optimize_arpa(address);
	else
	  optimize_usenet(address);
}

optimize_cmplx_arpa(address)
char *address;
{
	/** Try to optimize a complex ARPA address.  A Complex address is one 
	    that contains '%' (deferred '@').  For example:  
		veeger!hpcnof!hplabs!joe%sytech@syte  
	    is a complex address (no kidding, right?).  The algorithm for 
	    trying to resolve it is to move all the way to the right, then 
	    back up left until the first '!' then from there to the SECOND 
	    metacharacter on the right is the name@host address...(in this 
            example, it would be "joe%sytech").  Check this in the routing
	    table.  If not present, keep backing out to the right until we
	    find a host that is present, or we hit the '@' sign.  Once we
	    have a 'normal' ARPA address, hand it to optimize_arpa().
	**/

	char name[SHORT_SLEN], buffer[SLEN], junk[SLEN];
	char host[SHORT_SLEN], old_host[SHORT_SLEN];
	register int i, loc, nloc = 0, hloc = 0, passes = 1;

	dprint1("optimize_cmplx_arpa(address='%s')\n", address);

	/** first off, get the name%host... **/

	for (loc = strlen(address)-1; address[loc] != '!' && loc > -1; loc--)
	   ;

	while (address[loc] != '\0') {

	  if (passes == 1) {
	    loc++;

	    while (address[loc] != '%' && address[loc] != '@')
	      name[nloc++] = address[loc++];
	  }
	  else {
	    for (i=0; old_host[i] != '\0'; i++)
	      name[nloc++] = old_host[i];
	  }

	  loc++;
  
	  while (address[loc] != '%' && address[loc] != '@')
	    host[hloc++] = address[loc++];
  
	  host[hloc] = name[nloc] = '\0';

	  dprint2("\tgot name = %s and host = %s\n", name, host);

	  strcpy(old_host, host);
	  remove_domains(host);

	  sprintf(buffer, "%s@%s", name, shift_lower(host));

	  if (expand_site(buffer, junk) == 0) {
	    strcpy(address, buffer);
	    return;
	  }
	  else if (address[loc] == '@') {
	    optimize_arpa(address);
	    return;
	  }
	  else
	    name[nloc++] = '%';	/* for next pass through */

	}
}

optimize_arpa(address)
char *address;
{
	/** Get an arpa address and simplify it to the minimal
	    route needed to get mail to this person... **/

	char name[SHORT_SLEN], buffer[SLEN], junk[SLEN];
	char host[SHORT_SLEN];
	register int loc, nloc = 0, hloc = 0, at_sign = 0;

	dprint1("optimize_arpa(address='%s')\n", address);

	for (loc = strlen(address)-1; address[loc] != '!' && loc > -1; loc--) {
	  if (address[loc] == '@')
	     at_sign++;	/* remember this spot! */
	  else if (at_sign)
	    name[nloc++] = address[loc];
	  else
	    host[hloc++] = address[loc];
	}

	name[nloc] = host[hloc] = '\0';

	reverse(name);
	reverse(host);

	remove_domains(host);

	dprint2("\tname = %s and host = %s\n", name, shift_lower(host));

	sprintf(buffer,"%s@%s", name, shift_lower(host));

	if (expand_site(buffer, junk) == 0) {
	  strcpy(address, buffer);
	  return;
	}

	optimize_usenet(address);	/* that didn't work... */
}
	
optimize_usenet(address)
char *address;
{
	/** optimize the return address IFF it's a standard usenet
	    address...
	**/

	char name[SHORT_SLEN],  new_address[SLEN], buffer[SLEN], junk[SLEN];
	register int loc, nloc = 0, aloc = 0, passes = 1;

	dprint1("\noptimize_usenet(address='%s')\n", address);

	for (loc = strlen(address)-1; address[loc] != '!' && loc > -1; loc--) 
	  name[nloc++] = address[loc];
	name[nloc] = '\0';

	reverse(name);

	dprint1("\tgot name = %s\n", name);

	new_address[0] = '\0';	

	/* got name, now get machine until we can get outta here */

	while (loc > -1) {

	  new_address[aloc++] = address[loc--];	/* the '!' char */

	  while (address[loc] != '!' && loc > -1)
	    new_address[aloc++] = address[loc--];

	  new_address[aloc] = '\0';

	  strcpy(buffer, new_address);
	  reverse(buffer);
	
	  if (expand_site(buffer, junk) == 0) {
	    if (passes == 1 && chloc(name, '@') == -1) {
	      buffer[strlen(buffer) - 1] = '\0';	/* remove '!' */
	      dprint2("\tReturning address %s@%s\n", name, buffer);
	      sprintf(address, "%s@%s", name, buffer);
	    }
	    else {
	      dprint2("\tReturning address '%s%s'\n", buffer, name);
	      sprintf(address, "%s%s", buffer, name);
	    }
	    return;		/* success! */
	  }
	  else
	    dprint1("\taddress %s failed!\n", buffer);

	  passes++;
	}

	dprint0("\tnothing to do!\n");
	return;		/* nothing to do! */
}

get_return(buffer)
char *buffer;
{
	/** reads 'current' message again, building up the full return 
	    address including all machines that might have forwarded 
	    the message.  **/

    char buf[LONG_SLEN], name1[SLEN], name2[SLEN], lastname[SLEN];
    char hold_return[LONG_SLEN], alt_name2[SLEN];
    int ok = 1, lines;

    dprint0("get_return(<buffer>)\n");

    /** are we reading a notesfile file??  **/

    if (notesfile) {
      strcpy(buf, header_table[current-1].from);
      if (chloc(buf, '!') == -1) 
        sprintf(buf, "%s!%s", notes_machine(), header_table[current-1].from);
      strcpy(buffer, expand_system(buf, 1));
      dprint1("\treturn address [notes] = %s\n", buffer);
      return;
    }

    /** get to the first line of the message desired **/

    if (fseek(mailfile, header_table[current-1].offset, 0) == -1) {
	error1("msg [seek] couldn't read %d bytes into file",
	       header_table[current-1].offset);
	return;
    }
 
    /** okay!  Now we're there!  **/

    lines = header_table[current-1].lines;
    
    buffer[0] = '\0';

    while (ok && lines--) {
      ok = (int) (fgets(buf, LONG_SLEN, mailfile) != NULL);
      if (first_word(buf, "From ")) {
	sscanf(buf, "%*s %s", hold_return);
      }
      else if (first_word(buf, ">From")) {
	sscanf(buf,"%*s %s %*s %*s %*s %*s %*s %*s %*s %s %s", 
	       name1, name2, alt_name2);
	if (strcmp(name2, "from") == 0)
	  strcpy(name2, alt_name2);
	add_site(buffer, name2, lastname);
      }

#ifdef USE_EMBEDDED_ADDRESSES

      else if (first_word(buf, "From:")) {
	get_address_from("From:", buf, hold_return);
      }
      else if (first_word(buf, "Reply-To:")) {
	get_address_from("Reply-To:", buf, buffer);
	return;
      }

#endif

      else if (strlen(buf) < 2)	/* done with header */
         lines = 0; /* let's get outta here!  We're done!!! */
     }

    if (buffer[0] == '\0')
      strcpy(buffer, hold_return); /* default address! */
    else
      add_site(buffer, name1, lastname);	/* get the user name too! */

    dprint1("\treturn address = '%s'\n", buffer);

}
