/**			pattern.c			**/

/**    General pattern matching for the MSG mailer.     

       (C) Copyright 1986 Dave Taylor
**/

#include <errno.h>

#include "headers.h"

static char pattern[SLEN] = { "" };
static char alt_pattern[SLEN] = { "" };

extern int errno;

int
pattern_match()
{
	/** Get a pattern from the user and try to match it with the
	    from/subject lines being displayed.  If matched (ignoring
	    case), move current message pointer to that message, if
	    not, error and return ZERO **/

	register int i;

	PutLine(LINES-3,40,"/ =match anywhere in messages");
	
	PutLine(LINES-1,0, "Match Pattern:");

	if (pattern_enter(pattern, alt_pattern, LINES-1, 16, 
	    "Match Pattern (in entire mailbox):"))
	  if (strlen(alt_pattern) > 0)
	    return(match_in_message(alt_pattern));
	  else
	    return(1);
	  
	if (strlen(pattern) == 0) 
	  return(0);

	for (i = current; i < message_count; i++) {
	  if (from_matches(i, pattern)) {
	    current = ++i;
	    return(1);
	  }
	  else if (subject_matches(i, pattern)) {
	    current = ++i;
	    return(1);
	  }
	}

	return(0);
}

int
from_matches(message_number, pattern)
int message_number;
char *pattern;
{
	/** Returns true iff the pattern occurs in it's entirety
	    in the from line of the indicated message **/

	
	return( in_string(header_table[message_number].from, pattern) );
}

int
subject_matches(message_number, pattern)
int message_number;
char *pattern;
{
	/** Returns true iff the pattern occurs in it's entirety
	    in the subject line of the indicated message **/

	
	return( in_string(header_table[message_number].subject, pattern) );
}

match_in_message(pattern)
char *pattern;
{
	/** Match a string INSIDE a message...starting at the current 
	    message read each line and try to find the pattern.  As
	    soon as we do, set current and leave! 
	    Returns 1 if found, 0 if not
	**/

	char buffer[LONG_STRING];
	int  message_number;
	long location;

	dprint1("match_in_message(pattern='%s')\n", pattern);

	location = header_table[current-1].offset;
	message_number = current-1;

	if (fseek(mailfile, location, 0) != 0) {

	  dprint2("\tfseek(mailfile, %ld, 0) failed with error %d\n",
		   location, errno);

	  error1("msg [match] failed looking %ld bytes into file",
		 location);
	  return(1);	/* fake it out to avoid replacing error message */
	}

	error("searching for pattern...");

	while (fgets(buffer, LONG_STRING, mailfile) != NULL) {
	
	  if (in_string(buffer, pattern)) {
	    current = message_number; 
	    clear_error();
	    return(1);
	  }

	  location += strlen(buffer);

	  if (location > header_table[message_number].offset)
	    message_number++;
	}

	return(0);
}
