/**			notesfile.c			**/

/**  Routine that reads in a file comprised of saved messages from
     'notes'.  

     (C) Copyright 1986 Dave Taylor
**/

#include "headers.h"
#include <errno.h>

char *notes_machine();

extern int errno;

int
read_notesfile()
{
	/** read in the current mailfile, assuming it's actually a set
	    of stored notes from the notes program... **/

	char buffer[LONG_STRING];
	register int line = 0, count = 0;
	long  bytes = 0L, line_bytes = 0L;
	static int first_read = 0;
	int count_x , count_y = 17;

	dprint0("read_notesfile()\n");

	if (! first_read++) {
	  MoveCursor(LINES-2, 0);
	  CleartoEOS();
	  PutLine(LINES-1, 0, "Reading in %s, message: 0", infile);
	  count_x = LINES-1;
          count_y = 22 + strlen(infile);
	}
	else {
	  PutLine(LINES-2, 0, "Reading message: 0");
	  count_x = LINES-2;
	}

	while (fgets(buffer, LONG_STRING, mailfile) != NULL) {

	  if (line == 0) {
	
	    /** Double check to make sure this is okay... if the first
	        word is "From " then we're actually reading a normal
	        file so cruise over to the read_headers() routine
		instead! **/
	
	    if (first_word(buffer, "From ")) {
	      notesfile = 0;   /* turn that bloody flag off! */
	      rewind(mailfile);  /* back up in da file... */
	      return( read_headers(FALSE) );
	    }
	  }
	
	  line_bytes = (long) strlen(buffer); 
	  line++;

	  if (first_word(buffer, "/***** ")) {
	    if (real_notes_header(buffer, &header_table[count])) {
	      header_table[count].offset = (long) bytes;
	      header_table[count].delete = 0;
	      header_table[count++].lines = line;
	      header_table[count].priority = 0;
	      PutLine(count_x, count_y, "%d", count);
	      if (count > 1)
	        header_table[count-2].lines = line -header_table[count-2].lines;
	    }
	  }
	  bytes += (long) line_bytes;
	}

	total_lines_in_file = line;
	header_table[count-1].lines = line - header_table[count-1].lines;

        rewind(mailfile);

	return(count);
}

int
real_notes_header(buffer, entry)
char *buffer;
struct header_rec *entry;
{
	/** confirms that we're looking at a REAL notes header,
	    and if so, saves it in the appropriate data entry  **/

	char subjectbuffer[SLEN], timebuffer[NLEN], lastbuffer[NLEN], 
	     am_pm[NLEN], the_day[NLEN], nullbuffer[NLEN];
	
	dprint1("real_notes_header(buffer='%s')\n", buffer);

	strcpy(nullbuffer, "NULL");
	strcpy(lastbuffer, "LAST");

	sscanf(buffer, "%*s %s %*c %s %*c %s %s %s %s %s %s", 
	    subjectbuffer, entry->from, 
	    timebuffer, am_pm, entry->month, the_day,
	    lastbuffer, nullbuffer);

	if (strcmp(lastbuffer, "LAST") == 0) 
	  return(0);
	
	if (strcmp(nullbuffer,"NULL") != 0) 
	  return(0);

	if (timebuffer[1] != ':' && timebuffer[2] != ':') 
	  return(0);

	/* now let's play format! */

	clean_up(subjectbuffer);

	sprintf(entry->subject, "Note from group %s", subjectbuffer);
	sprintf(entry->day,"%d", atoi(the_day));
	sprintf(entry->year,"%d", atoi(lastbuffer) % 100);
	sprintf(entry->time,"%s %s", timebuffer, am_pm);

	return(1);
}

char *notes_machine()
{
	/** For those rare notes posted by someone on the machine that
	    the notesfiles are saved from, this routine will fix the
	    address to ensure it's valid.  The return value will be
	    either 'machine!' or NULL if it's from the machine we're on
	**/

	static char machine_group[NLEN];
	char buffer[SLEN];
	register int i;

	dprint0("notes_machine()\n");
	
	if (fseek(mailfile, header_table[current-1].offset, 0L) != 0) {
	  error("error [notes_machine] trying to seek!");
	  dprint1("\n\tError %d trying to seek into file!\n\n", errno);
	  return( NULL );
	}

	if (fgets(buffer, SLEN, mailfile) == NULL) {
	  error("error [notes_machine] trying to read!");
	  dprint1("\n\tError %d trying to read file!\n\n", errno);
	  return( NULL );
	}

	sscanf(buffer,"%*s %s", machine_group);

	for (i=0; machine_group[i] != ':'; i++)
	   ;

	machine_group[i] = '\0';

	return( (char *) machine_group);
}
