/**			leavembox.c			**/

/** leave current mailbox, updating etc. as needed...
  
    (C) Copyright 1985, Dave Taylor
**/

#include "headers.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#define  ECHOIT 	1	/* echo on for prompting! */

/** added due to a bug in the 2.1 OS **/

struct utimbuf {
	time_t	actime;		/** access time **/
	time_t  modtime;	/** modification */
       };

extern int errno;

int
leave_mbox(quitting)
int quitting;
{
	/** Exit, saving files into mbox and deleting specified, or simply 
	    delete specified mail... If "quitting" is true, then output status 
            regardless of what happens.  Returns TRUE iff mailfile was
	    changed (ie messages deleted from file)
	**/

	FILE *temp;
	char outfile[SLEN], buffer[SLEN];
	struct stat buf;		/* stat command  */
	struct utimbuf times;		/* utime command */
	register int to_delete = 0, to_save = 0, i, mode = 00644,
		     pending = 0;

	dprint0("leave_mbox()\n");

	if (message_count == 0)
	  return(FALSE);	/* nothing changed */

	for (i = 0; i < message_count; i++)
	  if (header_table[i].delete) to_delete++;
	  else                        to_save++;

	dprint2("\t%d messages to delete and %d to save\n", to_delete, to_save);

	if (mbox_specified == 0) 
	  update_mailtime();

	if (to_delete)
	  if (to_save) {
	    sprintf(buffer, "Delete message%s? (y/n) ", to_save == 1? "" : "s");
	    if (want_to(buffer, 'n', ECHOIT) != 'y') {
	      if (mbox_specified == 0) unlock();	/* remove lock! */
	      dprint0("\tNothing deleted ('n' to delete messages)\n");
	      error("Nothing deleted");
	      return(FALSE);	/* nothing was deleted! */
	    }
	  }
	  else if (! to_save) 
	    if (want_to("Delete all messages? (y/n) ", 'n', ECHOIT) != 'y') {
	      if (mbox_specified == 0) unlock();	/* remove lock! */
	      dprint0("\tNothing deleted (don't want to delete all msgs)\n");
	      error("Nothing deleted");
	      return(FALSE);   /* nothing was deleted */
	    }
	  
	if (to_save && mbox_specified == 0) 
	  if (want_to("Keep mail in incoming mailbox? (y/n) ",'n',ECHOIT)=='y') 
	    if (to_delete)	/* okay - keep undeleted as pending! */
	      pending++;
	    else {		/* gag! nothing to delete, don't save!  */	
	      unlock();		/* remove mailfile lock!		*/
	      dprint0("\tIncoming mailbox unchanged (nothing to delete\n");
	      error("Mailbox unchanged");
	      return(FALSE);	/* nothing changed! */
	    }

	/** okay...now lets do it! **/

	if (to_save > 0) {
	  if (to_delete > 0)
	    sprintf(buffer ,"[%s %d message%s, and deleting %d]", 
	          pending? "keeping" : "storing", 
		  to_save, plural(to_save), to_delete);
	  else if (quitting)
	    sprintf(buffer,"[%s %s]",
	          pending? "keeping" : "storing",
		  to_save > 1? "all messages" : "message");
	  else
	    buffer[0] = '\0';	/* no string! */
	}
	else {
	  if (to_delete > 0)
	    sprintf(buffer, "[deleting all messages]");
	  else if (quitting)
	    sprintf(buffer, "[no messages to %s, and none to delete]",
	            pending? "keep" : "save");
	  else
	    buffer[0] = '\0';
	}

	error(buffer);

	if (! mbox_specified) {
	  if (pending) {                /* keep some messages pending! */
	    sprintf(outfile,"%s%d", temp_mbox, getpid());
	    unlink(outfile);
	  }
	  else if (mailbox_defined)	/* save to specified mailbox */
	    strcpy(outfile, mailbox);
	  else				/* save to $home/mbox */
	    sprintf(outfile,"%s/mbox", home);
	}
	else {
	  if (! to_delete) return(FALSE);	/* no work to do! */
          sprintf(outfile, "%s%d", temp_file, getpid());
	  unlink(outfile); /* ensure it's empty! */
	}

	if (to_save) {
	  if ((temp = fopen(outfile,"a")) == NULL) {
	    if (mbox_specified == 0)
	      unlock();		/* remove mailfile lock! */
	    dprint1("\tCould not append to file %s!\n", outfile);
	    sprintf(buffer, "           Could not append to file %s!          ",
		    outfile);
	    leave(Centerline(LINES-1, buffer));
	  }
  
	  for (i = 0; i < message_count; i++)
	    if (header_table[i].delete == 0) {
	      current = i+1;
	      dprint1("\tsaving message %d\n", current);
	      copy_message("", temp, FALSE);
	    }
	  fclose(temp);
	}

	/* remove source file...either default mailbox or original copy of 
           specified one! */

	if (mbox_specified == 0) {
	  /** let's grab the original mode and date/time of the mailfile 
	      before removing it **/

          if (stat(infile, &buf) == 0)
	    mode = buf.st_mode & 00777;
	  else {
	    dprint2("\tencountered error #%d on stat(%s)\n", errno, infile);
            error2("Error %d on stat(%s)!", errno, infile);
	  }
	}

	fclose(mailfile);	/* close the baby... */
	unlink(infile); 	/* and BLAMO!        */

	if (to_save && (mbox_specified || pending)) {
	  if (link(outfile, infile) != 0) 
	    if (errno == EXDEV) { /** different file devices!  Use copy! **/
	      if (copy(outfile, infile) != 0) {
	        dprint2("\tCouldn't modify mail file: copy(%s, %s) failed!\n",
			outfile, infile);
	        error("couldn't modify mail file!");
	        sleep(1);
	        sprintf(infile,"%s/%s", home, unedited_mail);
		if (copy(outfile, infile) != 0) {
	          dprint1("\tcouldn't copy to %s either!!  Help!\n", infile);
	          error("something godawful is happening to me!!!");
		  emergency_exit();
	        }
		else {
	          dprint1("\tsaved mailbox as file %s\n", infile);
	          error1("saved mailbox as %s", infile);
	        }
	      }	
	    }
	    else {
	      dprint3("\tlink(%s, %s) failed with error %d\n", outfile, 
		      infile, errno);
	      error1("link failed for unknown reasons [errno=%d!!", errno);
	      emergency_exit();
	    }
	  unlink(outfile);
	}

	if (mbox_specified == 0) {
	  if (mode != 00644) { /* if not the default mail access mode... */
	    if (! pending) { /* if none still being saved */
	      temp = fopen(infile, "w");
	      fclose(temp);
	    }
	    chmod(infile,mode);
	
	    /* let's set the access times of the new mail file to be
	       the same as the OLD one (still sitting in 'buf') ! */

	    times.actime = buf.st_atime;
	    times.modtime= buf.st_mtime;
	    if (utime(infile, &times) != 0) {
	      dprint2("\tencountered error %d on utime(%s)\n", 
		      errno, infile);
	      error1("Error %d trying utime", errno);
	    }
	  }
	  unlock();	/* remove the lock on the file ASAP! */

	  /** finally, let's change the ownership of the default
	      outgoing mailbox, if needed **/

	  if (to_save) {
	    dprint3("\tchown(%s, %d, %d)\n", outfile, userid, getgid());
	    chown(outfile, userid, getgid());
	  }
	}

	dprint3("\tchown(%s, %d, %d)\n", infile, userid, getgid());

	chown(infile, userid, getgid());	/* file owned by user */

	return(to_delete);	
}

char lock_name[SLEN];
extern int errno;	/* system error number! */

lock(direction)
int direction;
{
	/** Create lock file to ensure that we don't get any mail 
	    while altering the mailbox contents!
	    If it already exists sit and spin until 
               either the lock file is removed...indicating new mail
	    or
	       we have iterated MAX_ATTEMPTS times, in which case we
	       either fail or remove it and make our own (determined
	       by if REMOVE_AT_LAST is defined in header file

	    If direction == INCOMING then DON'T remove the lock file
	    on the way out!  (It'd mess up whatever created it!).
	**/

	register int iteration = 0, stat_val;
	struct stat buffer;

	dprint1("lock(direction=%s)\n", direction? "INCOMING" : "OUTGOING");

	sprintf(lock_name,"%s%s.lock", mailhome, username);

	stat_val = stat(lock_name, &buffer);

	while (stat_val != -1 && iteration++ < MAX_ATTEMPTS) {
	  dprint2("\tstat(%s) returned %d\n",
		   lock_name, stat_val);
	  if (direction == INCOMING)
	    fprintf(stderr,"Mail being received!\nwaiting...");
	  else
	    error2("Attempt %d: Mail being received (%d)...waiting", 
                   iteration, stat_val);
	  sleep(5);
	  stat_val = stat(lock_name, &buffer);
	}
	
	if (stat_val != -1) {
#ifdef REMOVE_AT_LAST
	  /** time to waste the lock file!  Must be there in error! **/
	  error("Throwing away the current lock file!");
	  dprint0("\tthrowing away current lock file!\n");
	  if (unlink(lock_name) != 0) {
	    dprint0("\tcouldn't unlink!!  Error was %d\n", errno);
	    leave(error("could not remove current lock file!"));
	  }
	  
	  /* everything is okay, so lets act as if nothing had happened... */
#else
	  /* okay...we die and leave, not updating the mailfile mbox or
	     any of those! */
	  if (direction == INCOMING) {
	    printf("Giving up after %d iterations...\n", iteration);
	    printf("Try again later, please.\n");
	    dprint1("\tbailing out after %d iterations...\n", iteration);
	    leave_locked();
	  }
	  else {
	    dprint1("\ttimed out on lock file reads.  Iterations=%d\n", 
	            iteration);
	    leave(error("Timed out on lock file reads.  Bye!"));
	  }
#endif
	}

	/* if we get here we can create the lock file, so lets do it! */

	if (creat(lock_name, 0) == -1) {
	  dprint2("\tCan't create lock file: creat(%s) raises error %d\n", 
		  lock_name, errno);
	  if (errno == EACCES)
	    leave(error(
                 "Can't create lock file!  Make sure I'm setuid root!\n\r"));
	  else
	    leave(error1("error %d attempting to create lock file!", errno));
	}

}

unlock()
{
	/** Remove the lock file!    This must be part of the interrupt
	    processing routine to ensure that the lock file is NEVER
	    left sitting in the mailhome directory! **/

	dprint0("unlock()\n");

	(void) unlink(lock_name);
}
