/**			fileio.c			**/

/** File I/O routines, including deletion from the mailbox! 

    (C) Copyright 1986 Dave Taylor
**/

#include "headers.h"
#include <ctype.h>

#ifdef BSD
#undef tolower
#endif

copy_message(prefix, dest_file, remove_header)
char *prefix;
FILE *dest_file;
int  remove_header;
{
	/** Copy current message to destination file, with optional 'prefix' 
	    as the prefix for each line.  If remove_header is true, it will 
	    skip lines in the message until it finds the end of header line...
            then it will start copying into the file... **/

    char buffer[LONG_SLEN];
    int ok = 1, lines, in_header = 1;

    dprint2("copy_message(prefix='%s', <file>, remove-header=%s)\n", prefix,
	    remove_header? "ON" : "OFF");

    /** get to the first line of the message desired **/

    if (fseek(mailfile, header_table[current-1].offset, 0) == -1) {
       error1("msg [seek] failed trying to read %d bytes into file",
	     header_table[current-1].offset);
       return;
    }

    /* how many lines in message? */

    lines = header_table[current-1].lines;

    dprint2("\tAbout to read %d lines from msg #%d\n",
	    lines, current);

    /* now while not EOF & still in message... copy it! */

    while (ok && lines--) {
      ok = (int) (fgets(buffer, LONG_SLEN, mailfile) != NULL);
      if (strlen(buffer) < 2) in_header = 0;
      if (ok) 
	if (! (remove_header && in_header))
	  fprintf(dest_file, "%s%s", prefix, buffer);
    }
}
