/**			file_utils.c			**/

/** File oriented utility routines for MSG 

    (C) Copyright 1986 Dave Taylor
**/

#include "headers.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>

#ifdef BSD
#undef tolower
#endif
#include <signal.h>
#include <errno.h>

long
bytes(name)
char *name;
{
	/** return the number of bytes in the specified file.  This
	    is to check to see if new mail has arrived....  **/

	int ok = 1;
	extern int errno;	/* system error number! */
	struct stat buffer;

	if (stat(name, &buffer) != 0)
	  if (errno != 2) {
	    dprint2("\n\n*** bytes() Error %d on fstat(%s)\n\n", errno, name);
	    leave(error2("Error %d attempting fstat on %s", errno, name));
	  }
	  else
	    ok = 0;
	
	return(ok ? (long) buffer.st_size : 0L);
}

int
can_access(file, mode)
char *file, *mode;
{
	/** returns TRUE iff user can access file **/

	int status, pid, w;
	register int (*istat)(), (*qstat)();
	
	if ((pid = fork()) == 0) {
	  setuid(userid);		/** back to normal userid **/
	  exit(fopen(file, mode) != NULL);
	  _exit(127);
	}

	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);

	while ((w = wait(&status)) != pid && w != -1)
		;

	if (w == -1) status = FALSE;
	
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);

	return(status);
}


int
copy(from, to)
char *from, *to;
{
	/** this routine copies a specified file to the destination
	    specified.  Non-zero return code indicates that something
	    dreadful happened! **/

	FILE *from_file, *to_file;
	char buffer[VERY_LONG_STRING];
	
	dprint2("copy(from='%s', to='%s')\n", from, to);

	if ((from_file = fopen(from, "r")) == NULL)
	  return(error1("could not open file %s", from));

	if ((to_file = fopen(to, "w")) == NULL)
	  return(error1("could not open file %s", to));

	while (fgets(buffer, VERY_LONG_STRING, from_file) != NULL)
	  fputs(buffer, to_file);

	fclose(from_file);
	fclose(to_file);

	return(0);
}

check_mailfile_size()
{
	/** Check to ensure we have mail.  Only used with the '-z'
	    starting option. **/

	char filename[SLEN], username[NLEN];
	struct stat buffer;

	strcpy(username,getlogin());
	if (strlen(username) == 0)
	  cuserid(username);

	sprintf(filename,"%s/%s", mailhome, username);

	if (stat(filename, &buffer) == -1) {
	  printf(" You have no mail.\n");
	  exit(0);
	}
	else if (buffer.st_size < 2) { 		/* maybe one byte??? */
	  printf("You have no mail to read.\n");
	  exit(0);
	}
}
