/**			syscall.c		**/

/** These routines are used for user-level system calls, including the
    '!' command and the '|' commands...

    (C) Copyright 1986 Dave Taylor
**/

#include "headers.h"

#include <signal.h>

char *argv_zero();	

int
subshell()
{
	/** spawn a subshell with either the specified command
	    returns non-zero if screen rewrite needed
	**/

	char command[SLEN];
	int  ret;

	PutLine(LINES-3,COLUMNS-40,"(use 'sh' or 'csh' for a shell)");
	PutLine(LINES-2,0,"Shell Command: ");
	command[0] = '\0';
	(void) optionally_enter(command, LINES-2, 15, FALSE);
	if (strlen(command) == 0) {
	  MoveCursor(LINES-2,0);	CleartoEOLN();
	  return(0);
	}

	MoveCursor(LINES,0); 	CleartoEOLN();
	Raw(OFF);
	if (cursor_control)  transmit_functions(OFF);
	
	ret = system_call(command, USER_SHELL);

	printf("\nPress <return> to return to MSG: ");
	Raw(ON);
	(void) getchar();
	if (cursor_control)  transmit_functions(ON);

	if (ret != 0) error1("Return code was %d", ret);
	return(1);
}

system_call(string, shell_type)
char *string;
int   shell_type;
{
	/** execute 'string', setting uid to userid... **/
	/** if shell-type is "SH" /bin/sh is used regardless of the 
	    users shell setting.  Otherwise, "USER_SHELL" is sent **/

	int status, pid, w;
	register int (*istat)(), (*qstat)();
	
	dprint2("system_call('%s', %s)\n", string, 
	         shell_type == SH? "SH" : "USER-SHELL");

	if ((pid = fork()) == 0) {
	  setuid(userid);	/* back to the normal user! */
	  if (strlen(shell) > 0 && shell_type == USER_SHELL) {
	    execl(shell, argv_zero(shell), "-c", string, 0);
	  }
	  else 
	    execl("/bin/sh", "sh", "-c", string, 0);
	  _exit(127);
	}

	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);

	while ((w = wait(&status)) != pid && w != -1)
		;

	if (w == -1) status = -1;
	
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);

	return(status);
}

int
pipe()
{
	/** pipe the current message to the specified sequence.. **/

	char command[SLEN], buffer[LONG_SLEN];
	int  ret, lines;

	PutLine(LINES-2,0,"Pipe current msg to: ");
	command[0] = '\0';
	(void) optionally_enter(command, LINES-2, 21, FALSE);
	if (strlen(command) == 0) {
	  MoveCursor(LINES-2,0);	CleartoEOLN();
	  return(0);
	}

	MoveCursor(LINES,0); 	CleartoEOLN();
	Raw(OFF);

	lines = header_table[current-1].lines;

	if (cursor_control)  transmit_functions(OFF);
	
	sprintf(buffer, "%s %s %d %d - | %s", cutfile, 
		infile, header_table[current-1].offset,
		lines, command);

	ret = system_call(buffer, USER_SHELL);

	printf("\nPress <return> to return to MSG: ");
	Raw(ON);
	(void) getchar();
	if (cursor_control)  transmit_functions(ON);

	if (ret != 0) error1("Return code was %d", ret);
	return(1);
}

printmsg()
{
	/** print specified message using 'printout' variable.  
	    Error message iff printout not defined! **/

	FILE *temp;
	char buffer[LONG_SLEN], filename[SLEN], printbuffer[LONG_SLEN];
	int  retcode;

	dprint1("printmsg()\n\tprintout = %s\n", printout);
	dprint1("\tcurrent message = %d\n", current);

	if (strlen(printout) == 0) {
	  error("PRINTMAIL not defined!  Don't know how to print message");
	  return;
	}
	
	if (current == 0) {
	  error("No mail to print!");
	  return;
	}

	sprintf(filename,"%s%d", temp_print, getpid());

	if ((temp = fopen(filename,"w")) == NULL) {
	  error1("Could not open file %s as a temporary file", filename);
	  return;
	}

	copy_message("", temp, FALSE);

	fclose(temp);

	if (in_string(printout, "%s"))
	  sprintf(printbuffer, printout, filename);
	else
	  sprintf(printbuffer, "%s %s", printout, filename);

        sprintf(buffer,"(%s 2>&1 ) > /dev/null",
		printbuffer, filename);

  	error("working...");

	if ((retcode = system_call(buffer, SH)) == 0)
	  error("Message queued up to print");
	else
	  error1("Printout failed with return code %d", retcode);

	unlink(filename);	/* remove da temp file! */
}
