/**			newmbox.c			**/

/**  read new mbox file 

     (C) Copyright 1986 Dave Taylor
**/

#include <ctype.h>

#ifdef BSD
#undef tolower
#endif

#include "headers.h"

#include <sys/types.h>
#include <sys/stat.h>
#ifdef BSD
#  include <sys/time.h>
#else
#  include <time.h>
#endif

int
newmbox(stat, resync)
int stat, resync;
{
	/** Read a new mailbox file or resync on current file.

	    Values of stat and what they mean;

		stat = 0	- changing mailboxes from within program
		stat = 1	- read default mailbox for the first time
	        stat = 2	- read existing mailbox, new mail arrived

	    resync is TRUE iff we know the current mailbox has changed.  If
	    it's set to true this means that we MUST READ SOMETHING, even 
	    if it's the current mailbox again!!
	**/

	int  switching_to_default = 0;
	char buff[SLEN];

	dprint2("newmbox(stat=%d, resync=%d)\n", stat, resync);

	dprint1("\tfile-changed = %s\n\n", onoff(file_changed));

	if (stat > 0) {
	  if (strlen(infile) == 0)	/* no filename yet?? */
	    sprintf(infile,"%s%s",mailhome, username);
	}
	else { 		 	/* get name of new mailbox! */
	  MoveCursor(LINES-3, 30);
	  CleartoEOS();
	  show_last_error();
	  if (mbox_specified != 2) {
	    PutLine(LINES-2,0,"Name of new mailbox: ");
	    buff[0] = '\0';
	    (void) optionally_enter(buff, LINES-2, 21, FALSE);
	    ClearLine(LINES-2);
	    if (strlen(buff) == 0) {
	      if (resync && file_changed)
	        strcpy(buff, infile);
	      else
	        return(FALSE);
	    }
	    if (strcmp(buff, infile) == 0 && ! resync) {
	      error("already reading that mailbox!");
	      return(FALSE);
	    }
	    if (first_word(buff, mailhome) && ! resync) {
	      mbox_specified = 0; 	  /* fake program to think that */
	      stat = 1;		    	  /*     we're the default file */
	      switching_to_default++;	  /*        remember this act!  */
	    }
	    else if (strcmp(buff, "!") == 0) {	/* go to mailbox */
	      sprintf(buff,"%s%s", mailhome, username);
	      if (! resync || (resync && ! file_changed)) {
	        if (strcmp(buff, infile) == 0) {	/* are we reading it? */
	          error("already reading your incoming mailbox!");
		  return(FALSE);
	        }
	      }
	      if (! resync || (resync && ! file_changed)) {
	        mbox_specified = 0; 	/* fake program to think that */
	        stat = 1;	  	/*     we're the default file */
	        switching_to_default++;	/*        remember this act!  */
	      }
	    }

	    if (! expand_filename(buff)) {
	      error1("cannot expand file %s", buff);
	      if (resync && file_changed)
	        strcpy(buff, infile);
	      else
	        return(FALSE);	
	    }

	    if (! can_access(buff,"r")) {
	      error1("cannot open file %s", buff);
	      if (resync && file_changed)
	        strcpy(buff, infile);
	      else
	        return(FALSE);	
	    }

	    if (resync && file_changed && strcmp(buff, infile) == 0)
	      PutLine(20,40,"Resynchronizing file");
	    else
	      PutLine(20,40,"Mailbox: %s", buff);
	    CleartoEOLN();
	    strcpy(infile,buff);
	    if (! switching_to_default) mbox_specified = 1;
	  }
	  else { /* starting filename given to routine */
	    if (! can_access(infile,"r")) 
	      exit(PutLine(LINES, 0, "Could not open file %s!\n", infile));
	    mbox_specified = 1;
	  }
	}

	clear_error();
	clear_central_message();

	if ((mailfile = fopen(infile,"r")) == NULL) 
	  message_count = 0;
	else if (stat < 2) {          /* new mail file! */
	  if (notesfile)
	    message_count = read_notesfile();	/* can't get new notes! */
	  else
	    message_count = read_headers(FALSE);
	}
	else 	/* resync with current mail file */
	  message_count = read_headers(TRUE);

	if (message_count && stat < 2) current = 1;

	header_page = 0;

	return(TRUE);
}

int
read_headers(stat)
int stat;
{
	/** Reads the headers into the header_table structure and leaves
	    the file rewound for further I/O requests.   If the file being
	    read is the default mailbox (ie incoming) then it is copied to
	    a temp file and closed, to allow more mail to arrive during 
	    the msg session.  If stat is set, the program will then copy
	    the delete flag from the previous data structure value to the
	    new one if possible.  This is for re-reading the mailfile!
	    Added: reads and formats the date from the first 'From' line
	**/

	FILE *temp;
	char buffer[LONG_STRING], temp_filename[SLEN];
	register int line = 0, count = 0, subj = 0, copyit = 0, in_header = 1;
	long bytes = 0L, line_bytes = 0L;
	static int first_read = 0; 
	int count_x, count_y = 17;

	dprint1("read_headers(stat=%d)\n", stat);

	if (! first_read++) {
	  MoveCursor(LINES-2, 0);
	  CleartoEOS();
	  PutLine(LINES-1, 0, "Reading in %s, message: 0", infile);
	  count_x = LINES-1;
          count_y = 22 + strlen(infile);
	}
	else {
	  PutLine(LINES-2, 0, "Reading message: 0");
	  count_x = LINES-2;
	}

	if (mbox_specified == 0) {
	  lock(INCOMING);	/* ensure no mail arrives while we do this! */
	  sprintf(temp_filename,"%s%s",temp_mbox, username);
	  if ((temp = fopen(temp_filename,"w")) == NULL) {
	    unlock();	/* remove lock file! */
	    Raw(OFF);
	    printf("Could not open file %s for writing (uid=%d)...\n",
	           temp_filename, getuid());
	    system_call("/bin/ls -l /tmp/*", SH);
	    leave(error1("could not open file %s for writing!",
	          temp_filename));
	  }
	  get_mailtime();
	  copyit++;
	  chown(temp_filename, userid, getgid());
	}

	while (fgets(buffer, LONG_STRING, mailfile) != NULL) {
	  if (line == 0) { 	/* first line of file... */	

	    if (! mbox_specified) {
	      if (first_word(buffer, "Forward to ")) 
	        set_central_message("Mail being forwarded to %s", 
                   (char *) (buffer + 11));
	    }

	    /* Are we reading in a notesfile file without the flag
	       turned on??? */
	
	    if (first_word(buffer, NOTES_HEADER)) {	/* if so...  */
	      rewind(mailfile);
	      notesfile++;		    /* set da flag, boss-man */
	      return(read_notesfile()); 	/* hop over to notes */
	    }
	  }

	  if (copyit) fputs(buffer, temp);
	  line_bytes = (long) strlen(buffer); 
	  line++;
	  if (first_word(buffer,"From ")) {
	    if (real_from(buffer, &header_table[count])) {
	      header_table[count].offset = (long) bytes;
	      if (! stat || count > message_count) 
	        header_table[count].delete = 0;		/* clear flag! */
	      strcpy(header_table[count].subject, "");	/* clear subj  */
	      header_table[count++].lines = line;
	      header_table[count].priority = 0;
	      subj = 0;
	      in_header = 1;
	      PutLine(count_x, count_y, "%d", count);
	      if (count > 1)
	        header_table[count-2].lines = header_table[count-1].lines - 
					      header_table[count-2].lines;
	    }
	  }
	  else if (in_header) {
	    if (first_word(buffer,">From")) 
	      forwarded(buffer, &header_table[count-1]); /* return address */
	    else if (first_word(buffer,"Subject:") ||
		     first_word(buffer,"Subj:") ||
		     first_word(buffer,"Re:")) {
	      if (! subj++) {
	        remove_first_word(buffer);
	        strncpy(header_table[count-1].subject, buffer, SLEN);
	      }
	    }
	    else if (first_word(buffer,"From:"))
	      parse_arpa_from(buffer, header_table[count-1].from);
	    else if (first_word(buffer, "Date:")) 
	      parse_arpa_date(buffer, &header_table[count-1]);
	    else if (first_word(buffer, "Priority:"))
	      header_table[count-1].priority++;
	    else if (buffer[0] == LINE_FEED || buffer[0] == '\0') {
	      if (in_header) {
	        in_header = 0;	/* in body of message! */
	        fix_date(&header_table[count-1]);
	      }
	    }
	  }
	  bytes += (long) line_bytes;
	}

	total_lines_in_file = line;
	header_table[count-1].lines = line - header_table[count-1].lines + 1;

	if (mbox_specified == 0) {
	  unlock();	/* remove lock file! */
	  fclose(mailfile);
	  fclose(temp);
	  if ((mailfile = fopen(temp_filename,"r")) == NULL) {
	    MoveCursor(LINES,0);
	    Raw(OFF);
	    printf("Fatal error: could not reopen %s as temp mail file!\n",
	           temp_filename);
	    leave();
	  }
	}
	else 
          rewind(mailfile);

	return(count);
}
