/**			msg.c			**/

/* main program of the MSG mail system! 

   This file and all associated files and documentation:
	(C) Copyright 1986 Dave Taylor
*/

#include "msg.h"

main(argc, argv)
int argc;
char *argv[];
{
	char ch, address[SLEN], to_whom[LONG_SLEN];
	int  redraw, /** do we need to rewrite the entire screen? **/
	     nuhead, /** or perhaps just the headers section...   **/
	     nucurr, /** or just the current message pointer...   **/
	     nufoot; /** clear lines 16 thru bottom and new menu  **/
	int  i, size;/** number of bytes in file.  Only mailbox!  **/
	int  pageon; /** for when we receive new mail...          **/

	parse_arguments(argc, argv, to_whom);

	if (mail_only) {

	   initialize();

	   Raw(ON);
	   dprint1("\n\n\tmail-only: mailing to %s\n\n", to_whom);
	   (void) send(to_whom, "", TRUE); 
	   leave(0);
	}

	InitScreen();

	ScreenSize(&LINES, &COLUMNS);

	initialize();
	
	showscreen();

	size = bytes(infile);

	dprint1("\tStarting mailbox size = %d bytes\n", size);

	Raw(ON);
	while (1) {
	  redraw = 0;
	  nuhead = 0;
	  nufoot = 0;
	  nucurr = 0;
	  if ((i = bytes(infile)) != size) {
	    if (debug) 
	      error1("New mail in this file: %d bytes more", i - size);
	    else
	      error("New mail has arrived!   Hang on...");
	    dprint1("\tnew mail in mailbox: %d bytes\n", i - size);
	    pageon = header_page;
	    newmbox(2, FALSE);
	    clear_error();
	    header_page = pageon;
	    showscreen();
	    size = i;
	    transmit_functions(ON);	/* insurance */
	  }

	  prompt("Mail :");

	  CleartoEOLN();
	  ch = tolower(ReadCh()); 
	  CleartoEOS();
	  set_error("");	/* clear error buffer */
	  MoveCursor(LINES-3,COLUMNS-74);

	  dprint1("\n\nEntered command: %c\n\n\n", ch);

	  switch (ch) {

	    case '?' 	:  redraw = help();	        break;

	    case ' '    : 
	    case '+'	:  header_page++; nuhead++;	
			   if (move_when_paged)
			     current = header_page*headers_per_page + 1;
			   break;

	    case '-'    :  header_page--; nuhead++;	
			   if (move_when_paged)
			     current = header_page*headers_per_page + 1;
			   break;

	    case '='    :  if (current != 1) {
			     current = 1;
	                     if (get_page(current))
			       nuhead++;	
			     else
			       nucurr++;
			   }				break;

	    case '*'    :  if (current != message_count) {
			     current = message_count;	
	                     if (get_page(current))
			       nuhead++;	
			     else
			       nucurr++;
			   }				break;

	    case '|'    :  putchar('|'); 
	    		   softkeys_off();
                           redraw = pipe();		
	                   softkeys_on(); 		break;

	    case '!'    :  putchar('!'); 
	    		   softkeys_off();
                           redraw = subshell();		
	                   softkeys_on(); 		break;

	    case '%'    :  get_return(address);
			   clear_error();
			   MoveCursor(LINES,(COLUMNS-strlen(address))/2);
			   printf("%.78s", address);	break;
	    case '/'    :  if (pattern_match()) {
	                      if (get_page(current))
			        nuhead++;
	                      else
	                        nucurr++;
	                   }
			   else
			      error("pattern not found!");
			   break;

	    case 'a'    :  alias();     
			   nufoot++; 	
			   define_softkeys(MAIN); 	break;
			
	    case 'c'    :  printf("Change mailbox");
			   define_softkeys(CHANGE);
			   file_changed = leave_mbox(FALSE);
			   dprint1("\tleave_mbox returned %s\n",
				   file_changed? "TRUE": "FALSE");
	                   redraw = newmbox(0, TRUE);
			   size = bytes(infile);	
			   define_softkeys(MAIN);
			   break;

	    case '^'    :
 	    case 'd'    :  delete((ch == 'd'));			
			   if (resolve_mode) 	/* move after mail resolved */
			     if (current < message_count) {
	                       current++;  		
			       if (get_page(current))
			         nuhead++;
			       else
			         nucurr++;
			     }
			   break;

	    case 'f'    :  printf("Forward");
			   define_softkeys(YESNO);
			   if (current > 0)  
	                     redraw = forward();   
			   else
	                     error("No mail to forward!");
			   define_softkeys(MAIN);
			   break;

	    case 'g'    :  printf("Group reply");
			   define_softkeys(YESNO);
		           fflush(stdout);
			   if (current > 0) {
			     PutLine(LINES-3,COLUMNS-40,
                                     "building addresses...");
	                     redraw = reply_to_everyone();	
	                   }
			   else
			     error("No mail to reply to!"); 
			   define_softkeys(MAIN);
			   break;

	    case 'h'    :  if (filter)
	                     printf("Message with headers...");
	                   else
			     printf("Next message");
			   fflush(stdout);
			   i = filter;
			   filter = FALSE;
			   redraw = show_msg(current);
			   filter = i;
			   break;

	    case 'm'    :  printf("Mail");
			   redraw = send("", "", TRUE); 
			   break;

	    case ctrl('J'):
	    case ctrl('M'):printf("Read Message");	fflush(stdout);
			   define_softkeys(READ);
			   redraw = show_msg(current);
			   break;

	    case 'n'    :  printf("Next Message");
			   fflush(stdout);
			   define_softkeys(READ);
			   redraw = show_msg(current);  
			   current += redraw;		
			   (void) get_page(current); /* rewrites ANYway */
			   if (current > message_count)
			     current = message_count;
			   break;

	    case 'j'    :  current++;  
			   if (get_page(current))
			     nuhead++;
			   else
			     nucurr++;			break;

	    case 'k'    :  current--;  
			   if (get_page(current))
			     nuhead++;
			   else
			     nucurr++;			break;

	    case 'p'    :  printf("Print message");
			   fflush(stdout);
			   printmsg();			break;

	    case 'r'    :  printf("Reply to message");
			   if (current > 0) 
	                     redraw = reply();	
			   else
			     error("No mail to reply to!"); break;

	    case '>'    : /** backwards compatibility **/

	    case 's'    :  printf("Save Message"); 
			   if (save() && resolve_mode) {
			     delete(TRUE);		/* mark for deletion */
			     if (current < message_count) {
			       current++;	/* move to next message */
			       if (get_page(current))
			         nuhead++;
			       else
			         nucurr++;		
			     }
			   }
			   ClearLine(LINES-2);		break;

	    case 't'    :  error1("%s",(char *) get_date());break;

	    case 'q'    :  printf("Quit");  fflush(stdout);
			   if (mbox_specified == 0) {
			     lock(OUTGOING);
			     if (size != bytes(infile)) {
			       error("New Mail!  Quit cancelled...");
	                       unlock();
	                     }
		             else
			       quit();		
			   }
		           else 
			     quit();
			   break;
	    case 'u'    :  undelete();		        
			   if (resolve_mode) 	/* move after mail resolved */
			     if (current < message_count) {
	                       current++;  		
			       if (get_page(current))
			         nuhead++;
			       else
			         nucurr++;
			     }
			   break;

	    case ctrl('Q') :
	    case ctrl('Z') : /* exit fast! */
	    case ctrl('?') : 
	    case 'x'    :  printf("Exit");  
                           fflush(stdout);              leave();

	    case ctrl('L') : redraw++;	break;
	    
	    case '@'    : debug_screen();  redraw++;	break;
	
	    case '#'    : debug_message(); redraw++;	break;

	    case ESCAPE : if (cursor_control) {
			    ch = ReadCh(); 
	                    if (ch == up[1]) {
			      current--;
			      if (get_page(current))
			        nuhead++;
			      else
			        nucurr++;			
	                    }
			    else if (ch == down[1]) {
			      current++;
			      if (get_page(current))
			        nuhead++;
			      else
			        nucurr++;			
			    }
			    else if (hp_terminal) {	/* kludge! */
			      if (ch == 'U') {	/* <NEXT> */
	    			header_page++; 
				nuhead++;
			        if (move_when_paged)
			          current = header_page*headers_per_page + 1;
			      }
			      else if (ch == 'V') {  /* <PREV> */
	    			header_page--; 
				nuhead++;
			        if (move_when_paged)
			          current = header_page*headers_per_page + 1;
			      }
			      else if (ch == 'h') {  /* <HOME UP> */
			        current = 1;
	                        if (get_page(current))
			          nuhead++;
	                        else
	                          nucurr++;
			      }
			      else if (ch == 'F') {  /* <HOME DOWN> */
			        current = message_count;
	                        if (get_page(current))
			          nuhead++;
	                        else
	                          nucurr++;
			      }
			      else /* what DID they hit??? */
				 printf("%c%c", ESCAPE, ch);
			    }
			    else /* false hit - output */
			      printf("%c%c", ESCAPE, ch);
			    break;
			  }
				/* else fall into default.. */

	    default	: if (ch > '0' && ch <= '9') {
			    printf("New Current Message");
			    current = read_number(ch, message_count);
	                    if (get_page(current))
			      nuhead++;
	                    else
	                      nucurr++;
			  }
			  else
	 		    error("Unknown command: Use '?' for commands");
	  }
	  if (redraw)
	    showscreen();

	  if (current < 1) {
	    if (message_count > 0) {
	      error("already at message #1!");
	      current = 1;
	    }
	    else if (current < 0) {
	      error("No messages to read!");
	      current = 0;
	    }
	  }
	  else if (current > message_count) {
	    if (message_count > 0) {
	      error2("only %d message%s!", message_count, 
		     plural(message_count));
	      current = message_count;
	    }
	    else {
	      error("No messages to read!");
	      current = 0;
	    }
	  }

	  if (nuhead) 
	    show_headers();
	  else if (nucurr)
	    show_current();
	  else if (nufoot) {
	    MoveCursor(LINES-7, 0);  
            CleartoEOS();
	    if (mini_menu)
	      show_menu();
	  }

	} /* the BIG while loop! */
}


debug_screen()
{
	/**** spit out all the current variable settings and the table
	      entries for the current 'n' items displayed. ****/

	register int i, j;

	ClearScreen();
	Raw(OFF);

	printf("Current message number = %d\t\t%d message(s) total\n\n",
	        current, message_count);
	printf("Header_page = %d           \t\t%d possible page(s)\n",
		header_page, (int) (message_count / headers_per_page) + 1);

	printf("\nCurrent mailfile is %s.\n\n", infile);

	i = header_page*headers_per_page;	/* starting header */

	if ((j = i + (headers_per_page-1)) >= message_count) 
	  j = message_count-1;

	printf(
"Num      From                 	Subject                         Lines  Offset\n\n");

	while (i <= j) {
	   printf(
	   "%3d  %-16.16s  %-40.40s  %4d  %d\n",
		    i+1,
	            header_table[i].from, 
	            header_table[i].subject,
		    header_table[i].lines,
		    header_table[i].offset);
	  i++;
	}
	
	Raw(ON);

	PutLine(LINES,0,"Press any key to return: ");
	(void) ReadCh();
}


debug_message()
{
	/**** Spit out the current message record.  Include EVERYTHING
	      in the record structure. **/

	ClearScreen();
	Raw(OFF);

	printf("\t\t\t----- Message %d -----\n\n\n\n", 
		current);

	printf("Lines : %-5d\t\t\t\tPriority message? %s\n\n",
		header_table[current-1].lines, 
		header_table[current-1].priority? "YES" : "NO");

	printf("Offset: %ld\t\t\t\t  Delete message? %s\n\n\n",
		header_table[current-1].offset,
		header_table[current-1].delete? "YES" : "NO");

	printf("Received on: %d/%d/%d at %d:%02d\n\n",
	        header_table[current-1].received.month+1,
	        header_table[current-1].received.day,
	        header_table[current-1].received.year,
	        header_table[current-1].received.hour,
	        header_table[current-1].received.minute);

	printf("Msg sent on: %s, %s %s, %s at %s\n\n",
	        header_table[current-1].dayname,
	        header_table[current-1].month,
	        header_table[current-1].day,
	        header_table[current-1].year,
	        header_table[current-1].time);
	
	printf("\nFrom: %s\n\nSubject: %s",
		header_table[current-1].from,
	        header_table[current-1].subject);
	
	Raw(ON);

	PutLine(LINES,0,"Press any key to return: ");
	(void) ReadCh();
}
