/**		delete.c		**/

/**  Delete or undelete files: just set flag in header record! 

     (C) Copyright 1985  Dave Taylor
**/

#include "headers.h"

delete(real_del)
int real_del;
{
	/** Delete current message.  If real-del is false, then we're
	    actually requested to toggle the state of the current
	    message... **/

	dprint1("delete(real_del=%s)\n", real_del? "ON" : "OFF");

	if (real_del)
	  header_table[current-1].delete = 1;
	else
	  header_table[current-1].delete = ! header_table[current-1].delete;

	show_msg_status(current-1);
}

undelete()
{
	/** clear the deleted message flag **/

	dprint0("undelete()\n");

	header_table[current-1].delete = 0;

	show_msg_status(current-1);
}

show_delete_flags()
{
	/** display page of headers (10) if present.  First check to 
	    ensure that header_page is in bounds, fixing silently if not **/

	register int first = 0, last = 0, line = 4;

	dprint0("show_delete_flags()\n");

	(void) fix_header_page();

	/** compute last header to display **/

	first = header_page*headers_per_page;
	last  = first + (headers_per_page - 1);

	if (last > message_count) 
	  last = message_count;

	/** okay, now let's show the stuff **/

	while (first <= last) {
	  MoveCursor(line++,7);
	  if (header_table[first].delete) putchar('*');
 	  else				  putchar(' ');
	  first++;
	}
}

show_msg_status(msg)
int msg;
{
	/** show the status of the current message only.  **/

	register int line;

	dprint1("show_msg_status(msg=%d)\n", msg);

	line = (msg % headers_per_page) + 4;

	MoveCursor(line,7);
	putchar( header_table[msg].delete? '*' : ' ');
}
