
/**			args.c			**/

/** starting argument parsing routines for MSG system...

    (C) Copyright 1986 Dave Taylor
**/

#include "headers.h"

#define DONE		0
#define ERROR		-1

char *optional_arg;			/* optional argument as we go */
int   opt_index;			/* argnum + 1 when we leave   */

parse_arguments(argc, argv, to_whom)
int argc;
char *argv[], *to_whom;
{
	/** set flags according to what was given to program.  If we are 
	    fed a name or series of names, put them into the 'to_whom' buffer
	    and set "mail_only" to TRUE **/

	register char c = 0;

	infile[0] = '\0';
	to_whom[0] = '\0';
	batch_subject[0] = '\0';

	while ((c = get_options(argc, argv, "?cdf:hkmsS:z")) > 0) {
	   switch (c) {
	     case 'c' : check_only++;		break;
	     case 'd' : debug++;		break;
	     case 'f' : strcpy(infile, optional_arg); 
	                mbox_specified = 2;  break;
	     case '?' :
	     case 'h' : args_help();
	     case 'k' : hp_terminal++;	break;
	     case 'm' : mini_menu = 0;	break;
	     case 's' : hp_softkeys++;	break;
	     case 'S' : strcpy(batch_subject, optional_arg);	break;
	     case 'z' : check_mailfile_size(); break;
	    }
	 }

	 if (c == ERROR) {
	   printf("Usage: msg [cdhkmsz] [-f file] [-S subject] <names>\n\n");
	   args_help();
	}

	 if (opt_index < argc) 
	   while (opt_index < argc) {
	     sprintf(to_whom, "%s%s%s", to_whom, 
		    to_whom[0] != '\0'? " " : "", argv[opt_index]);
	     mail_only++;
	     opt_index++;
	   }

	 if (strlen(batch_subject) > 0 && ! mail_only) 
	   exit(printf(
     "\n\rDon't understand specifying a subject and no-one to send to!\n\r"));

	if (! isatty(fileno(stdin)) && strlen(batch_subject) == 0)
	  strcpy(batch_subject, DEFAULT_BATCH_SUBJECT);
		
}

args_help()
{
	/**  print out possible starting arguments... **/

	printf("\nPossible Starting Arguments for MSG program:\n\n");
	printf("\targ\t\t\tMeaning\n");
	printf("\t -c \t\tCheckalias - check the given aliases only\n");
	printf("\t -d \t\tDebug - turn on debug mode (output to file)\n");
	printf("\t -f \t\tFile - read file (specified) rather than mailbox\n");
	printf("\t -h \t\tHelp - give this list of options\n");
	printf("\t -k \t\tKeypad - force knowledge of HP terminal keyboard\n");
	printf("\t -m \t\tMenu - Turn off menu, using more of the screen\n");
	printf("\t -s \t\tSoftkeys - enable use of softkeys\n");
	printf("\t -z \t\tZero - don't enter MSG if no mail is pending\n");
	printf("\n");
	printf("\t -S \t\tSubject - for batchmailing, combined with address\n");
	printf("\n");
	exit(1);
}

int  _indx = 1, _argnum = 1;

int
get_options(argc, argv, options)
int argc;
char *argv[], *options;
{
	/** Returns the character argument next, and optionally instantiates 
	    "argument" to the argument associated with the particular option 
	**/
	
	char       *word, *strchr();

	if (_indx >= strlen(argv[_argnum])) {
	  _argnum++;
	  _indx = 1;		/* zeroeth char is '-' */
	}

	if (_argnum >= argc) {
	  opt_index = argc;
	  return(DONE);
	}
	
	if (argv[_argnum][0] != '-') {
	  opt_index = _argnum;
	  return(DONE);
	}

        word = strchr(options, argv[_argnum][_indx++]);

	if (strlen(word) == 0) 
	  return(ERROR);
	
	if (word[1] == ':') {

	  /** Two possibilities - either tailing end of this argument or the 
	      next argument in the list **/

	  if (_indx < strlen(argv[_argnum])) { /* first possibility */
	    optional_arg = (char *) (argv[_argnum] + _indx);
	    _argnum++;
	    _indx = 1;
	  }
	  else {				/* second choice     */
	    if (++_argnum >= argc) 
	      return(ERROR);			/* no argument!!     */

	    optional_arg = (char *) argv[_argnum++];
	    _indx = 1;
	  }
	}

	return((int) word[0]);
}
