/**			aliasdb.c			**/

/** Alias database files...

    (C) Copyright 1986 Dave Taylor
**/


#include "headers.h"

#include <sys/types.h>
#include <sys/stat.h>

char *shift_lower();

findnode(name, display_error)
char *name;
int   display_error;
{
	/** break 'name' into machine!user or user@machine and then
	    see if you can find 'machine' in the path database..
	    If so, return name as the expanded address.  If not,
	    return what was given to us!   If display_error, then
	    do so...
	**/

	char   address[SLEN];
	
	dprint2("findnode(name='%s', display_error=%s)\n", 
		 name, display_error? "ON" : "OFF");

	if (strlen(name) == 0)
	  return;
	
	if (expand_site(name, address) == -1) {
	  if (display_error && name[0] != '!') {
	    error1("Warning: couldn't expand %s...", name);
	    sleep(1);
	  }
	}
	else
	  strcpy(name, address);
	
	return;
}

int
expand_site(cryptic, expanded)
char *cryptic, *expanded;
{

	/** Given an address of the form 'xyz@site' or 'site!xyz'
	    return an address of the form <expanded address for site>
            with 'xyz' embedded according to the path database entry.
	    Note that 'xyz' can be eiher a simple address (as in "joe")
	    or a complex address (as in "joe%xerox.parc@Xerox.ARPA")!
	    0 = found, -1 return means unknown site code **/

	char   name[VERY_LONG_STRING], sitename[VERY_LONG_STRING], 
               address[VERY_LONG_STRING], temp[VERY_LONG_STRING];
	register int i = 0, j = 0, domain_name;

	dprint1("expand_site(cryptic='%s', <expanded>)\n", cryptic);

	/** break down **/

	while (cryptic[i] != '@' && cryptic[i] != '!' && cryptic[i] != '\0')
	  sitename[j++] = cryptic[i++];

	sitename[j++] = '\0';

	j = 0;
	
	if (cryptic[i] == '\0') return(-1);	/* nothing to expand! */

	domain_name = (cryptic[i] == '@');

	i++;

	while (cryptic[i] != '\0')
	  name[j++] = cryptic[i++];

	name[j] = '\0';

	if (domain_name) {
	  strcpy(temp, name);
	  strcpy(name, sitename);
	  strcpy(sitename, temp);
	}

	if (talk_to(sitename)) {
	  sprintf(expanded,"%s!%s", sitename, name);
	  return(0);
	}

	if (size_of_pathfd > 0) {
          if (binary_search(sitename, address) == -1)
	    return(-1);
	}
	else {
	  sprintf(expanded,"%s!%s", sitename, name);
	  return(0);
	}

	/* otherwise... */

	sprintf(expanded, address, name);
	return(0);
}

int
binary_search(name, address)
char *name, *address;
{
	/* binary search file for name.  Return 0 if found, -1 if not */

	char machine[20];
	register long first = 0, last, middle;
	register int  compare;

	dprint1("binary_search(name='%s', <address>)\n", name);

	address[0] = '\0';

	last = size_of_pathfd;

	do {

	  middle = (long) ((first+last) / 2);

	  get_entry(machine, address, pathfd, middle);

	  compare = strcmp(name, machine);

	  if (compare < 0) 
	    last = middle - 1;
	  else if (compare == 0) 
	    return(0);
	  else  /* greater */
	    first = middle + 1; 
	} while (abs(last) - abs(first) > FIND_DELTA);

	return(-1);
}

get_entry(machine, address, fileid, offset)
char *machine, *address;
FILE *fileid;
long offset;
{
	/** get entry...return machine and address immediately
	    following given offset in fileid.  **/

	fseek(fileid, offset, 0L);

	/* read until we hit an end-of-line */

	while (getc(fileid) != '\n')
	   ;

	fscanf(fileid, "%s\t%s", machine, address);
}

init_findnode()
{
	/** Initialize the FILE and 'size_of_file' values for the 
	    findnode procedure **/

	struct stat buffer;

	dprint0("init_findnode()\n");

	if (stat(pathfile, &buffer) == -1) {
	  dprint1("\tWarning: No pathalias file '%s' found!\n", pathfile);
	  size_of_pathfd = 0;
	  return;
	}

	size_of_pathfd = buffer.st_size;

	if ((pathfd = fopen(pathfile,"r")) == NULL) {
	  dprint1("\tFound pathalias file '%s' but couldn't open to read\n",
		  pathfile);
	  size_of_pathfd = 0;
	}
	else
	  dprint1("\tOpened file '%s' as path alias database\n", pathfile);
}
