/**		defs.h			**/

/**  define file for msg mail system.  **/

/**  (C) Copyright 1985 Dave Taylor    **/

#include "sysdefs.h"	/* system/configurable defines */

#define VERSION		"3.2"	/* version number! */

#define SLEN		256	/* long for ensuring no overwrites... */
#define SHORT		5	/* super short strings!		      */
#define NLEN		20	/* name length for aliases            */
#define SHORT_SLEN      40
#define LONG_SLEN	250	/* for mail addresses from remote machines! */
#define LONG_STRING	500	/* even longer string for group expansion   */
#define VERY_LONG_STRING 2500	/* huge string for group alias expansion    */

#define BREAK		(char)  0	/* default interrupt    */
#define BACKSPACE	(char)  8	/* backspace character  */
#define TAB		(char)  9       /* tab character        */
#define RETURN		(char) 13	/* carriage return char */
#define LINE_FEED	(char) 10	/* line feed character  */
#define COMMA		','		/* comma character      */
#define SPACE		' '		/* space character      */
#define DOT		'.'		/* period/dot character */
#define BANG		'!'		/* exclaimation mark!   */
#define AT_SIGN		'@'		/* at-sign character    */
#define PERCENT		'%'		/* percent sign char.   */
#define ESCAPE		(char) 27	/* the escape		*/

#define STANDARD_INPUT  0		/* file number of stdin */

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

#define OUTGOING	0		/* defines for lock file   */
#define INCOMING	1		/* creation..see lock()    */

#define SH		0		/* defines for system_call */
#define USER_SHELL	1		/* to work correctly!      */

#define EXECUTE_ACCESS	01		/* for access() call 	   */
#define ACCESS_EXISTS	00		/* for access(2)           */

#define BIG_NUM		999999		/* big number!             */
#define BIGGER_NUM	9999999 	/* bigger number!          */

#define START_ENCODE	"[encode]"
#define END_ENCODE	"[clear]"

#define DONT_SAVE	"[no save]"

#define alias_file	".aliases"
#define group_file	".groups"
#define system_file	".systems"

#define JANUARY		0			/* months of the year */
#define FEBRUARY	1
#define MARCH		2
#define APRIL		3
#define MAY		4
#define JUNE		5
#define JULY		6
#define AUGUST		7
#define SEPTEMBER	8
#define OCTOBER		9
#define NOVEMBER	10
#define DECEMBER	11

#define equal(s,w)	(strcmp(s,w) == 0)
#define min(a,b)	a < b? a : b
#define ctrl(c)	        c - 'A' + 1	/* control character mapping */
#define plural(n)	n == 1 ? "" : "s"
#define lastch(s)	s[strlen(s)-1]
#define no_ret(s)	if (lastch(s) == '\n') lastch(s) = '\0' 
#define first_word(s,w) (strncmp(s,w, strlen(w)) == 0)
#define ClearLine(n)	MoveCursor(n,0); CleartoEOLN()
#define whitespace(c)	(c == ' ' || c == '\t')
#define quote(c)	(c == '"' || c == '\'') 
#define onoff(n)	(n == 0 ? "OFF" : "ON")

/** a few for the usage of function keys... **/

#define f1	1
#define f2	2
#define f3	3
#define f4	4
#define f5	5
#define f6	6
#define f7	7
#define f8	8

#define MAIN	0
#define ALIAS   1
#define YESNO	2
#define CHANGE  3
#define READ	4

/* wouldn't it be nice to have variable argument macros... */

#define dprint0(s)	     if (debug) { \
				fprintf(debugfile, s); fflush(debugfile); }
#define dprint1(s,a)	     if (debug) { \
				fprintf(debugfile, s, a);  fflush(debugfile); }
#define dprint2(s,a,b)	     if (debug) { \
			        fprintf(debugfile, s, a, b); fflush(debugfile);}
#define dprint3(s,a,b,c)     if (debug) { fprintf(debugfile, \
				s, a, b, c); fflush(debugfile); }
#define dprint4(s,a,b,c,d)   if (debug) { fprintf(debugfile, \
				s, a, b, c, d); fflush(debugfile); }
#define dprint5(s,a,b,c,d,e) if (debug) { fprintf(debugfile, \
			        s, a, b, c, d, e); fflush(debugfile); }

#define dprint6(s,a,b,c,d,e,f) if (debug) { fprintf(debugfile, \
			        s, a, b, c, d, e, f); fflush(debugfile); }

/* I guess this corrects it, though.  Wretched stuff though! */

struct date_rec {
	int  month;		/** this record stores a **/
	int  day;		/**   specific date and  **/
	int  year;		/**     time...		 **/
	int  hour;
	int  minute;
       };

struct header_rec {
	int  lines;		/** # of lines in the message  **/
	int  priority;		/** Urgent message?  (flag)    **/
	int  delete;		/** is message to be deleted?  **/
	long offset;		/** offset in bytes of message **/
	struct date_rec received; /** when msg received here   **/
	char from[SLEN];	/**   when 		       **/
	char dayname[8];	/**      the                   **/
	char month[10];		/**        message             **/
	char day[3];		/**          was 	       **/
	char year[5];		/**            sent            **/
	char time[NLEN];	/**              to you!       **/
	char subject[SLEN];    	/** The subject of the msg     **/
       };

struct alias_rec {
	char   name[NLEN];	/* alias name 			     */
	long   byte;		/* offset into data file for address */
       };

struct lsys_rec {
	char   name[NLEN];	/* name of machine connected to      */
	struct lsys_rec *next;	/* linked list pointer to next       */
       };

struct addr_rec {
	 char   address[NLEN];	/* machine!user you get mail as      */
	 struct addr_rec *next;	/* linked list pointer to next       */
	};
