/**			readmsg.c			**/

/** This is a quick and dirty way to read the specified message (or
    messages) from the incoming mailbox.  This does no parsing of the
    header fields other than to simply find where each message starts,
    and has no options other than to 'q' or '<return>' at then end of 
    each page of the message.

    (C) Copyright 1985, Dave Taylor

**/

#include <stdio.h>

#define  mailhome	"/usr/mail"
#define  SLEN		100
#define  MAX_LIST	25

main(argc, argv)
int argc;
char *argv[];
{
	FILE *file;
	int read_message[MAX_LIST], filename[SLEN], buffer[SLEN];
	int messages = 1, current_in_queue = 0, current = 0, num, total;

	if (argc > MAX_LIST) {
	  printf("Can't have more than %d messages specified!\n", MAX_LIST);
	  exit(1);
	}

	*argv++;

	if (argc == 1)
	  read_message[0] = 0;
	else 
	  while (--argc > 0) {
	    num = -1;
	    sscanf(*argv,"%d", &num);
	    if (num < 0) {
	      if (strcmp(*argv,"$") == 0)
	        num = 0;
	      else {
	        printf("Can't figure out what '%s' means!\n", *argv);
		exit(1);
	      }
	    }
	    *argv++; 
	    read_message[messages++] = num;
	  }

	sprintf(filename, "%s/%s", mailhome, getenv("LOGNAME"));

	if ((file = fopen(filename, "r")) == NULL) {
	  printf("You have no mail!\n");
	  exit(0);
	}
	else {
          /** one pass to get how many messages there are... **/
	  total = count_messages(file);
	  if (total == 0) {
	    printf("There aren't any messages to read!\n");
	    exit(0);
	  }
	  /** now let's have some fun! **/
	  while (fgets(buffer, SLEN, file) != NULL) {
	    if (strncmp(buffer, "From ", 5) == 0) {
	      if (current == read_message[current_in_queue])
	        current_in_queue++;
	      if (current_in_queue >= messages) exit(0);
	      current++;
	    }
	    if (current == read_message[current_in_queue]) 
	      printf("%s", buffer);
	    else if (current == total && read_message[current_in_queue] == 0)
	      printf("%s", buffer);
	  }
	}
	
	exit(0);
}

int
count_messages(file)
FILE *file;
{
	/** returns the number of messages in the file, and rewinds
	    the file too! **/

	char buffer[SLEN];
	int  count = 0;

	while (fgets(buffer, SLEN, file) != NULL)
	  if (strncmp(buffer, "From ", 5) == 0)
	    count++;

	rewind(file);

	return( count );
}
