/**		printmail.c		**/

/** print mail, adding a formfeed between each message **/

/** (C) Copyright 1985, Dave Taylor **/

#include <stdio.h>

#define  first_word(s,w)  (strncmp(s,w,strlen(w)) == 0)
#define  mailhome	  "/usr/mail"
#define  dashes		  \
"\n\n------------------------------------------------------------------------------\n\n"
#define  FF	  	  "\014"	/* form feed! */

FILE *mailfile;
char  separator[80];

main(argc, argv)
int argc;
char *argv[];
{
	char infile[80], username[40], c;

	strcpy(separator, FF);

	if (argc > 1) 
	  if (strcmp(argv[1], "-d") == 0) {
	    strcpy(separator, dashes);
	    --argc;
	    *argv++;
	  }
	
	if (argc > 1)
	  if (argv[1][0] == '-') 
	    exit(fprintf(stderr, "Usage: %s {-d} {filename}\n", argv[0]));
	
	if (argc == 1) {
	  strcpy(username, getlogin());
	  if (strlen(username) == 0)
	    cuserid(username);
	  sprintf(infile,"%s/%s",mailhome, username);
	  if ((mailfile = fopen(infile,"r")) == NULL)
	    fprintf(stderr, "No mail!\n");
	  else if (read_headers()==0)
	      fprintf(stderr, "No messages in mailbox!\n");
	}

	while (--argc) {
	  if ((mailfile = fopen(*argv,"r")) == NULL)
	    fprintf(stderr, "Could not open file '%s'!", *argv);
	  else
	    if (read_headers()==0)
	      fprintf(stderr, "No messages in mailbox '%s'!\n", *argv);
	  *argv++;
	  if (argc) {
	    printf("%s", separator);
	    printf("%s", separator);
	  }
	}
}

int
read_headers()
{
	char buffer[100];
	register int count = 0;

	while (fgets(buffer, 100, mailfile) != NULL) 
	  if (first_word(buffer,"From ")) {
	    if (real_from(buffer)) {
	      printf("%s%s", count ? separator : "", buffer);
	      count++;
	    }
	  }
	  else
	    printf("%s", buffer);

	return(count);
}

int
real_from(buffer)
char *buffer;
{
	/***** returns true iff 's' has the seven 'from' fields *****/

	char junk[80];

	junk[0] = '\0';
	sscanf(buffer, "%*s %*s %*s %*s %*s %*s %s", junk);
	return(junk[0] != '\0');
}
