/**		utils.c		**/

/** Utility routines for MSG 

    All routines herein: (C) Copyright 1985 Dave Taylor
**/

#include "headers.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>

#ifdef BSD
#undef tolower
#endif

#include <signal.h>
#include <errno.h>

emergency_exit()
{
	/** used in dramatic cases when we must leave without altering
	    ANYTHING about the system... **/

	Raw(OFF);
	if (cursor_control)  transmit_functions(OFF);
	if (hp_terminal)     softkeys_off();

	if (cursor_control)
	  MoveCursor(LINES, 0);

	printf("\n\rEmergency Exit taken!  All temp files intact!\n\r\n\r");

	exit(1);
}

leave(val)
int val;	/* not used, placeholder for signal catching! */
{
	char buffer[SLEN];

	dprint1("leave(%d)\n", val);

	Raw(OFF);
	if (cursor_control)  transmit_functions(OFF);
	if (hp_terminal)     softkeys_off();

	sprintf(buffer,"%s%d",temp_file, getpid());  /* editor buffer */
	(void) unlink(buffer);

	if (! mail_only) {
	  sprintf(buffer,"%s%d",temp_file, getpid()+1);  /* editor buffer */
	  (void) unlink(buffer);
	}

	sprintf(buffer,"%s%s",temp_mbox, username);  /* temp mailbox */
	(void) unlink(buffer);

	sprintf(buffer,"%s%s.lock",mailhome, username); /* lock file */
	(void) unlink(buffer);

	if (! mail_only)
	  MoveCursor(LINES-1,0);
	putchar('\n');

	exit(0);
}

leave_locked(val)
int val;	/* not used, placeholder for signal catching! */
{
	/** same as leave routine, but don't disturb lock file **/

	char buffer[SLEN];

	dprint1("leave_locked(%d)\n", val);

	Raw(OFF);
	if (cursor_control)  transmit_functions(OFF);
	if (hp_terminal)     softkeys_off();

	sprintf(buffer,"%s%d",temp_file, getpid());  /* editor buffer */
	(void) unlink(buffer);

	sprintf(buffer,"%s%d",temp_file, getpid()+1);  /* editor buffer */
	(void) unlink(buffer);

	sprintf(buffer,"%s%s",temp_mbox, username);  /* temp mailbox */
	(void) unlink(buffer);

	MoveCursor(LINES-1,0);
	putchar('\n');

	exit(0);
}

int
get_page(current)
int current;
{
	/** ensure that 'current' is on the displayed page,
	    returning non-zero iff the page changed! **/

	register int first_on_page, last_on_page;

	first_on_page = (header_page * headers_per_page) + 1;

	last_on_page = first_on_page + headers_per_page - 1;

	if (current > last_on_page) {
	  header_page = (int) (current-1) / headers_per_page;
	  return(1);
	}
	else if (current < first_on_page) {
	  header_page = (int) (current-1) / headers_per_page;
	  return(1);
	}
	else
	  return(0);
}

int
copy_to_self(buffer)
char *buffer;
{
	/** returns true iff buffer = 'Cc: username' where username
	    is the account name of the person sending the message.
	    Used for weeding out 'Cc:' lines from the messages if
	    'weed' is turned on. **/

	/** note: tail_of() is located in file "strings.c"  **/

	char name[SLEN], buf[SLEN];
	register int i=0, j=0;
	
	dprint1("copy_to_self(%s)\n", buffer);
	
	tail_of(header_table[current-1].from, name, FALSE);

	while (name[i] != '!' && i < strlen(name))
	   i++;

	if (name[i] == '!') {
	  for (i++; i < strlen(name); i++)
	    name[j++] = name[i];

	  name[j] = 0;
	}

	sprintf(buf, "Cc: %s\n", name);

	return( strcmp(buf, buffer) == 0 );
}
