/**		screen.c		**/

/**  screen display routines for MSG program 

     (C) Copyright 1985, Dave Taylor
**/

#include "headers.h"

static   int  last_current	 = -1;

showscreen()
{
	char buffer[SLEN];

	dprint0("showscreen()\n");

	ClearScreen();

	if (notesfile) 
	  sprintf(buffer, "Notes from '%s' (%d note%s) [Version %s]",
	        infile, message_count, 
		plural(message_count), VERSION);
	else 
	  sprintf(buffer, "Mailbox is '%s' with %d message%s [Version %s]",
	        infile, message_count, 
		plural(message_count), VERSION);
	Centerline(1, buffer);

	last_header_page = -1;	 	/* force a redraw regardless */
	show_headers();

	if (mini_menu)
	  show_menu();

	show_last_error();
	
	if (hp_terminal) 
	  define_softkeys(MAIN);
}

show_menu()
{
	/** write main system menu... **/

	Centerline(LINES-7,
  "|=pipe, !=shell, ?=help, <n>=set current to n, /=search pattern");
        Centerline(LINES-6,
  "A)lias, C)hange mailbox, D)elete, F)orward, G)roup reply, M)ail,"); 
	Centerline(LINES-5,
   "N)ext, P)rint, R)eply, S)ave to file, Q)uit, U)ndelete, or eX)it");
}

int
show_headers()
{
	/** display page of headers (10) if present.  First check to 
	    ensure that header_page is in bounds, fixing silently if not.
	    If out of bounds, return zero, else return non-zero **/

	register int first = 0, line = 4, last = 0, last_line;
	char newfrom[SLEN], buffer[SLEN];
	
	dprint0("show_headers()\n");

	if (fix_header_page())
	  return(FALSE);

	if (header_page == last_header_page) 	/* nothing to do! */
	  return(FALSE);

	/** compute last header to display **/

	first= header_page * headers_per_page;

	last = first + (headers_per_page - 1);

	if (last >= message_count) last = message_count-1;

	dprint2("\tdisplaying headers %d thru %d\n", first, last);

	/** okay, now let's show the header page! **/

	while (first <= last) {
	  tail_of(header_table[first].from, newfrom, TRUE); 
	  build_header_line(buffer, &header_table[first], first+1, newfrom);
	  PutLine(line,COLUMNS-80,"%s", buffer);	/* avoid '%' probs */
	  CleartoEOLN();
	  first++;
	  line++;	/* for clearing up in a sec... */
	}
	
	/* clear up the rest of the screen! */

	if (mini_menu)
	  last_line = LINES-8;
	else
	  last_line = LINES-3;

	while (line < last_line) {
	  MoveCursor(line,0);
	  CleartoEOLN();
	  line++;
	}

	display_central_message();

	last_current = current;
	last_header_page = header_page;

	return(TRUE);
}

show_current()
{
	/** display page of headers (10) if present.  First check to 
	    ensure that header_page is in bounds, fixing silently if not.
	    Note that this will ensure that 'current' is always set to
	    the top message on the screen if we go to a new screen! **/

	register int first = 0, last = 0, line = 4, changed;
	
	dprint0("show_current()\n");

	changed = fix_header_page();

	/** compute last header to display **/

	first = header_page * headers_per_page;
	last  = first + (headers_per_page - 1);

	if (last > message_count) 
	  last = message_count;

	/** okay, now let's show the pointers... **/

	/** have we changed??? **/

	if (current == last_current) {
	  dprint0("\tno change.  at same message!\n");
	  return;
	}

	/** first condition - current on this page & last too */

	if (last_current >= first && last_current <= last+1) {
	  dprint2("\tMoving arrow from %d to (current) %d\n",
	           last_current, current);
	  PutLine(((last_current-1) % headers_per_page) + 4, COLUMNS-76,"  ");
	  PutLine(((current-1) % headers_per_page) + 4, COLUMNS-76,"<-");
	}
	
	/** second condition - current on this page **/
	else if (! changed) {
	  dprint1("\tMoving arrow to (current) %d\n", current);
	  PutLine(((current-1) % headers_per_page) + 4, COLUMNS-76,"<-");
	}

	/** third condition - page changed!	    **/
	else {
          dprint2("\tdisplaying from message %d to %d\n", first, last);

	  while (first <= last) {
	    if (current-1 == first)   PutLine(line++,COLUMNS-76,"<-");
 	    else	  	      PutLine(line++,COLUMNS-76,"  ");
	    first++;
	  }
	}
	last_current = current;
}

build_header_line(buffer, entry, number, from)
char *buffer;
struct header_rec *entry;
int number;
char *from;
{
	/** Build in buffer the message header ... entry is the current
	    message entry, number is the numerical ID of the message,
	    and 'from' is a modified (displayable) from line... **/

	/** Note: using 'strncpy' allows us to output as much of the
	    subject line as possible given the dimensions of the screen.
	    The key is that 'strncpy' returns a 'char *' to the string
	    that it is handing to the dummy variable!  Neat, eh? **/
	
	char subj[LONG_SLEN];		/* to output subject */

	strncpy(subj, entry->subject, COLUMNS-34);

	subj[COLUMNS-34] = '\0';	/* insurance, eh? */

	sprintf(buffer, "%c%3d%s %c %3.3s %-2d %-18.18s  %s", 
	        (entry->priority? 'U' : new_msg(entry)? 'N' : ' '),
		number, (number == current? "<-" : "  "),
		(entry->delete? '*' : ' '), 
	        entry->month, atoi(entry->day), from, subj);
}

int
fix_header_page()
{
	/** this routine will check and ensure that the current header
	    page being displayed contains messages!  It will silently
	    fix 'header-page' if wrong.  Returns TRUE if changed.  **/

	int last_page, old_header;

	dprint1("fix_header_page() [%d messages total]\n", message_count);

	old_header = header_page;

	last_page = (int) ((message_count-1) / headers_per_page);
 
	dprint2("\tThere are 0 to %d pages in file [%d per page]\n", 
		last_page, headers_per_page);

	if (header_page > last_page) 
	  header_page = last_page;
	else if (header_page < 0) 
          header_page = 0;

	return(old_header != header_page);
}
